/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.internal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.ModelConstants;
import org.androidannotations.internal.InternalAndroidAnnotationsEnvironment;
import org.androidannotations.internal.core.CorePlugin;
import org.androidannotations.internal.exception.AndroidManifestNotFoundException;
import org.androidannotations.internal.exception.ProcessingException;
import org.androidannotations.internal.exception.RClassNotFoundException;
import org.androidannotations.internal.exception.VersionMismatchException;
import org.androidannotations.internal.exception.VersionNotFoundException;
import org.androidannotations.internal.generation.CodeModelGenerator;
import org.androidannotations.internal.helper.AndroidManifestFinder;
import org.androidannotations.internal.helper.ErrorHelper;
import org.androidannotations.internal.model.AnnotationElements;
import org.androidannotations.internal.model.AnnotationElementsHolder;
import org.androidannotations.internal.model.ModelExtractor;
import org.androidannotations.internal.process.ModelProcessor;
import org.androidannotations.internal.process.ModelValidator;
import org.androidannotations.internal.process.TimeStats;
import org.androidannotations.internal.rclass.AndroidRClassFinder;
import org.androidannotations.internal.rclass.CompoundRClass;
import org.androidannotations.internal.rclass.ProjectRClassFinder;
import org.androidannotations.logger.Level;
import org.androidannotations.logger.Logger;
import org.androidannotations.logger.LoggerContext;
import org.androidannotations.logger.LoggerFactory;
import org.androidannotations.plugin.AndroidAnnotationsPlugin;
import org.androidannotations.rclass.IRClass;

public class AndroidAnnotationProcessor
extends AbstractProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AndroidAnnotationProcessor.class);
    private String coreVersion;
    private final TimeStats timeStats = new TimeStats();
    private final ErrorHelper errorHelper = new ErrorHelper();
    private InternalAndroidAnnotationsEnvironment androidAnnotationsEnv;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.androidAnnotationsEnv = new InternalAndroidAnnotationsEnvironment(processingEnv);
        ModelConstants.init(this.androidAnnotationsEnv);
        LoggerContext loggerContext = LoggerContext.getInstance();
        loggerContext.setEnvironment(this.androidAnnotationsEnv);
        try {
            CorePlugin corePlugin = new CorePlugin();
            corePlugin.loadVersion();
            this.coreVersion = corePlugin.getVersion();
            LOGGER.info("Initialize AndroidAnnotations {} with options {}", this.coreVersion, processingEnv.getOptions());
            List<AndroidAnnotationsPlugin> plugins = this.loadPlugins();
            plugins.add(0, corePlugin);
            this.androidAnnotationsEnv.setPlugins(plugins);
        }
        catch (Exception e) {
            LOGGER.error(e, "Can't load plugins", new Object[0]);
        }
    }

    private List<AndroidAnnotationsPlugin> loadPlugins() throws FileNotFoundException, VersionNotFoundException {
        ServiceLoader<AndroidAnnotationsPlugin> serviceLoader = ServiceLoader.load(AndroidAnnotationsPlugin.class, AndroidAnnotationsPlugin.class.getClassLoader());
        ArrayList<AndroidAnnotationsPlugin> plugins = new ArrayList<AndroidAnnotationsPlugin>();
        for (AndroidAnnotationsPlugin plugin : serviceLoader) {
            plugins.add(plugin);
            if (!plugin.shouldCheckApiAndProcessorVersions()) continue;
            plugin.loadVersion();
        }
        LOGGER.info("Plugins loaded: {}", Arrays.toString(plugins.toArray()));
        return plugins;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.timeStats.clear();
        this.timeStats.start("Whole Processing");
        Set<? extends Element> rootElements = roundEnv.getRootElements();
        if (LOGGER.isLoggable(Level.TRACE)) {
            LOGGER.trace("Start processing for {} annotations {} on {} elements {}", annotations.size(), annotations, rootElements.size(), rootElements);
        } else {
            LOGGER.info("Start processing for {} annotations on {} elements", annotations.size(), rootElements.size());
        }
        try {
            this.checkApiAndProcessorVersions();
            this.processThrowing(annotations, roundEnv);
        }
        catch (ProcessingException e) {
            this.handleException(annotations, roundEnv, e);
        }
        catch (Exception e) {
            this.handleException(annotations, roundEnv, new ProcessingException(e, null));
        }
        this.timeStats.stop("Whole Processing");
        this.timeStats.logStats();
        LOGGER.info("Finish processing", new Object[0]);
        LoggerContext.getInstance().close(roundEnv.processingOver());
        return true;
    }

    private void checkApiAndProcessorVersions() throws VersionMismatchException {
        for (AndroidAnnotationsPlugin plugin : this.androidAnnotationsEnv.getPlugins()) {
            if (!plugin.shouldCheckApiAndProcessorVersions() || plugin.getApiVersion().equals(plugin.getVersion())) continue;
            LOGGER.error("{} version for API ({}) and processor ({}) don't match. Please check your classpath", plugin.getName(), plugin.getApiVersion(), plugin.getVersion());
            throw new VersionMismatchException(plugin.getName() + "version for API (" + plugin.getApiVersion() + ") and core (" + plugin.getVersion() + ") don't match. Please check your classpath");
        }
    }

    private void processThrowing(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws Exception {
        if (this.nothingToDo(annotations, roundEnv)) {
            return;
        }
        AnnotationElementsHolder extractedModel = this.extractAnnotations(annotations, roundEnv);
        this.androidAnnotationsEnv.setExtractedElements(extractedModel);
        AnnotationElementsHolder validatingHolder = extractedModel.validatingHolder();
        this.androidAnnotationsEnv.setValidatedElements(validatingHolder);
        try {
            AndroidManifest androidManifest = this.extractAndroidManifest();
            LOGGER.info("AndroidManifest.xml found: {}", androidManifest);
            IRClass rClass = this.findRClasses(androidManifest);
            this.androidAnnotationsEnv.setAndroidEnvironment(rClass, androidManifest);
        }
        catch (Exception e) {
            return;
        }
        AnnotationElements validatedModel = this.validateAnnotations(extractedModel, validatingHolder);
        ModelProcessor.ProcessResult processResult = this.processAnnotations(validatedModel);
        this.generateSources(processResult);
    }

    private boolean nothingToDo(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return roundEnv.processingOver() || annotations.size() == 0;
    }

    private AnnotationElementsHolder extractAnnotations(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.timeStats.start("Extract Annotations");
        ModelExtractor modelExtractor = new ModelExtractor();
        AnnotationElementsHolder extractedModel = modelExtractor.extract(annotations, this.getSupportedAnnotationTypes(), roundEnv);
        this.timeStats.stop("Extract Annotations");
        return extractedModel;
    }

    private AndroidManifest extractAndroidManifest() throws AndroidManifestNotFoundException {
        try {
            this.timeStats.start("Extract Manifest");
            AndroidManifest androidManifest = new AndroidManifestFinder(this.androidAnnotationsEnv).extractAndroidManifest();
            return androidManifest;
        }
        finally {
            this.timeStats.stop("Extract Manifest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRClass findRClasses(AndroidManifest androidManifest) throws RClassNotFoundException {
        try {
            this.timeStats.start("Find R Classes");
            IRClass rClass = new ProjectRClassFinder(this.androidAnnotationsEnv).find(androidManifest);
            IRClass androidRClass = new AndroidRClassFinder(this.processingEnv).find();
            CompoundRClass compoundRClass = new CompoundRClass(rClass, androidRClass);
            return compoundRClass;
        }
        finally {
            this.timeStats.stop("Find R Classes");
        }
    }

    private AnnotationElements validateAnnotations(AnnotationElements extractedModel, AnnotationElementsHolder validatingHolder) {
        this.timeStats.start("Validate Annotations");
        ModelValidator modelValidator = new ModelValidator(this.androidAnnotationsEnv);
        AnnotationElements validatedAnnotations = modelValidator.validate(extractedModel, validatingHolder);
        this.timeStats.stop("Validate Annotations");
        return validatedAnnotations;
    }

    private ModelProcessor.ProcessResult processAnnotations(AnnotationElements validatedModel) throws Exception {
        this.timeStats.start("Process Annotations");
        ModelProcessor modelProcessor = new ModelProcessor(this.androidAnnotationsEnv);
        ModelProcessor.ProcessResult processResult = modelProcessor.process(validatedModel);
        this.timeStats.stop("Process Annotations");
        return processResult;
    }

    private void generateSources(ModelProcessor.ProcessResult processResult) throws IOException {
        this.timeStats.start("Generate Sources");
        LOGGER.info("Number of files generated by AndroidAnnotations: {}", processResult.codeModel.countArtifacts());
        CodeModelGenerator modelGenerator = new CodeModelGenerator(this.processingEnv.getFiler(), this.coreVersion, this.androidAnnotationsEnv.getOptionValue(CodeModelGenerator.OPTION_ENCODING));
        modelGenerator.generate(processResult);
        this.timeStats.stop("Generate Sources");
    }

    private void handleException(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv, ProcessingException e) {
        String errorMessage = this.errorHelper.getErrorMessage(this.processingEnv, e, this.coreVersion);
        Iterator<? extends TypeElement> iterator = annotations.iterator();
        if (iterator.hasNext()) {
            Element element = roundEnv.getElementsAnnotatedWith(iterator.next()).iterator().next();
            LOGGER.error(element, "Something went wrong: {}", errorMessage);
        } else {
            LOGGER.error("Something went wrong: {}", errorMessage);
        }
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return this.androidAnnotationsEnv.getSupportedAnnotationTypes();
    }

    @Override
    public Set<String> getSupportedOptions() {
        return this.androidAnnotationsEnv.getSupportedOptions();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }
}

