/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.holder;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import org.androidannotations.helper.ModelConstants;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.holder.GeneratedClassHolderDelegate;
import org.androidannotations.holder.HasInstanceState;

public class ViewInstanceStateDelegate
extends GeneratedClassHolderDelegate<EComponentHolder>
implements HasInstanceState {
    private JVar instanceStateKey;
    private JBlock saveStateMethodBody;
    private JVar saveStateBundleParam;
    private JMethod restoreStateMethod;
    private JBlock restoreStateMethodBody;
    private JVar restoreStateBundleParam;

    public ViewInstanceStateDelegate(EComponentHolder holder) {
        super(holder);
    }

    @Override
    public JBlock getSaveStateMethodBody() {
        if (this.saveStateMethodBody == null) {
            this.setSaveStateMethod();
        }
        return this.saveStateMethodBody;
    }

    @Override
    public JVar getSaveStateBundleParam() {
        if (this.saveStateBundleParam == null) {
            this.setSaveStateMethod();
        }
        return this.saveStateBundleParam;
    }

    private void setSaveStateMethod() {
        JMethod method = this.getGeneratedClass().method(1, (AbstractJType)this.getClasses().PARCELABLE, "onSaveInstanceState");
        method.annotate(Override.class);
        JMethod saveStateMethod = this.getGeneratedClass().method(4, (AbstractJType)this.codeModel().VOID, "saveInstanceState");
        this.saveStateBundleParam = saveStateMethod.param((AbstractJType)this.getClasses().BUNDLE, "bundle");
        this.saveStateMethodBody = saveStateMethod.body();
        JBlock methodBody = method.body();
        JVar onSaveSuperInstanceState = methodBody.decl((AbstractJType)this.getClasses().PARCELABLE, "instanceState", (IJExpression)JExpr._super().invoke("onSaveInstanceState"));
        JVar bundleParam = methodBody.decl((AbstractJType)this.getClasses().BUNDLE, "bundle" + ModelConstants.generationSuffix(), (IJExpression)JExpr._new((AbstractJClass)this.getClasses().BUNDLE));
        methodBody.invoke((IJExpression)bundleParam, "putParcelable").arg((IJExpression)this.getInstanceStateKey()).arg((IJExpression)onSaveSuperInstanceState);
        methodBody.invoke(saveStateMethod).arg((IJExpression)bundleParam);
        methodBody._return((IJExpression)bundleParam);
    }

    @Override
    public JMethod getRestoreStateMethod() {
        if (this.restoreStateMethod == null) {
            this.setRestoreStateMethod();
        }
        return this.restoreStateMethod;
    }

    @Override
    public JBlock getRestoreStateMethodBody() {
        if (this.restoreStateMethodBody == null) {
            this.setRestoreStateMethod();
        }
        return this.restoreStateMethodBody;
    }

    @Override
    public JVar getRestoreStateBundleParam() {
        if (this.restoreStateBundleParam == null) {
            this.setRestoreStateMethod();
        }
        return this.restoreStateBundleParam;
    }

    private void setRestoreStateMethod() {
        this.restoreStateMethod = this.getGeneratedClass().method(1, (AbstractJType)this.codeModel().VOID, "onRestoreInstanceState");
        this.restoreStateMethod.annotate(Override.class);
        JVar state = this.restoreStateMethod.param((AbstractJType)this.getClasses().PARCELABLE, "state");
        JBlock body = this.restoreStateMethod.body();
        this.restoreStateBundleParam = body.decl((AbstractJType)this.getClasses().BUNDLE, "bundle" + ModelConstants.generationSuffix(), (IJExpression)JExpr.cast((AbstractJType)this.getClasses().BUNDLE, (IJExpression)state));
        JVar instanceState = body.decl((AbstractJType)this.getClasses().PARCELABLE, "instanceState", (IJExpression)this.restoreStateBundleParam.invoke("getParcelable").arg((IJExpression)this.getInstanceStateKey()));
        this.restoreStateMethodBody = body.blockSimple();
        body.invoke((IJExpression)JExpr._super(), "onRestoreInstanceState").arg((IJExpression)instanceState);
    }

    private JVar getInstanceStateKey() {
        if (this.instanceStateKey == null) {
            this.instanceStateKey = this.getGeneratedClass().field(25, (AbstractJType)this.getClasses().STRING, "INSTANCE_STATE_KEY", (IJExpression)JExpr.lit((String)"instanceState"));
        }
        return this.instanceStateKey;
    }
}

