/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.holder;

import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JPrimitiveType;
import com.helger.jcodemodel.JVar;
import org.androidannotations.holder.EComponentWithViewSupportHolder;

public class TextWatcherHolder {
    private EComponentWithViewSupportHolder holder;
    private JVar textViewVariable;
    private JDefinedClass listenerClass;
    private JBlock beforeTextChangedBody;
    private JVar beforeTextChangedCharSequenceParam;
    private JVar beforeTextChangedStartParam;
    private JVar beforeTextChangedCountParam;
    private JVar beforeTextChangedAfterParam;
    private JBlock onTextChangedBody;
    private JVar onTextChangedCharSequenceParam;
    private JVar onTextChangedStartParam;
    private JVar onTextChangedBeforeParam;
    private JVar onTextChangedCountParam;
    private JBlock afterTextChangedBody;
    private JVar afterTextChangedEditableParam;

    public TextWatcherHolder(EComponentWithViewSupportHolder holder, JVar viewVariable, JDefinedClass onTextChangeListenerClass) {
        this.holder = holder;
        this.textViewVariable = viewVariable;
        this.listenerClass = onTextChangeListenerClass;
        this.createBeforeTextChanged();
        this.createOnTextChanged();
        this.createAfterTextChanged();
    }

    private void createBeforeTextChanged() {
        JPrimitiveType intClass = this.holder.getCodeModel().INT;
        JMethod beforeTextChangedMethod = this.listenerClass.method(1, (AbstractJType)this.holder.getCodeModel().VOID, "beforeTextChanged");
        beforeTextChangedMethod.annotate(Override.class);
        this.beforeTextChangedBody = beforeTextChangedMethod.body();
        this.beforeTextChangedCharSequenceParam = beforeTextChangedMethod.param((AbstractJType)this.holder.getClasses().CHAR_SEQUENCE, "s");
        this.beforeTextChangedStartParam = beforeTextChangedMethod.param((AbstractJType)intClass, "start");
        this.beforeTextChangedCountParam = beforeTextChangedMethod.param((AbstractJType)intClass, "count");
        this.beforeTextChangedAfterParam = beforeTextChangedMethod.param((AbstractJType)intClass, "after");
    }

    private void createOnTextChanged() {
        JPrimitiveType intClass = this.holder.getCodeModel().INT;
        JMethod onTextChangedMethod = this.listenerClass.method(1, (AbstractJType)this.holder.getCodeModel().VOID, "onTextChanged");
        onTextChangedMethod.annotate(Override.class);
        this.onTextChangedBody = onTextChangedMethod.body();
        this.onTextChangedCharSequenceParam = onTextChangedMethod.param((AbstractJType)this.holder.getClasses().CHAR_SEQUENCE, "s");
        this.onTextChangedStartParam = onTextChangedMethod.param((AbstractJType)intClass, "start");
        this.onTextChangedBeforeParam = onTextChangedMethod.param((AbstractJType)intClass, "before");
        this.onTextChangedCountParam = onTextChangedMethod.param((AbstractJType)intClass, "count");
    }

    private void createAfterTextChanged() {
        JMethod afterTextChangedMethod = this.listenerClass.method(1, (AbstractJType)this.holder.getCodeModel().VOID, "afterTextChanged");
        afterTextChangedMethod.annotate(Override.class);
        this.afterTextChangedBody = afterTextChangedMethod.body();
        this.afterTextChangedEditableParam = afterTextChangedMethod.param((AbstractJType)this.holder.getClasses().EDITABLE, "s");
    }

    public JVar getTextViewVariable() {
        return this.textViewVariable;
    }

    public JBlock getBeforeTextChangedBody() {
        return this.beforeTextChangedBody;
    }

    public JVar getBeforeTextChangedCharSequenceParam() {
        return this.beforeTextChangedCharSequenceParam;
    }

    public JVar getBeforeTextChangedStartParam() {
        return this.beforeTextChangedStartParam;
    }

    public JVar getBeforeTextChangedCountParam() {
        return this.beforeTextChangedCountParam;
    }

    public JVar getBeforeTextChangedAfterParam() {
        return this.beforeTextChangedAfterParam;
    }

    public JBlock getOnTextChangedBody() {
        return this.onTextChangedBody;
    }

    public JVar getOnTextChangedCharSequenceParam() {
        return this.onTextChangedCharSequenceParam;
    }

    public JVar getOnTextChangedStartParam() {
        return this.onTextChangedStartParam;
    }

    public JVar getOnTextChangedBeforeParam() {
        return this.onTextChangedBeforeParam;
    }

    public JVar getOnTextChangedCountParam() {
        return this.onTextChangedCountParam;
    }

    public JBlock getAfterTextChangedBody() {
        return this.afterTextChangedBody;
    }

    public JVar getAfterTextChangedEditableParam() {
        return this.afterTextChangedEditableParam;
    }
}

