/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.holder;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JClassAlreadyExistsException;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.api.sharedpreferences.BooleanPrefEditorField;
import org.androidannotations.api.sharedpreferences.EditorHelper;
import org.androidannotations.api.sharedpreferences.FloatPrefEditorField;
import org.androidannotations.api.sharedpreferences.IntPrefEditorField;
import org.androidannotations.api.sharedpreferences.LongPrefEditorField;
import org.androidannotations.api.sharedpreferences.SharedPreferencesHelper;
import org.androidannotations.api.sharedpreferences.StringPrefEditorField;
import org.androidannotations.api.sharedpreferences.StringPrefField;
import org.androidannotations.api.sharedpreferences.StringSetPrefEditorField;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.helper.ModelConstants;
import org.androidannotations.holder.BaseGeneratedClassHolder;

public class SharedPrefHolder
extends BaseGeneratedClassHolder {
    private static final Map<String, EditorFieldHolder> EDITOR_FIELD_BY_TYPE = new HashMap<String, EditorFieldHolder>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("boolean", new EditorFieldHolder(BooleanPrefEditorField.class, "booleanField"));
            this.put("float", new EditorFieldHolder(FloatPrefEditorField.class, "floatField"));
            this.put("int", new EditorFieldHolder(IntPrefEditorField.class, "intField"));
            this.put("long", new EditorFieldHolder(LongPrefEditorField.class, "longField"));
            this.put(CanonicalNameConstants.STRING, new EditorFieldHolder(StringPrefEditorField.class, "stringField"));
            this.put("java.util.Set<java.lang.String>", new EditorFieldHolder(StringSetPrefEditorField.class, "stringSetField"));
        }
    };
    private JMethod constructor;
    private JBlock constructorSuperBlock;
    private JVar constructorContextParam;
    private JFieldVar contextField;
    private JDefinedClass editorClass;
    private JFieldVar editorContextField;
    private JMethod editorConstructor;
    private JInvocation editMethodEditorInvocation;

    public SharedPrefHolder(AndroidAnnotationsEnvironment environment, TypeElement annotatedElement) throws Exception {
        super(environment, annotatedElement);
        this.createEditorClass();
        this.createEditMethod();
    }

    @Override
    protected void setExtends() {
        this.generatedClass._extends(SharedPreferencesHelper.class);
    }

    private void createEditorClass() throws JClassAlreadyExistsException {
        String interfaceSimpleName = this.annotatedElement.getSimpleName().toString();
        this.editorClass = (JDefinedClass)this.generatedClass._class(25, interfaceSimpleName + "Editor" + ModelConstants.classSuffix());
        this.editorClass._extends((AbstractJClass)this.getJClass(EditorHelper.class).narrow((AbstractJClass)this.editorClass));
        this.createEditorConstructor();
    }

    private void createEditorConstructor() {
        this.editorConstructor = this.editorClass.constructor(0);
        AbstractJClass sharedPreferencesClass = this.getJClass("android.content.SharedPreferences");
        JVar sharedPreferencesParam = this.editorConstructor.param((AbstractJType)sharedPreferencesClass, "sharedPreferences");
        this.editorConstructor.body().invoke("super").arg((IJExpression)sharedPreferencesParam);
    }

    private void createEditMethod() {
        JMethod editMethod = this.generatedClass.method(1, (AbstractJType)this.editorClass, "edit");
        this.editMethodEditorInvocation = JExpr._new((AbstractJClass)this.editorClass).arg((IJExpression)JExpr.invoke((String)"getSharedPreferences"));
        editMethod.body()._return((IJExpression)this.editMethodEditorInvocation);
    }

    public void createFieldMethod(Class<?> prefFieldHelperClass, IJExpression keyExpression, String fieldName, String fieldHelperMethodName, IJExpression defaultValue, String docComment, String defaultValueStr) {
        JMethod fieldMethod = this.generatedClass.method(1, prefFieldHelperClass, fieldName);
        if (defaultValueStr != null) {
            boolean isStringPrefField = StringPrefField.class == prefFieldHelperClass;
            String defaultValueJavaDoc = isStringPrefField ? "\"" + defaultValueStr + "\"" : defaultValueStr;
            fieldMethod.javadoc().append((Object)("<p><b>Defaults to</b>: " + defaultValueJavaDoc + "</p>\n"));
        }
        this.codeModelHelper.addTrimmedDocComment(fieldMethod, docComment);
        fieldMethod.javadoc().addReturn().append((Object)("a {@link " + prefFieldHelperClass.getSimpleName() + "} instance to retrieve or write the pref value"));
        fieldMethod.body()._return((IJExpression)JExpr.invoke((String)fieldHelperMethodName).arg(keyExpression).arg(defaultValue));
    }

    public void createEditorFieldMethods(ExecutableElement method, IJExpression keyExpression) {
        String returnType = method.getReturnType().toString();
        EditorFieldHolder editorFieldHolder = EDITOR_FIELD_BY_TYPE.get(returnType);
        AbstractJClass editorFieldClass = this.getJClass(editorFieldHolder.fieldClass);
        String fieldName = method.getSimpleName().toString();
        JMethod editorFieldMethod = this.editorClass.method(1, (AbstractJType)editorFieldClass.narrow((AbstractJClass)this.editorClass), fieldName);
        String docComment = this.getProcessingEnvironment().getElementUtils().getDocComment(method);
        this.codeModelHelper.addTrimmedDocComment(editorFieldMethod, docComment);
        editorFieldMethod.body()._return((IJExpression)JExpr.invoke((String)editorFieldHolder.fieldMethodName).arg(keyExpression));
    }

    public JBlock getConstructorSuperBlock() {
        if (this.constructorSuperBlock == null) {
            this.setConstructor();
        }
        return this.constructorSuperBlock;
    }

    public JVar getConstructorContextParam() {
        if (this.constructorContextParam == null) {
            this.setConstructor();
        }
        return this.constructorContextParam;
    }

    public JMethod getConstructor() {
        if (this.constructor == null) {
            this.setConstructor();
        }
        return this.constructor;
    }

    private void setConstructor() {
        this.constructor = this.generatedClass.constructor(1);
        this.constructorContextParam = this.constructor.param((AbstractJType)this.getClasses().CONTEXT, "context");
        JBlock constructorBody = this.constructor.body();
        this.constructorSuperBlock = constructorBody.blockSimple();
    }

    public JFieldVar getContextField() {
        if (this.contextField == null) {
            this.setContextField();
        }
        return this.contextField;
    }

    protected void setContextField() {
        this.contextField = this.generatedClass.field(4, (AbstractJType)this.getClasses().CONTEXT, "context" + ModelConstants.generationSuffix());
        this.getConstructor().body().assign((IJAssignmentTarget)JExpr._this().ref((JVar)this.contextField), (IJExpression)this.getConstructorContextParam());
    }

    public JFieldVar getEditorContextField() {
        if (this.editorContextField == null) {
            this.setEditorContextField();
        }
        return this.editorContextField;
    }

    protected void setEditorContextField() {
        this.editorContextField = this.editorClass.field(4, (AbstractJType)this.getClasses().CONTEXT, "context" + ModelConstants.generationSuffix());
        JVar contextParam = this.editorConstructor.param((AbstractJType)this.getClasses().CONTEXT, "context");
        this.editorConstructor.body().assign((IJAssignmentTarget)JExpr._this().ref((JVar)this.editorContextField), (IJExpression)contextParam);
        this.editMethodEditorInvocation.arg((IJExpression)this.getContextField());
    }

    private static class EditorFieldHolder {
        public final Class<?> fieldClass;
        public final String fieldMethodName;

        EditorFieldHolder(Class<?> fieldClass, String fieldMethodName) {
            this.fieldClass = fieldClass;
            this.fieldMethodName = fieldMethodName;
        }
    }
}

