/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.holder;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JInvocation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.androidannotations.annotations.Receiver;
import org.androidannotations.helper.ModelConstants;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.holder.GeneratedClassHolderDelegate;
import org.androidannotations.holder.HasReceiverRegistration;

public class ReceiverRegistrationDelegate<T extends EComponentHolder>
extends GeneratedClassHolderDelegate<T> {
    private Map<IntentFilterData, JFieldVar> intentFilterFields = new HashMap<IntentFilterData, JFieldVar>();

    public ReceiverRegistrationDelegate(T holder) {
        super(holder);
    }

    public JFieldVar getIntentFilterField(IntentFilterData intentFilterData) {
        JFieldVar intentFilterField = this.intentFilterFields.get(intentFilterData);
        if (intentFilterField == null) {
            intentFilterField = this.createIntentFilterField(intentFilterData);
            this.intentFilterFields.put(intentFilterData, intentFilterField);
        }
        return intentFilterField;
    }

    private JFieldVar createIntentFilterField(IntentFilterData intentFilterData) {
        String intentFilterName = "intentFilter" + (this.intentFilterFields.size() + 1) + ModelConstants.generationSuffix();
        JInvocation newIntentFilterExpr = JExpr._new((AbstractJClass)this.getClasses().INTENT_FILTER);
        JFieldVar intentFilterField = this.getGeneratedClass().field(12, (AbstractJType)this.getClasses().INTENT_FILTER, intentFilterName, (IJExpression)newIntentFilterExpr);
        JBlock intentFilterTarget = ((HasReceiverRegistration)((Object)((EComponentHolder)this.holder))).getIntentFilterInitializationBlock(intentFilterData);
        for (String action : intentFilterData.getActionSet()) {
            intentFilterTarget.invoke((IJExpression)intentFilterField, "addAction").arg(action);
        }
        for (String dataScheme : intentFilterData.getDataSchemeSet()) {
            intentFilterTarget.invoke((IJExpression)intentFilterField, "addDataScheme").arg(dataScheme);
        }
        return intentFilterField;
    }

    public static class IntentFilterData {
        private final Receiver.RegisterAt registerAt;
        private final Set<String> actionSet;
        private final Set<String> dataSchemeSet;

        public IntentFilterData(String[] actions, String[] dataSchemes, Receiver.RegisterAt registerAt) {
            this.registerAt = registerAt;
            this.actionSet = new HashSet<String>(Arrays.asList(actions));
            this.dataSchemeSet = new HashSet<String>(Arrays.asList(dataSchemes));
        }

        public Receiver.RegisterAt getRegisterAt() {
            return this.registerAt;
        }

        public Set<String> getActionSet() {
            return this.actionSet;
        }

        public Set<String> getDataSchemeSet() {
            return this.dataSchemeSet;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.actionSet == null ? 0 : this.actionSet.hashCode());
            result = 31 * result + (this.registerAt == null ? 0 : this.registerAt.hashCode());
            result = 31 * result + (this.dataSchemeSet == null ? 0 : this.dataSchemeSet.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IntentFilterData other = (IntentFilterData)obj;
            if (this.actionSet == null ? other.actionSet != null : !this.actionSet.equals(other.actionSet)) {
                return false;
            }
            if (this.registerAt == null ? other.registerAt != null : !this.registerAt.equals((Object)other.registerAt)) {
                return false;
            }
            return !(this.dataSchemeSet == null ? other.dataSchemeSet != null : !this.dataSchemeSet.equals(other.dataSchemeSet));
        }
    }
}

