/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.holder;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.holder.FoundPreferenceHolder;
import org.androidannotations.holder.GeneratedClassHolderDelegate;
import org.androidannotations.holder.HasPreferences;

public class PreferencesDelegate
extends GeneratedClassHolderDelegate<EComponentWithViewSupportHolder>
implements HasPreferences {
    protected JBlock addPreferencesFromResourceInjectionBlock;
    protected JBlock addPreferencesFromResourceAfterInjectionBlock;
    private boolean usingSupportV7Preference = false;
    private boolean usingAndroidxPreference = false;
    private AbstractJClass basePreferenceClass;

    public PreferencesDelegate(EComponentWithViewSupportHolder holder) {
        super(holder);
        Elements elementUtils = holder.getEnvironment().getProcessingEnvironment().getElementUtils();
        Types typeUtils = holder.getEnvironment().getProcessingEnvironment().getTypeUtils();
        TypeElement supportV7PreferenceFragmentCompat = elementUtils.getTypeElement("android.support.v7.preference.PreferenceFragmentCompat");
        TypeElement andoridxPreferenceFragmentCompat = elementUtils.getTypeElement("androidx.preference.PreferenceFragmentCompat");
        TypeElement supportV14PreferenceFragment = elementUtils.getTypeElement("android.support.v14.preference.PreferenceFragment");
        TypeElement andoridxPreferenceFragment = elementUtils.getTypeElement("androidx.preference.PreferenceFragment");
        TypeMirror annotatedType = holder.getAnnotatedElement().asType();
        if (andoridxPreferenceFragmentCompat != null && typeUtils.isSubtype(annotatedType, andoridxPreferenceFragmentCompat.asType()) || andoridxPreferenceFragment != null && typeUtils.isSubtype(annotatedType, andoridxPreferenceFragment.asType())) {
            this.usingAndroidxPreference = true;
            this.basePreferenceClass = this.getClasses().ANDROIDX_PREFERENCE;
        } else if (supportV7PreferenceFragmentCompat != null && typeUtils.isSubtype(annotatedType, supportV7PreferenceFragmentCompat.asType()) || supportV14PreferenceFragment != null && typeUtils.isSubtype(annotatedType, supportV14PreferenceFragment.asType())) {
            this.usingSupportV7Preference = true;
            this.basePreferenceClass = this.getClasses().SUPPORT_V7_PREFERENCE;
        } else {
            this.basePreferenceClass = this.getClasses().PREFERENCE;
        }
    }

    @Override
    public JBlock getAddPreferencesFromResourceInjectionBlock() {
        if (this.addPreferencesFromResourceInjectionBlock == null) {
            this.setAddPreferencesFromResourceBlock();
        }
        return this.addPreferencesFromResourceInjectionBlock;
    }

    @Override
    public JBlock getAddPreferencesFromResourceAfterInjectionBlock() {
        if (this.addPreferencesFromResourceAfterInjectionBlock == null) {
            this.setAddPreferencesFromResourceBlock();
        }
        return this.addPreferencesFromResourceAfterInjectionBlock;
    }

    private void setAddPreferencesFromResourceBlock() {
        JMethod method = this.getGeneratedClass().method(1, (AbstractJType)this.codeModel().VOID, "addPreferencesFromResource");
        method.annotate(Override.class);
        JVar preferencesResIdParam = method.param(Integer.TYPE, "preferencesResId");
        method.body().invoke((IJExpression)JExpr._super(), "addPreferencesFromResource").arg((IJExpression)preferencesResIdParam);
        this.addPreferencesFromResourceInjectionBlock = method.body().blockVirtual();
        this.addPreferencesFromResourceAfterInjectionBlock = method.body().blockVirtual();
    }

    private JInvocation findPreferenceByKey(JFieldRef idRef) {
        JInvocation getString = JExpr.invoke((IJExpression)JExpr._this(), (String)"getString").arg((IJExpression)idRef);
        JInvocation findPreferenceByKey = JExpr.invoke((IJExpression)JExpr._this(), (String)"findPreference");
        return findPreferenceByKey.arg((IJExpression)getString);
    }

    @Override
    public FoundPreferenceHolder getFoundPreferenceHolder(JFieldRef idRef, AbstractJClass preferenceClass) {
        return this.getFoundPreferenceHolder(idRef, preferenceClass, null);
    }

    @Override
    public FoundPreferenceHolder getFoundPreferenceHolder(JFieldRef idRef, AbstractJClass preferenceClass, IJAssignmentTarget fieldRef) {
        String idRefString = idRef.name();
        FoundPreferenceHolder foundPreferenceHolder = (FoundPreferenceHolder)((EComponentWithViewSupportHolder)this.holder).foundHolders.get(idRefString);
        if (foundPreferenceHolder == null) {
            foundPreferenceHolder = this.createFoundPreferenceAndIfNotNullBlock(idRef, preferenceClass, fieldRef);
            ((EComponentWithViewSupportHolder)this.holder).foundHolders.put(idRefString, foundPreferenceHolder);
        }
        return foundPreferenceHolder;
    }

    @Override
    public boolean usingSupportV7Preference() {
        return this.usingSupportV7Preference;
    }

    @Override
    public boolean usingAndroidxPreference() {
        return this.usingAndroidxPreference;
    }

    @Override
    public AbstractJClass getBasePreferenceClass() {
        return this.basePreferenceClass;
    }

    private FoundPreferenceHolder createFoundPreferenceAndIfNotNullBlock(JFieldRef idRef, AbstractJClass preferenceClass, IJAssignmentTarget fieldRef) {
        JInvocation findPreferenceExpression = this.findPreferenceByKey(idRef);
        JBlock block = this.getAddPreferencesFromResourceInjectionBlock();
        if (preferenceClass == null) {
            preferenceClass = this.basePreferenceClass;
        } else if (!preferenceClass.equals(this.basePreferenceClass)) {
            findPreferenceExpression = JExpr.cast((AbstractJType)preferenceClass, (IJExpression)findPreferenceExpression);
        }
        IJAssignmentTarget foundPref = fieldRef;
        if (foundPref == null) {
            foundPref = block.decl((AbstractJType)preferenceClass, "preference_" + idRef.name(), (IJExpression)findPreferenceExpression);
        } else {
            block.add((IJStatement)foundPref.assign((IJExpression)findPreferenceExpression));
        }
        return new FoundPreferenceHolder(this, preferenceClass, (IJExpression)foundPref, block);
    }

    @Override
    public JBlock getPreferenceScreenInitializationBlock() {
        throw new UnsupportedOperationException();
    }
}

