/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.holder;

import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JPrimitiveType;
import com.helger.jcodemodel.JVar;
import org.androidannotations.holder.EComponentWithViewSupportHolder;

public class PageChangeHolder {
    private EComponentWithViewSupportHolder holder;
    private JVar viewPagerVariable;
    private JDefinedClass listenerClass;
    private JBlock pageScrollStateChangedBody;
    private JVar pageScrollStateChangedStateParam;
    private JBlock pageScrolledBody;
    private JVar pageScrolledPositionParam;
    private JVar pageScrolledPositionOffsetParam;
    private JVar pageScrolledPositionOffsetPixelsParam;
    private JBlock pageSelectedBody;
    private JVar pageSelectedPositionParam;

    public PageChangeHolder(EComponentWithViewSupportHolder holder, JVar viewPagerVariable, JDefinedClass onPageChangeListenerClass) {
        this.holder = holder;
        this.viewPagerVariable = viewPagerVariable;
        this.listenerClass = onPageChangeListenerClass;
        this.createPageScrollStateChanged();
        this.createPageScroll();
        this.createPageSelected();
    }

    private void createPageScrollStateChanged() {
        JMethod method = this.listenerClass.method(1, (AbstractJType)this.holder.getCodeModel().VOID, "onPageScrollStateChanged");
        method.annotate(Override.class);
        this.pageScrollStateChangedBody = method.body();
        JPrimitiveType intClass = this.holder.getCodeModel().INT;
        this.pageScrollStateChangedStateParam = method.param((AbstractJType)intClass, "state");
    }

    private void createPageScroll() {
        JMethod method = this.listenerClass.method(1, (AbstractJType)this.holder.getCodeModel().VOID, "onPageScrolled");
        method.annotate(Override.class);
        this.pageScrolledBody = method.body();
        JPrimitiveType intClass = this.holder.getCodeModel().INT;
        this.pageScrolledPositionParam = method.param((AbstractJType)intClass, "position");
        this.pageScrolledPositionOffsetParam = method.param((AbstractJType)this.holder.getCodeModel().FLOAT, "positionOffset");
        this.pageScrolledPositionOffsetPixelsParam = method.param((AbstractJType)intClass, "positionOffsetPixels");
    }

    private void createPageSelected() {
        JMethod method = this.listenerClass.method(1, (AbstractJType)this.holder.getCodeModel().VOID, "onPageSelected");
        method.annotate(Override.class);
        this.pageSelectedBody = method.body();
        JPrimitiveType intClass = this.holder.getCodeModel().INT;
        this.pageSelectedPositionParam = method.param((AbstractJType)intClass, "position");
    }

    public JVar getViewPagerVariable() {
        return this.viewPagerVariable;
    }

    public JDefinedClass getListenerClass() {
        return this.listenerClass;
    }

    public JBlock getPageScrollStateChangedBody() {
        return this.pageScrollStateChangedBody;
    }

    public JVar getPageScrollStateChangedStateParam() {
        return this.pageScrollStateChangedStateParam;
    }

    public JBlock getPageScrolledBody() {
        return this.pageScrolledBody;
    }

    public JVar getPageScrolledPositionParam() {
        return this.pageScrolledPositionParam;
    }

    public JVar getPageScrolledPositionOffsetParam() {
        return this.pageScrolledPositionOffsetParam;
    }

    public JVar getPageScrolledPositionOffsetPixelsParam() {
        return this.pageScrolledPositionOffsetPixelsParam;
    }

    public JBlock getPageSelectedBody() {
        return this.pageSelectedBody;
    }

    public JVar getPageSelectedPositionParam() {
        return this.pageSelectedPositionParam;
    }
}

