/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.holder;

import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import org.androidannotations.holder.EComponentWithViewSupportHolder;

public class OnSeekBarChangeListenerHolder {
    private EComponentWithViewSupportHolder holder;
    private JDefinedClass listenerClass;
    private JBlock onProgressChangedBody;
    private JVar onProgressChangedSeekBarParam;
    private JVar onProgressChangedProgressParam;
    private JVar onProgressChangedFromUserParam;
    private JBlock onStartTrackingTouchBody;
    private JVar onStartTrackingTouchSeekBarParam;
    private JBlock onStopTrackingTouchBody;
    private JVar onStopTrackingTouchSeekBarParam;

    public OnSeekBarChangeListenerHolder(EComponentWithViewSupportHolder holder, JDefinedClass onSeekbarChangeListenerClass) {
        this.holder = holder;
        this.listenerClass = onSeekbarChangeListenerClass;
        this.createOnProgressChanged();
        this.createOnStartTrackingTouch();
        this.createOnStopTrackingTouch();
    }

    private void createOnProgressChanged() {
        JMethod onProgressChangedMethod = this.listenerClass.method(1, (AbstractJType)this.holder.getCodeModel().VOID, "onProgressChanged");
        onProgressChangedMethod.annotate(Override.class);
        this.onProgressChangedBody = onProgressChangedMethod.body();
        this.onProgressChangedSeekBarParam = onProgressChangedMethod.param((AbstractJType)this.holder.getClasses().SEEKBAR, "seekBar");
        this.onProgressChangedProgressParam = onProgressChangedMethod.param((AbstractJType)this.holder.getCodeModel().INT, "progress");
        this.onProgressChangedFromUserParam = onProgressChangedMethod.param((AbstractJType)this.holder.getCodeModel().BOOLEAN, "fromUser");
    }

    private void createOnStartTrackingTouch() {
        JMethod onStartTrackingTouchMethod = this.listenerClass.method(1, (AbstractJType)this.holder.getCodeModel().VOID, "onStartTrackingTouch");
        onStartTrackingTouchMethod.annotate(Override.class);
        this.onStartTrackingTouchBody = onStartTrackingTouchMethod.body();
        this.onStartTrackingTouchSeekBarParam = onStartTrackingTouchMethod.param((AbstractJType)this.holder.getClasses().SEEKBAR, "seekBar");
    }

    private void createOnStopTrackingTouch() {
        JMethod onStopTrackingTouchMethod = this.listenerClass.method(1, (AbstractJType)this.holder.getCodeModel().VOID, "onStopTrackingTouch");
        onStopTrackingTouchMethod.annotate(Override.class);
        this.onStopTrackingTouchBody = onStopTrackingTouchMethod.body();
        this.onStopTrackingTouchSeekBarParam = onStopTrackingTouchMethod.param((AbstractJType)this.holder.getClasses().SEEKBAR, "seekBar");
    }

    public JBlock getOnProgressChangedBody() {
        return this.onProgressChangedBody;
    }

    public JVar getOnProgressChangedSeekBarParam() {
        return this.onProgressChangedSeekBarParam;
    }

    public JVar getOnProgressChangedProgressParam() {
        return this.onProgressChangedProgressParam;
    }

    public JVar getOnProgressChangedFromUserParam() {
        return this.onProgressChangedFromUserParam;
    }

    public JBlock getOnStartTrackingTouchBody() {
        return this.onStartTrackingTouchBody;
    }

    public JVar getOnStartTrackingTouchSeekBarParam() {
        return this.onStartTrackingTouchSeekBarParam;
    }

    public JBlock getOnStopTrackingTouchBody() {
        return this.onStopTrackingTouchBody;
    }

    public JVar getOnStopTrackingTouchSeekBarParam() {
        return this.onStopTrackingTouchSeekBarParam;
    }
}

