/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.holder;

import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JCase;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JSwitch;
import com.helger.jcodemodel.JVar;
import java.util.HashMap;
import java.util.Map;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.holder.GeneratedClassHolderDelegate;

public class OnActivityResultDelegate
extends GeneratedClassHolderDelegate<EComponentHolder> {
    private JMethod method;
    private JBlock afterSuperBlock;
    private JSwitch zwitch;
    private JVar requestCodeParam;
    private JVar dataParam;
    private JVar resultCodeParam;
    private Map<Integer, JBlock> caseBlocks = new HashMap<Integer, JBlock>();

    public OnActivityResultDelegate(EComponentHolder holder) {
        super(holder);
    }

    public JMethod getMethod() {
        if (this.method == null) {
            this.setOnActivityResult();
        }
        return this.method;
    }

    public JVar getRequestCodeParam() {
        if (this.requestCodeParam == null) {
            this.setOnActivityResult();
        }
        return this.requestCodeParam;
    }

    public JVar getDataParam() {
        if (this.dataParam == null) {
            this.setOnActivityResult();
        }
        return this.dataParam;
    }

    public JVar getResultCodeParam() {
        if (this.dataParam == null) {
            this.setOnActivityResult();
        }
        return this.resultCodeParam;
    }

    public JBlock getCaseBlock(int requestCode) {
        JBlock onActivityResultCaseBlock = this.caseBlocks.get(requestCode);
        if (onActivityResultCaseBlock == null) {
            onActivityResultCaseBlock = this.createCaseBlock(requestCode);
            this.caseBlocks.put(requestCode, onActivityResultCaseBlock);
        }
        return onActivityResultCaseBlock;
    }

    private JBlock createCaseBlock(int requestCode) {
        JCase onActivityResultCase = this.getSwitch()._case((IJExpression)JExpr.lit((int)requestCode));
        JBlock onActivityResultCaseBlock = onActivityResultCase.body().blockSimple();
        onActivityResultCase.body()._break();
        return onActivityResultCaseBlock;
    }

    public JSwitch getSwitch() {
        if (this.zwitch == null) {
            this.setSwitch();
        }
        return this.zwitch;
    }

    private void setSwitch() {
        this.zwitch = this.getAfterSuperBlock()._switch((IJExpression)this.getRequestCodeParam());
    }

    public JBlock getAfterSuperBlock() {
        if (this.afterSuperBlock == null) {
            this.setOnActivityResult();
        }
        return this.afterSuperBlock;
    }

    private void setOnActivityResult() {
        this.method = ((EComponentHolder)this.holder).getGeneratedClass().method(1, (AbstractJType)this.codeModel().VOID, "onActivityResult");
        this.method.annotate(Override.class);
        this.requestCodeParam = this.method.param((AbstractJType)this.codeModel().INT, "requestCode");
        this.resultCodeParam = this.method.param((AbstractJType)this.codeModel().INT, "resultCode");
        this.dataParam = this.method.param((AbstractJType)this.getClasses().INTENT, "data");
        JBlock body = this.method.body();
        body.invoke((IJExpression)JExpr._super(), this.method).arg((IJExpression)this.requestCodeParam).arg((IJExpression)this.resultCodeParam).arg((IJExpression)this.dataParam);
        this.afterSuperBlock = body.blockSimple();
    }
}

