/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.holder;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAnnotatable;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJGenerifiable;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import java.util.ArrayList;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.helper.ModelConstants;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.holder.HasInstanceState;
import org.androidannotations.holder.HasReceiverRegistration;
import org.androidannotations.holder.ReceiverRegistrationDelegate;
import org.androidannotations.holder.ViewInstanceStateDelegate;

public class EViewHolder
extends EComponentWithViewSupportHolder
implements HasInstanceState,
HasReceiverRegistration {
    protected static final String ALREADY_INFLATED_COMMENT = "The alreadyInflated_ hack is needed because of an Android bug\nwhich leads to infinite calls of onFinishInflate()\nwhen inflating a layout with a parent and using\nthe <code>&lt;merge /&gt;</code> tag.";
    private static final String SUPPRESS_WARNING_COMMENT = "We use @SuppressWarning here because our java code\ngenerator doesn't know that there is no need\nto import OnXXXListeners from View as we already\nare in a View.";
    private JMethod onAttachedToWindowMethod;
    private JBlock onAttachedToWindowAfterSuperBlock;
    private JMethod onDetachedFromWindowMethod;
    private JBlock onDetachedFromWindowBeforeSuperBlock;
    private ReceiverRegistrationDelegate<EViewHolder> receiverRegistrationDelegate;
    private ViewInstanceStateDelegate instanceStateDelegate;
    protected JBlock initBody;
    protected JMethod onFinishInflate;
    protected JFieldVar alreadyInflated;

    public EViewHolder(AndroidAnnotationsEnvironment environment, TypeElement annotatedElement) throws Exception {
        super(environment, annotatedElement);
        this.addSuppressWarning();
        this.createConstructorAndBuilder();
        this.receiverRegistrationDelegate = new ReceiverRegistrationDelegate<EViewHolder>(this);
        this.instanceStateDelegate = new ViewInstanceStateDelegate(this);
    }

    private void addSuppressWarning() {
        this.generatedClass.javadoc().append((Object)SUPPRESS_WARNING_COMMENT);
        this.codeModelHelper.addSuppressWarnings((IJAnnotatable)this.getGeneratedClass(), "unused");
    }

    private void createConstructorAndBuilder() {
        ArrayList<ExecutableElement> constructors = new ArrayList<ExecutableElement>();
        for (Element element : this.annotatedElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.CONSTRUCTOR) continue;
            constructors.add((ExecutableElement)element);
        }
        for (ExecutableElement executableElement : constructors) {
            JMethod copyConstructor = this.generatedClass.constructor(1);
            JMethod staticHelper = this.generatedClass.method(17, (AbstractJType)this.generatedClass._extends(), "build");
            this.codeModelHelper.generify((IJGenerifiable)staticHelper, this.getAnnotatedElement());
            JBlock body = copyConstructor.body();
            JInvocation superCall = body.invoke("super");
            AbstractJClass narrowedGeneratedClass = this.narrow((AbstractJClass)this.generatedClass);
            JInvocation newInvocation = JExpr._new((AbstractJClass)narrowedGeneratedClass);
            for (VariableElement variableElement : executableElement.getParameters()) {
                String paramName = variableElement.getSimpleName().toString();
                AbstractJClass paramType = this.codeModelHelper.typeMirrorToJClass(variableElement.asType());
                copyConstructor.param((AbstractJType)paramType, paramName);
                staticHelper.param((AbstractJType)paramType, paramName);
                superCall.arg((IJExpression)JExpr.ref((String)paramName));
                newInvocation.arg((IJExpression)JExpr.ref((String)paramName));
            }
            JVar newCall = staticHelper.body().decl((AbstractJType)narrowedGeneratedClass, "instance", (IJExpression)newInvocation);
            staticHelper.body().invoke((IJExpression)newCall, this.getOnFinishInflate());
            staticHelper.body()._return((IJExpression)newCall);
            body.invoke(this.getInit());
        }
    }

    @Override
    protected void setContextRef() {
        this.contextRef = JExpr.invoke((String)"getContext");
    }

    @Override
    protected void setInit() {
        this.init = this.generatedClass.method(4, (AbstractJType)this.getCodeModel().VOID, "init" + ModelConstants.generationSuffix());
        this.viewNotifierHelper.wrapInitWithNotifier();
    }

    @Override
    public JBlock getInitBody() {
        if (this.initBody == null) {
            this.setInit();
        }
        return this.initBody;
    }

    public void setInitBody(JBlock initBody) {
        this.initBody = initBody;
    }

    public JMethod getOnFinishInflate() {
        if (this.onFinishInflate == null) {
            this.setOnFinishInflate();
        }
        return this.onFinishInflate;
    }

    protected void setOnFinishInflate() {
        this.onFinishInflate = this.generatedClass.method(1, (AbstractJType)this.getCodeModel().VOID, "onFinishInflate");
        this.onFinishInflate.annotate(Override.class);
        this.onFinishInflate.javadoc().append((Object)ALREADY_INFLATED_COMMENT.replaceAll("alreadyInflated_", "alreadyInflated" + ModelConstants.generationSuffix()));
        JBlock ifNotInflated = this.onFinishInflate.body()._if(this.getAlreadyInflated().not())._then();
        ifNotInflated.assign((IJAssignmentTarget)this.getAlreadyInflated(), (IJExpression)JExpr.TRUE);
        this.getInit();
        this.viewNotifierHelper.invokeViewChanged(ifNotInflated);
        this.onFinishInflate.body().invoke((IJExpression)JExpr._super(), "onFinishInflate");
    }

    public JFieldVar getAlreadyInflated() {
        if (this.alreadyInflated == null) {
            this.setAlreadyInflated();
        }
        return this.alreadyInflated;
    }

    @Override
    public JBlock getStartLifecycleAfterSuperBlock() {
        return this.getOnAttachedToWindowAfterSuperBlock();
    }

    @Override
    public JBlock getEndLifecycleBeforeSuperBlock() {
        return this.getOnDetachedToWindowBeforeSuperBlock();
    }

    @Override
    public IJExpression getFindViewByIdExpression(JVar idParam) {
        return JExpr._this().invoke("findViewById").arg((IJExpression)idParam);
    }

    @Override
    public JFieldVar getIntentFilterField(ReceiverRegistrationDelegate.IntentFilterData intentFilterData) {
        return this.receiverRegistrationDelegate.getIntentFilterField(intentFilterData);
    }

    @Override
    public JBlock getIntentFilterInitializationBlock(ReceiverRegistrationDelegate.IntentFilterData intentFilterData) {
        return this.getInitBodyInjectionBlock();
    }

    protected JBlock getOnAttachedToWindowAfterSuperBlock() {
        if (this.onAttachedToWindowAfterSuperBlock == null) {
            this.setOnAttachedToWindow();
        }
        return this.onAttachedToWindowAfterSuperBlock;
    }

    protected JBlock getOnDetachedToWindowBeforeSuperBlock() {
        if (this.onDetachedFromWindowBeforeSuperBlock == null) {
            this.setOnDetachedFromWindow();
        }
        return this.onDetachedFromWindowBeforeSuperBlock;
    }

    private void setAlreadyInflated() {
        this.alreadyInflated = this.generatedClass.field(4, (AbstractJType)this.getCodeModel().BOOLEAN, "alreadyInflated" + ModelConstants.generationSuffix(), (IJExpression)JExpr.FALSE);
    }

    private void setOnAttachedToWindow() {
        this.onAttachedToWindowMethod = this.generatedClass.method(1, (AbstractJType)this.getCodeModel().VOID, "onAttachedToWindow");
        this.onAttachedToWindowMethod.annotate(Override.class);
        JBlock body = this.onAttachedToWindowMethod.body();
        body.invoke((IJExpression)JExpr._super(), this.onAttachedToWindowMethod);
        this.onAttachedToWindowAfterSuperBlock = body.blockSimple();
    }

    private void setOnDetachedFromWindow() {
        this.onDetachedFromWindowMethod = this.generatedClass.method(1, (AbstractJType)this.getCodeModel().VOID, "onDetachedFromWindow");
        this.onDetachedFromWindowMethod.annotate(Override.class);
        JBlock body = this.onDetachedFromWindowMethod.body();
        this.onDetachedFromWindowBeforeSuperBlock = body.blockSimple();
        body.invoke((IJExpression)JExpr._super(), this.onDetachedFromWindowMethod);
    }

    @Override
    public JBlock getSaveStateMethodBody() {
        return this.instanceStateDelegate.getSaveStateMethodBody();
    }

    @Override
    public JVar getSaveStateBundleParam() {
        return this.instanceStateDelegate.getSaveStateBundleParam();
    }

    @Override
    public JMethod getRestoreStateMethod() {
        return this.instanceStateDelegate.getRestoreStateMethod();
    }

    @Override
    public JBlock getRestoreStateMethodBody() {
        return this.instanceStateDelegate.getRestoreStateMethodBody();
    }

    @Override
    public JVar getRestoreStateBundleParam() {
        return this.instanceStateDelegate.getRestoreStateBundleParam();
    }
}

