/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.holder;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJGenerifiable;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JClassAlreadyExistsException;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import javax.lang.model.element.TypeElement;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.annotations.EFragment;
import org.androidannotations.annotations.Receiver;
import org.androidannotations.api.builder.FragmentBuilder;
import org.androidannotations.helper.ModelConstants;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.holder.FoundPreferenceHolder;
import org.androidannotations.holder.HasActivityLifecycleMethods;
import org.androidannotations.holder.HasInstanceState;
import org.androidannotations.holder.HasOnActivityResult;
import org.androidannotations.holder.HasOptionsMenu;
import org.androidannotations.holder.HasPreferences;
import org.androidannotations.holder.HasReceiverRegistration;
import org.androidannotations.holder.InstanceStateDelegate;
import org.androidannotations.holder.OnActivityResultDelegate;
import org.androidannotations.holder.PreferencesDelegate;
import org.androidannotations.holder.ReceiverRegistrationDelegate;

public class EFragmentHolder
extends EComponentWithViewSupportHolder
implements HasInstanceState,
HasOptionsMenu,
HasOnActivityResult,
HasActivityLifecycleMethods,
HasReceiverRegistration,
HasPreferences {
    private JFieldVar contentView;
    private JFieldVar viewDestroyedField;
    private JBlock setContentViewBlock;
    private JVar inflater;
    private JVar container;
    private JDefinedClass fragmentBuilderClass;
    private AbstractJClass narrowBuilderClass;
    private JFieldRef fragmentArgumentsBuilderField;
    private JMethod injectArgsMethod;
    private JBlock injectArgsBlock;
    private JVar injectBundleArgs;
    private InstanceStateDelegate instanceStateDelegate = new InstanceStateDelegate(this);
    private OnActivityResultDelegate onActivityResultDelegate = new OnActivityResultDelegate(this);
    private ReceiverRegistrationDelegate<EFragmentHolder> receiverRegistrationDelegate = new ReceiverRegistrationDelegate<EFragmentHolder>(this);
    private PreferencesDelegate preferencesDelegate = new PreferencesDelegate(this);
    private JBlock onCreateOptionsMenuMethodBody;
    private JBlock onCreateOptionsMenuMethodInflateBody;
    private JVar onCreateOptionsMenuMenuInflaterVar;
    private JVar onCreateOptionsMenuMenuParam;
    private JVar onOptionsItemSelectedItem;
    private JVar onOptionsItemSelectedItemId;
    private JBlock onOptionsItemSelectedMiddleBlock;
    private JBlock onCreateAfterSuperBlock;
    private JBlock onDestroyBeforeSuperBlock;
    private JBlock onStartAfterSuperBlock;
    private JBlock onStopBeforeSuperBlock;
    private JBlock onResumeAfterSuperBlock;
    private JBlock onPauseBeforeSuperBlock;
    private JBlock onAttachAfterSuperBlock;
    private JBlock onDetachBeforeSuperBlock;
    private JBlock onDestroyViewAfterSuperBlock;

    public EFragmentHolder(AndroidAnnotationsEnvironment environment, TypeElement annotatedElement) throws Exception {
        super(environment, annotatedElement);
        this.setOnCreate();
        this.setOnViewCreated();
        this.setFragmentBuilder();
    }

    private void setOnCreate() {
        JMethod onCreate = this.generatedClass.method(1, (AbstractJType)this.getCodeModel().VOID, "onCreate");
        onCreate.annotate(Override.class);
        JVar onCreateSavedInstanceState = onCreate.param((AbstractJType)this.getClasses().BUNDLE, "savedInstanceState");
        JBlock onCreateBody = onCreate.body();
        JVar previousNotifier = this.viewNotifierHelper.replacePreviousNotifier(onCreateBody);
        onCreateBody.invoke(this.getInit()).arg((IJExpression)onCreateSavedInstanceState);
        onCreateBody.invoke((IJExpression)JExpr._super(), onCreate).arg((IJExpression)onCreateSavedInstanceState);
        this.onCreateAfterSuperBlock = onCreateBody.blockSimple();
        this.viewNotifierHelper.resetPreviousNotifier(onCreateBody, previousNotifier);
    }

    private void setOnViewCreated() {
        JMethod onViewCreated = this.generatedClass.method(1, (AbstractJType)this.getCodeModel().VOID, "onViewCreated");
        onViewCreated.annotate(Override.class);
        JVar view = onViewCreated.param((AbstractJType)this.getClasses().VIEW, "view");
        JVar savedInstanceState = onViewCreated.param((AbstractJType)this.getClasses().BUNDLE, "savedInstanceState");
        JBlock onViewCreatedBody = onViewCreated.body();
        onViewCreatedBody.invoke((IJExpression)JExpr._super(), onViewCreated).arg((IJExpression)view).arg((IJExpression)savedInstanceState);
        this.viewNotifierHelper.invokeViewChanged(onViewCreatedBody);
    }

    @Override
    public IJExpression getFindViewByIdExpression(JVar idParam) {
        JFieldVar contentView = this.getContentView();
        JInvocation invocation = contentView.invoke("findViewById").arg((IJExpression)idParam);
        return JExpr.cond((IJExpression)contentView.eq((IJExpression)JExpr._null()), (IJExpression)JExpr._null(), (IJExpression)invocation);
    }

    private void setFragmentBuilder() throws JClassAlreadyExistsException {
        this.fragmentBuilderClass = (JDefinedClass)this.generatedClass._class(17, "FragmentBuilder" + ModelConstants.generationSuffix());
        this.narrowBuilderClass = this.narrow((AbstractJClass)this.fragmentBuilderClass);
        this.codeModelHelper.generify((IJGenerifiable)this.fragmentBuilderClass, this.annotatedElement);
        AbstractJClass superClass = this.getJClass(FragmentBuilder.class);
        superClass = superClass.narrow(new AbstractJClass[]{this.narrowBuilderClass, this.getAnnotatedClass()});
        this.fragmentBuilderClass._extends(superClass);
        this.fragmentArgumentsBuilderField = JExpr.ref((String)"args");
        this.setFragmentBuilderBuild();
        this.setFragmentBuilderCreate();
    }

    private void setFragmentBuilderBuild() {
        JMethod method = this.fragmentBuilderClass.method(1, (AbstractJType)this.generatedClass._extends(), "build");
        method.annotate(Override.class);
        JBlock body = method.body();
        AbstractJClass result = this.narrow((AbstractJClass)this.generatedClass);
        JVar fragment = body.decl((AbstractJType)result, "fragment_", (IJExpression)JExpr._new((AbstractJClass)result));
        body.invoke((IJExpression)fragment, "setArguments").arg((IJExpression)this.fragmentArgumentsBuilderField);
        body._return((IJExpression)fragment);
    }

    private void setFragmentBuilderCreate() {
        JMethod method = this.generatedClass.method(17, (AbstractJType)this.narrowBuilderClass, "builder");
        this.codeModelHelper.generify((IJGenerifiable)method, this.annotatedElement);
        method.body()._return((IJExpression)JExpr._new((AbstractJClass)this.narrowBuilderClass));
    }

    private void setOnCreateOptionsMenu() {
        JMethod method = this.generatedClass.method(1, (AbstractJType)this.getCodeModel().VOID, "onCreateOptionsMenu");
        method.annotate(Override.class);
        JBlock methodBody = method.body();
        this.onCreateOptionsMenuMenuParam = method.param((AbstractJType)this.getClasses().MENU, "menu");
        this.onCreateOptionsMenuMenuInflaterVar = method.param((AbstractJType)this.getClasses().MENU_INFLATER, "inflater");
        this.onCreateOptionsMenuMethodInflateBody = methodBody.blockSimple();
        this.onCreateOptionsMenuMethodBody = methodBody.blockSimple();
        methodBody.invoke((IJExpression)JExpr._super(), method).arg((IJExpression)this.onCreateOptionsMenuMenuParam).arg((IJExpression)this.onCreateOptionsMenuMenuInflaterVar);
        this.getInitBody().invoke("setHasOptionsMenu").arg((IJExpression)JExpr.TRUE);
    }

    private void setOnOptionsItemSelected() {
        JMethod method = this.generatedClass.method(1, (AbstractJType)this.getCodeModel().BOOLEAN, "onOptionsItemSelected");
        method.annotate(Override.class);
        JBlock methodBody = method.body();
        this.onOptionsItemSelectedItem = method.param((AbstractJType)this.getClasses().MENU_ITEM, "item");
        this.onOptionsItemSelectedItemId = methodBody.decl((AbstractJType)this.getCodeModel().INT, "itemId_", (IJExpression)this.onOptionsItemSelectedItem.invoke("getItemId"));
        this.onOptionsItemSelectedMiddleBlock = methodBody.blockSimple();
        methodBody._return((IJExpression)JExpr.invoke((IJExpression)JExpr._super(), (JMethod)method).arg((IJExpression)this.onOptionsItemSelectedItem));
    }

    @Override
    protected void setContextRef() {
        this.contextRef = JExpr.invoke((String)"getActivity");
    }

    @Override
    protected void setInit() {
        this.init = this.generatedClass.method(4, (AbstractJType)this.getCodeModel().VOID, "init" + ModelConstants.generationSuffix());
        this.init.param((AbstractJType)this.getClasses().BUNDLE, "savedInstanceState");
    }

    public JFieldVar getContentView() {
        if (this.contentView == null) {
            this.setContentViewRelatedMethods();
        }
        return this.contentView;
    }

    private void setContentViewRelatedMethods() {
        this.setContentView();
        this.setOnCreateView();
        this.setOnDestroyView();
    }

    private void setContentView() {
        this.contentView = this.generatedClass.field(4, (AbstractJType)this.getClasses().VIEW, "contentView" + ModelConstants.generationSuffix());
    }

    public JFieldVar getViewDestroyedField() {
        if (this.viewDestroyedField == null) {
            this.setViewDestroyedField();
        }
        return this.viewDestroyedField;
    }

    private void setViewDestroyedField() {
        this.viewDestroyedField = this.generatedClass.field(516, (AbstractJType)this.getCodeModel().BOOLEAN, "viewDestroyed" + ModelConstants.generationSuffix(), (IJExpression)JExpr.TRUE);
        this.getSetContentViewBlock().assign((IJAssignmentTarget)this.viewDestroyedField, (IJExpression)JExpr.FALSE);
        this.getOnDestroyViewAfterSuperBlock().assign((IJAssignmentTarget)this.viewDestroyedField, (IJExpression)JExpr.TRUE);
    }

    private void setOnCreateView() {
        JMethod onCreateView = this.generatedClass.method(1, (AbstractJType)this.getClasses().VIEW, "onCreateView");
        onCreateView.annotate(Override.class);
        this.inflater = onCreateView.param((AbstractJType)this.getClasses().LAYOUT_INFLATER, "inflater");
        this.container = onCreateView.param((AbstractJType)this.getClasses().VIEW_GROUP, "container");
        JVar savedInstanceState = onCreateView.param((AbstractJType)this.getClasses().BUNDLE, "savedInstanceState");
        boolean forceInjection = this.getAnnotatedElement().getAnnotation(EFragment.class).forceLayoutInjection();
        JBlock body = onCreateView.body();
        if (!forceInjection) {
            body.assign((IJAssignmentTarget)this.contentView, (IJExpression)JExpr._super().invoke(onCreateView).arg((IJExpression)this.inflater).arg((IJExpression)this.container).arg((IJExpression)savedInstanceState));
        }
        this.setContentViewBlock = body.blockSimple();
        body._return((IJExpression)this.contentView);
    }

    private void setOnDestroyView() {
        JMethod onDestroyView = this.generatedClass.method(1, (AbstractJType)this.getCodeModel().VOID, "onDestroyView");
        onDestroyView.annotate(Override.class);
        JBlock body = onDestroyView.body();
        body.invoke((IJExpression)JExpr._super(), onDestroyView);
        body.assign((IJAssignmentTarget)this.contentView, (IJExpression)JExpr._null());
        this.onDestroyViewAfterSuperBlock = body.blockSimple();
    }

    public JBlock getOnDestroyViewAfterSuperBlock() {
        if (this.onDestroyViewAfterSuperBlock == null) {
            this.setContentViewRelatedMethods();
        }
        return this.onDestroyViewAfterSuperBlock;
    }

    public void clearInjectedView(IJAssignmentTarget fieldRef) {
        JBlock block = this.getOnDestroyViewAfterSuperBlock();
        block.assign(fieldRef, (IJExpression)JExpr._null());
    }

    private void setOnStart() {
        JMethod onStart = this.generatedClass.method(1, (AbstractJType)this.getCodeModel().VOID, "onStart");
        onStart.annotate(Override.class);
        JBlock onStartBody = onStart.body();
        onStartBody.invoke((IJExpression)JExpr._super(), onStart);
        this.onStartAfterSuperBlock = onStartBody.blockSimple();
    }

    private void setOnAttach() {
        JMethod onAttach = this.generatedClass.method(1, (AbstractJType)this.getCodeModel().VOID, "onAttach");
        onAttach.annotate(Override.class);
        JVar activityParam = onAttach.param((AbstractJType)this.getClasses().ACTIVITY, "activity");
        JBlock onAttachBody = onAttach.body();
        onAttachBody.invoke((IJExpression)JExpr._super(), onAttach).arg((IJExpression)activityParam);
        this.onAttachAfterSuperBlock = onAttachBody.blockSimple();
    }

    private void setOnResume() {
        JMethod onResume = this.generatedClass.method(1, (AbstractJType)this.getCodeModel().VOID, "onResume");
        onResume.annotate(Override.class);
        JBlock onResumeBody = onResume.body();
        onResumeBody.invoke((IJExpression)JExpr._super(), onResume);
        this.onResumeAfterSuperBlock = onResumeBody.blockSimple();
    }

    private void setOnPause() {
        JMethod onPause = this.generatedClass.method(1, (AbstractJType)this.getCodeModel().VOID, "onPause");
        onPause.annotate(Override.class);
        JBlock onPauseBody = onPause.body();
        this.onPauseBeforeSuperBlock = onPauseBody.blockSimple();
        onPauseBody.invoke((IJExpression)JExpr._super(), onPause);
    }

    private void setOnDetach() {
        JMethod onDetach = this.generatedClass.method(1, (AbstractJType)this.getCodeModel().VOID, "onDetach");
        onDetach.annotate(Override.class);
        JBlock onDetachBody = onDetach.body();
        this.onDetachBeforeSuperBlock = onDetachBody.blockSimple();
        onDetachBody.invoke((IJExpression)JExpr._super(), onDetach);
    }

    private void setOnStop() {
        JMethod onStop = this.generatedClass.method(1, (AbstractJType)this.getCodeModel().VOID, "onStop");
        onStop.annotate(Override.class);
        JBlock onStopBody = onStop.body();
        this.onStopBeforeSuperBlock = onStopBody.blockSimple();
        onStopBody.invoke((IJExpression)JExpr._super(), onStop);
    }

    private void setOnDestroy() {
        JMethod onDestroy = this.generatedClass.method(1, (AbstractJType)this.getCodeModel().VOID, "onDestroy");
        onDestroy.annotate(Override.class);
        JBlock onDestroyBody = onDestroy.body();
        this.onDestroyBeforeSuperBlock = onDestroyBody.blockSimple();
        onDestroyBody.invoke((IJExpression)JExpr._super(), onDestroy);
    }

    public JBlock getSetContentViewBlock() {
        if (this.setContentViewBlock == null) {
            this.setOnCreateView();
        }
        return this.setContentViewBlock;
    }

    public JVar getInflater() {
        if (this.inflater == null) {
            this.setOnCreateView();
        }
        return this.inflater;
    }

    public JVar getContainer() {
        if (this.container == null) {
            this.setOnCreateView();
        }
        return this.container;
    }

    public JDefinedClass getBuilderClass() {
        return this.fragmentBuilderClass;
    }

    public JFieldRef getBuilderArgsField() {
        return this.fragmentArgumentsBuilderField;
    }

    public JMethod getInjectArgsMethod() {
        if (this.injectArgsMethod == null) {
            this.setInjectArgs();
        }
        return this.injectArgsMethod;
    }

    public JBlock getInjectArgsBlock() {
        if (this.injectArgsBlock == null) {
            this.setInjectArgs();
        }
        return this.injectArgsBlock;
    }

    public JVar getInjectBundleArgs() {
        if (this.injectBundleArgs == null) {
            this.setInjectArgs();
        }
        return this.injectBundleArgs;
    }

    private void setInjectArgs() {
        this.injectArgsMethod = this.generatedClass.method(4, (AbstractJType)this.getCodeModel().VOID, "injectFragmentArguments" + ModelConstants.generationSuffix());
        JBlock injectExtrasBody = this.injectArgsMethod.body();
        this.injectBundleArgs = injectExtrasBody.decl((AbstractJType)this.getClasses().BUNDLE, "args_", (IJExpression)JExpr.invoke((String)"getArguments"));
        this.injectArgsBlock = injectExtrasBody._if(this.injectBundleArgs.ne((IJExpression)JExpr._null()))._then();
        this.getInitBodyInjectionBlock().invoke(this.injectArgsMethod);
    }

    @Override
    public JBlock getSaveStateMethodBody() {
        return this.instanceStateDelegate.getSaveStateMethodBody();
    }

    @Override
    public JVar getSaveStateBundleParam() {
        return this.instanceStateDelegate.getSaveStateBundleParam();
    }

    @Override
    public JMethod getRestoreStateMethod() {
        return this.instanceStateDelegate.getRestoreStateMethod();
    }

    @Override
    public JBlock getRestoreStateMethodBody() {
        return this.instanceStateDelegate.getRestoreStateMethodBody();
    }

    @Override
    public JVar getRestoreStateBundleParam() {
        return this.instanceStateDelegate.getRestoreStateBundleParam();
    }

    @Override
    public JBlock getOnCreateOptionsMenuMethodBody() {
        if (this.onCreateOptionsMenuMethodBody == null) {
            this.setOnCreateOptionsMenu();
        }
        return this.onCreateOptionsMenuMethodBody;
    }

    @Override
    public JBlock getOnCreateOptionsMenuMethodInflateBody() {
        if (this.onCreateOptionsMenuMethodInflateBody == null) {
            this.setOnCreateOptionsMenu();
        }
        return this.onCreateOptionsMenuMethodInflateBody;
    }

    @Override
    public JVar getOnCreateOptionsMenuMenuInflaterVar() {
        if (this.onCreateOptionsMenuMenuInflaterVar == null) {
            this.setOnCreateOptionsMenu();
        }
        return this.onCreateOptionsMenuMenuInflaterVar;
    }

    @Override
    public JVar getOnCreateOptionsMenuMenuParam() {
        if (this.onCreateOptionsMenuMenuParam == null) {
            this.setOnCreateOptionsMenu();
        }
        return this.onCreateOptionsMenuMenuParam;
    }

    @Override
    public JVar getOnOptionsItemSelectedItem() {
        if (this.onOptionsItemSelectedItem == null) {
            this.setOnOptionsItemSelected();
        }
        return this.onOptionsItemSelectedItem;
    }

    @Override
    public JVar getOnOptionsItemSelectedItemId() {
        if (this.onOptionsItemSelectedItemId == null) {
            this.setOnOptionsItemSelected();
        }
        return this.onOptionsItemSelectedItemId;
    }

    @Override
    public JBlock getOnOptionsItemSelectedMiddleBlock() {
        if (this.onOptionsItemSelectedMiddleBlock == null) {
            this.setOnOptionsItemSelected();
        }
        return this.onOptionsItemSelectedMiddleBlock;
    }

    @Override
    public JBlock getOnActivityResultCaseBlock(int requestCode) {
        return this.onActivityResultDelegate.getCaseBlock(requestCode);
    }

    @Override
    public JVar getOnActivityResultDataParam() {
        return this.onActivityResultDelegate.getDataParam();
    }

    @Override
    public JVar getOnActivityResultResultCodeParam() {
        return this.onActivityResultDelegate.getResultCodeParam();
    }

    @Override
    public JMethod getOnActivityResultMethod() {
        return this.onActivityResultDelegate.getMethod();
    }

    @Override
    public JFieldVar getIntentFilterField(ReceiverRegistrationDelegate.IntentFilterData intentFilterData) {
        return this.receiverRegistrationDelegate.getIntentFilterField(intentFilterData);
    }

    @Override
    public JBlock getStartLifecycleAfterSuperBlock() {
        return this.getOnCreateAfterSuperBlock();
    }

    @Override
    public JBlock getEndLifecycleBeforeSuperBlock() {
        return this.getOnDestroyBeforeSuperBlock();
    }

    @Override
    public JBlock getOnCreateAfterSuperBlock() {
        if (this.onCreateAfterSuperBlock == null) {
            this.setOnCreate();
        }
        return this.onCreateAfterSuperBlock;
    }

    @Override
    public JBlock getOnDestroyBeforeSuperBlock() {
        if (this.onDestroyBeforeSuperBlock == null) {
            this.setOnDestroy();
        }
        return this.onDestroyBeforeSuperBlock;
    }

    @Override
    public JBlock getOnStartAfterSuperBlock() {
        if (this.onStartAfterSuperBlock == null) {
            this.setOnStart();
        }
        return this.onStartAfterSuperBlock;
    }

    @Override
    public JBlock getOnStopBeforeSuperBlock() {
        if (this.onStopBeforeSuperBlock == null) {
            this.setOnStop();
        }
        return this.onStopBeforeSuperBlock;
    }

    @Override
    public JBlock getOnResumeAfterSuperBlock() {
        if (this.onResumeAfterSuperBlock == null) {
            this.setOnResume();
        }
        return this.onResumeAfterSuperBlock;
    }

    @Override
    public JBlock getOnPauseBeforeSuperBlock() {
        if (this.onPauseBeforeSuperBlock == null) {
            this.setOnPause();
        }
        return this.onPauseBeforeSuperBlock;
    }

    public JBlock getOnAttachAfterSuperBlock() {
        if (this.onAttachAfterSuperBlock == null) {
            this.setOnAttach();
        }
        return this.onAttachAfterSuperBlock;
    }

    public JBlock getOnDetachBeforeSuperBlock() {
        if (this.onDetachBeforeSuperBlock == null) {
            this.setOnDetach();
        }
        return this.onDetachBeforeSuperBlock;
    }

    @Override
    public JBlock getIntentFilterInitializationBlock(ReceiverRegistrationDelegate.IntentFilterData intentFilterData) {
        if (Receiver.RegisterAt.OnAttachOnDetach.equals((Object)intentFilterData.getRegisterAt())) {
            return this.getOnAttachAfterSuperBlock();
        }
        return this.getInitBodyInjectionBlock();
    }

    @Override
    public JBlock getPreferenceScreenInitializationBlock() {
        return this.getOnCreateAfterSuperBlock();
    }

    @Override
    public JBlock getAddPreferencesFromResourceInjectionBlock() {
        return this.preferencesDelegate.getAddPreferencesFromResourceInjectionBlock();
    }

    @Override
    public JBlock getAddPreferencesFromResourceAfterInjectionBlock() {
        return this.preferencesDelegate.getAddPreferencesFromResourceAfterInjectionBlock();
    }

    @Override
    public FoundPreferenceHolder getFoundPreferenceHolder(JFieldRef idRef, AbstractJClass preferenceClass) {
        return this.preferencesDelegate.getFoundPreferenceHolder(idRef, preferenceClass);
    }

    @Override
    public FoundPreferenceHolder getFoundPreferenceHolder(JFieldRef idRef, AbstractJClass preferenceClass, IJAssignmentTarget fieldRef) {
        return this.preferencesDelegate.getFoundPreferenceHolder(idRef, preferenceClass, fieldRef);
    }

    @Override
    public boolean usingSupportV7Preference() {
        return this.preferencesDelegate.usingSupportV7Preference();
    }

    @Override
    public boolean usingAndroidxPreference() {
        return this.preferencesDelegate.usingAndroidxPreference();
    }

    @Override
    public AbstractJClass getBasePreferenceClass() {
        return this.preferencesDelegate.getBasePreferenceClass();
    }
}

