/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.holder;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAnnotatable;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JAnonymousClass;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JSwitch;
import com.helger.jcodemodel.JVar;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.api.view.HasViews;
import org.androidannotations.api.view.OnViewChangedListener;
import org.androidannotations.api.view.OnViewChangedNotifier;
import org.androidannotations.holder.DataBindingDelegate;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.holder.FoundHolder;
import org.androidannotations.holder.FoundViewHolder;
import org.androidannotations.holder.HasKeyEventCallbackMethods;
import org.androidannotations.holder.KeyEventCallbackMethodsDelegate;
import org.androidannotations.holder.OnSeekBarChangeListenerHolder;
import org.androidannotations.holder.PageChangeHolder;
import org.androidannotations.holder.TextWatcherHolder;
import org.androidannotations.internal.helper.ViewNotifierHelper;

public abstract class EComponentWithViewSupportHolder
extends EComponentHolder
implements HasKeyEventCallbackMethods {
    protected ViewNotifierHelper viewNotifierHelper;
    private JMethod onViewChanged;
    private JBlock onViewChangedBody;
    private JBlock onViewChangedBodyInjectionBlock;
    private JBlock onViewChangedBodyViewHolderBlock;
    private JBlock onViewChangedBodyAfterInjectionBlock;
    private JBlock onViewChangedBodyBeforeInjectionBlock;
    private JVar onViewChangedHasViewsParam;
    protected Map<String, FoundHolder> foundHolders = new HashMap<String, FoundHolder>();
    protected DataBindingDelegate dataBindingDelegate;
    protected JMethod findNativeFragmentById;
    protected JMethod findSupportFragmentById;
    protected JMethod findNativeFragmentByTag;
    protected JMethod findSupportFragmentByTag;
    private Map<String, TextWatcherHolder> textWatcherHolders = new HashMap<String, TextWatcherHolder>();
    private Map<String, OnSeekBarChangeListenerHolder> onSeekBarChangeListenerHolders = new HashMap<String, OnSeekBarChangeListenerHolder>();
    private Map<String, PageChangeHolder> pageChangeHolders = new HashMap<String, PageChangeHolder>();
    private KeyEventCallbackMethodsDelegate<EComponentWithViewSupportHolder> keyEventCallbackMethodsDelegate;

    public EComponentWithViewSupportHolder(AndroidAnnotationsEnvironment environment, TypeElement annotatedElement) throws Exception {
        super(environment, annotatedElement);
        this.viewNotifierHelper = new ViewNotifierHelper(this, environment);
        this.keyEventCallbackMethodsDelegate = new KeyEventCallbackMethodsDelegate<EComponentWithViewSupportHolder>(this);
        this.dataBindingDelegate = new DataBindingDelegate(this);
    }

    public IJExpression getFindViewByIdExpression(JVar idParam) {
        return JExpr._null();
    }

    public JBlock getOnViewChangedBody() {
        if (this.onViewChangedBody == null) {
            this.setOnViewChanged();
        }
        return this.onViewChangedBody;
    }

    public JBlock getOnViewChangedBodyBeforeInjectionBlock() {
        if (this.onViewChangedBodyBeforeInjectionBlock == null) {
            this.setOnViewChanged();
        }
        return this.onViewChangedBodyBeforeInjectionBlock;
    }

    public JBlock getOnViewChangedBodyInjectionBlock() {
        if (this.onViewChangedBodyInjectionBlock == null) {
            this.setOnViewChanged();
        }
        return this.onViewChangedBodyInjectionBlock;
    }

    public JBlock getOnViewChangedBodyViewHolderBlock() {
        if (this.onViewChangedBodyViewHolderBlock == null) {
            this.setOnViewChanged();
        }
        return this.onViewChangedBodyViewHolderBlock;
    }

    public JBlock getOnViewChangedBodyAfterInjectionBlock() {
        if (this.onViewChangedBodyAfterInjectionBlock == null) {
            this.setOnViewChanged();
        }
        return this.onViewChangedBodyAfterInjectionBlock;
    }

    public JVar getOnViewChangedHasViewsParam() {
        if (this.onViewChangedHasViewsParam == null) {
            this.setOnViewChanged();
        }
        return this.onViewChangedHasViewsParam;
    }

    protected void setOnViewChanged() {
        this.getGeneratedClass()._implements(OnViewChangedListener.class);
        this.onViewChanged = this.getGeneratedClass().method(1, (AbstractJType)this.getCodeModel().VOID, "onViewChanged");
        this.onViewChanged.annotate(Override.class);
        this.onViewChangedBody = this.onViewChanged.body();
        this.onViewChangedBodyBeforeInjectionBlock = this.onViewChangedBody.blockVirtual();
        this.onViewChangedBodyViewHolderBlock = this.onViewChangedBody.blockVirtual();
        this.onViewChangedBodyInjectionBlock = this.onViewChangedBody.blockVirtual();
        this.onViewChangedBodyAfterInjectionBlock = this.onViewChangedBody.blockVirtual();
        this.onViewChangedHasViewsParam = this.onViewChanged.param(HasViews.class, "hasViews");
        AbstractJClass notifierClass = this.getJClass(OnViewChangedNotifier.class);
        this.getInitBodyInjectionBlock().staticInvoke(notifierClass, "registerOnViewChangedListener").arg((IJExpression)JExpr._this());
    }

    public JInvocation findViewById(JFieldRef idRef) {
        JInvocation findViewById = JExpr.invoke((IJExpression)this.getOnViewChangedHasViewsParam(), (String)"internalFindViewById");
        findViewById.arg((IJExpression)idRef);
        return findViewById;
    }

    public FoundViewHolder getFoundViewHolder(JFieldRef idRef, AbstractJClass viewClass) {
        return this.getFoundViewHolder(idRef, viewClass, null);
    }

    public FoundViewHolder getFoundViewHolder(JFieldRef idRef, AbstractJClass viewClass, IJAssignmentTarget fieldRef) {
        String idRefString = idRef.name();
        FoundViewHolder foundViewHolder = (FoundViewHolder)this.foundHolders.get(idRefString);
        if (foundViewHolder == null) {
            foundViewHolder = this.createFoundViewAndIfNotNullBlock(idRef, viewClass, fieldRef);
            this.foundHolders.put(idRefString, foundViewHolder);
        }
        return foundViewHolder;
    }

    protected FoundViewHolder createFoundViewAndIfNotNullBlock(JFieldRef idRef, AbstractJClass viewClass, IJAssignmentTarget fieldRef) {
        IJAssignmentTarget foundView;
        JInvocation findViewExpression = this.findViewById(idRef);
        JBlock block = this.getOnViewChangedBodyBeforeInjectionBlock();
        if (viewClass == null) {
            viewClass = this.getClasses().VIEW;
        }
        if ((foundView = fieldRef) == null) {
            JVar view = block.decl((AbstractJType)viewClass, "view_" + idRef.name(), (IJExpression)findViewExpression);
            if (viewClass.isParameterized()) {
                this.codeModelHelper.addSuppressWarnings((IJAnnotatable)view, "unchecked");
            }
            foundView = view;
        } else {
            block.add((IJStatement)foundView.assign((IJExpression)findViewExpression));
        }
        return new FoundViewHolder(this, viewClass, (IJExpression)foundView, this.getOnViewChangedBodyViewHolderBlock());
    }

    public JMethod getFindNativeFragmentById() {
        if (this.findNativeFragmentById == null) {
            this.setFindNativeFragmentById();
        }
        return this.findNativeFragmentById;
    }

    protected void setFindNativeFragmentById() {
        this.findNativeFragmentById = this.getGeneratedClass().method(4, (AbstractJType)this.getClasses().FRAGMENT, "findNativeFragmentById");
        JVar idParam = this.findNativeFragmentById.param((AbstractJType)this.getCodeModel().INT, "id");
        JBlock body = this.findNativeFragmentById.body();
        body._if(this.getContextRef()._instanceof((AbstractJType)this.getClasses().ACTIVITY).not())._then()._return((IJExpression)JExpr._null());
        JVar activityVar = body.decl((AbstractJType)this.getClasses().ACTIVITY, "activity_", (IJExpression)JExpr.cast((AbstractJType)this.getClasses().ACTIVITY, (IJExpression)this.getContextRef()));
        body._return((IJExpression)activityVar.invoke("getFragmentManager").invoke("findFragmentById").arg((IJExpression)idParam));
    }

    public JMethod getFindSupportFragmentById() {
        if (this.findSupportFragmentById == null) {
            this.setFindSupportFragmentById();
        }
        return this.findSupportFragmentById;
    }

    protected void setFindSupportFragmentById() {
        this.findSupportFragmentById = this.getProcessingEnvironment().getElementUtils().getTypeElement("androidx.fragment.app.Fragment") == null ? this.getGeneratedClass().method(4, (AbstractJType)this.getClasses().SUPPORT_V4_FRAGMENT, "findSupportFragmentById") : this.getGeneratedClass().method(4, (AbstractJType)this.getClasses().ANDROIDX_FRAGMENT, "findSupportFragmentById");
        JVar idParam = this.findSupportFragmentById.param((AbstractJType)this.getCodeModel().INT, "id");
        JBlock body = this.findSupportFragmentById.body();
        AbstractJClass fragmentActivity = this.getFragmentActivity();
        body._if(this.getContextRef()._instanceof((AbstractJType)fragmentActivity).not())._then()._return((IJExpression)JExpr._null());
        JVar activityVar = body.decl((AbstractJType)fragmentActivity, "activity_", (IJExpression)JExpr.cast((AbstractJType)fragmentActivity, (IJExpression)this.getContextRef()));
        body._return((IJExpression)activityVar.invoke("getSupportFragmentManager").invoke("findFragmentById").arg((IJExpression)idParam));
    }

    private AbstractJClass getFragmentActivity() {
        Elements elementUtils = this.getProcessingEnvironment().getElementUtils();
        if (elementUtils.getTypeElement("androidx.fragment.app.FragmentActivity") != null) {
            return this.getClasses().ANDROIDX_FRAGMENT_ACTIVITY;
        }
        return this.getClasses().FRAGMENT_ACTIVITY;
    }

    public JMethod getFindNativeFragmentByTag() {
        if (this.findNativeFragmentByTag == null) {
            this.setFindNativeFragmentByTag();
        }
        return this.findNativeFragmentByTag;
    }

    protected void setFindNativeFragmentByTag() {
        this.findNativeFragmentByTag = this.getGeneratedClass().method(4, (AbstractJType)this.getClasses().FRAGMENT, "findNativeFragmentByTag");
        JVar tagParam = this.findNativeFragmentByTag.param((AbstractJType)this.getClasses().STRING, "tag");
        JBlock body = this.findNativeFragmentByTag.body();
        body._if(this.getContextRef()._instanceof((AbstractJType)this.getClasses().ACTIVITY).not())._then()._return((IJExpression)JExpr._null());
        JVar activityVar = body.decl((AbstractJType)this.getClasses().ACTIVITY, "activity_", (IJExpression)JExpr.cast((AbstractJType)this.getClasses().ACTIVITY, (IJExpression)this.getContextRef()));
        body._return((IJExpression)activityVar.invoke("getFragmentManager").invoke("findFragmentByTag").arg((IJExpression)tagParam));
    }

    public JMethod getFindSupportFragmentByTag() {
        if (this.findSupportFragmentByTag == null) {
            this.setFindSupportFragmentByTag();
        }
        return this.findSupportFragmentByTag;
    }

    protected void setFindSupportFragmentByTag() {
        this.findSupportFragmentByTag = this.getProcessingEnvironment().getElementUtils().getTypeElement("androidx.fragment.app.Fragment") == null ? this.getGeneratedClass().method(4, (AbstractJType)this.getClasses().SUPPORT_V4_FRAGMENT, "findSupportFragmentByTag") : this.getGeneratedClass().method(4, (AbstractJType)this.getClasses().ANDROIDX_FRAGMENT, "findSupportFragmentByTag");
        JVar tagParam = this.findSupportFragmentByTag.param((AbstractJType)this.getClasses().STRING, "tag");
        JBlock body = this.findSupportFragmentByTag.body();
        AbstractJClass fragmentActivity = this.getFragmentActivity();
        body._if(this.getContextRef()._instanceof((AbstractJType)fragmentActivity).not())._then()._return((IJExpression)JExpr._null());
        JVar activityVar = body.decl((AbstractJType)fragmentActivity, "activity_", (IJExpression)JExpr.cast((AbstractJType)fragmentActivity, (IJExpression)this.getContextRef()));
        body._return((IJExpression)activityVar.invoke("getSupportFragmentManager").invoke("findFragmentByTag").arg((IJExpression)tagParam));
    }

    public TextWatcherHolder getTextWatcherHolder(JFieldRef idRef, TypeMirror viewParameterType) {
        String idRefString = idRef.name();
        TextWatcherHolder textWatcherHolder = this.textWatcherHolders.get(idRefString);
        if (textWatcherHolder == null) {
            textWatcherHolder = this.createTextWatcherHolder(idRef, viewParameterType);
            this.textWatcherHolders.put(idRefString, textWatcherHolder);
        }
        return textWatcherHolder;
    }

    private TextWatcherHolder createTextWatcherHolder(JFieldRef idRef, TypeMirror viewParameterType) {
        JAnonymousClass onTextChangeListenerClass = this.getCodeModel().anonymousClass(this.getClasses().TEXT_WATCHER);
        AbstractJClass viewClass = this.getClasses().TEXT_VIEW;
        if (viewParameterType != null) {
            viewClass = this.getJClass(viewParameterType.toString());
        }
        JBlock onViewChangedBody = this.getOnViewChangedBodyInjectionBlock().blockSimple();
        JVar viewVariable = onViewChangedBody.decl(8, (AbstractJType)viewClass, "view", (IJExpression)JExpr.cast((AbstractJType)viewClass, (IJExpression)this.findViewById(idRef)));
        onViewChangedBody._if(viewVariable.ne((IJExpression)JExpr._null()))._then().invoke((IJExpression)viewVariable, "addTextChangedListener").arg((IJExpression)JExpr._new((AbstractJClass)onTextChangeListenerClass));
        return new TextWatcherHolder(this, viewVariable, (JDefinedClass)onTextChangeListenerClass);
    }

    public OnSeekBarChangeListenerHolder getOnSeekBarChangeListenerHolder(JFieldRef idRef) {
        String idRefString = idRef.name();
        OnSeekBarChangeListenerHolder onSeekBarChangeListenerHolder = this.onSeekBarChangeListenerHolders.get(idRefString);
        if (onSeekBarChangeListenerHolder == null) {
            onSeekBarChangeListenerHolder = this.createOnSeekBarChangeListenerHolder(idRef);
            this.onSeekBarChangeListenerHolders.put(idRefString, onSeekBarChangeListenerHolder);
        }
        return onSeekBarChangeListenerHolder;
    }

    private OnSeekBarChangeListenerHolder createOnSeekBarChangeListenerHolder(JFieldRef idRef) {
        JAnonymousClass onSeekbarChangeListenerClass = this.getCodeModel().anonymousClass(this.getClasses().ON_SEEKBAR_CHANGE_LISTENER);
        AbstractJClass viewClass = this.getClasses().SEEKBAR;
        FoundViewHolder foundViewHolder = this.getFoundViewHolder(idRef, viewClass);
        foundViewHolder.getIfNotNullBlock().invoke(foundViewHolder.getRef(), "setOnSeekBarChangeListener").arg((IJExpression)JExpr._new((AbstractJClass)onSeekbarChangeListenerClass));
        return new OnSeekBarChangeListenerHolder(this, (JDefinedClass)onSeekbarChangeListenerClass);
    }

    public PageChangeHolder getPageChangeHolder(JFieldRef idRef, TypeMirror viewParameterType, boolean hasAddOnPageChangeListenerMethod) {
        String idRefString = idRef.name();
        PageChangeHolder pageChangeHolder = this.pageChangeHolders.get(idRefString);
        if (pageChangeHolder == null) {
            pageChangeHolder = this.createPageChangeHolder(idRef, viewParameterType, hasAddOnPageChangeListenerMethod);
            this.pageChangeHolders.put(idRefString, pageChangeHolder);
        }
        return pageChangeHolder;
    }

    private PageChangeHolder createPageChangeHolder(JFieldRef idRef, TypeMirror viewParameterType, boolean hasAddOnPageChangeListenerMethod) {
        JAnonymousClass onPageChangeListenerClass;
        AbstractJClass viewClass;
        if (this.getProcessingEnvironment().getElementUtils().getTypeElement("androidx.viewpager.widget.ViewPager") == null) {
            viewClass = this.getClasses().VIEW_PAGER;
            onPageChangeListenerClass = this.getCodeModel().anonymousClass(this.getClasses().PAGE_CHANGE_LISTENER);
        } else {
            viewClass = this.getClasses().ANDROIDX_VIEW_PAGER;
            onPageChangeListenerClass = this.getCodeModel().anonymousClass(this.getClasses().ANDROIDX_PAGE_CHANGE_LISTENER);
        }
        if (viewParameterType != null) {
            viewClass = this.getJClass(viewParameterType.toString());
        }
        JBlock onViewChangedBody = this.getOnViewChangedBodyInjectionBlock().blockSimple();
        JVar viewVariable = onViewChangedBody.decl(8, (AbstractJType)viewClass, "view", (IJExpression)JExpr.cast((AbstractJType)viewClass, (IJExpression)this.findViewById(idRef)));
        JBlock block = onViewChangedBody._if(viewVariable.ne((IJExpression)JExpr._null()))._then();
        if (hasAddOnPageChangeListenerMethod) {
            block.invoke((IJExpression)viewVariable, "addOnPageChangeListener").arg((IJExpression)JExpr._new((AbstractJClass)onPageChangeListenerClass));
        } else {
            block.invoke((IJExpression)viewVariable, "setOnPageChangeListener").arg((IJExpression)JExpr._new((AbstractJClass)onPageChangeListenerClass));
        }
        return new PageChangeHolder(this, viewVariable, (JDefinedClass)onPageChangeListenerClass);
    }

    @Override
    public JSwitch getOnKeyDownSwitchBody() {
        return this.keyEventCallbackMethodsDelegate.getOnKeyDownSwitchBody();
    }

    @Override
    public JVar getOnKeyDownKeyEventParam() {
        return this.keyEventCallbackMethodsDelegate.getOnKeyDownKeyEventParam();
    }

    @Override
    public JSwitch getOnKeyLongPressSwitchBody() {
        return this.keyEventCallbackMethodsDelegate.getOnKeyLongPressSwitchBody();
    }

    @Override
    public JVar getOnKeyLongPressKeyEventParam() {
        return this.keyEventCallbackMethodsDelegate.getOnKeyLongPressKeyEventParam();
    }

    @Override
    public JSwitch getOnKeyMultipleSwitchBody() {
        return this.keyEventCallbackMethodsDelegate.getOnKeyMultipleSwitchBody();
    }

    @Override
    public JVar getOnKeyMultipleKeyEventParam() {
        return this.keyEventCallbackMethodsDelegate.getOnKeyMultipleKeyEventParam();
    }

    @Override
    public JVar getOnKeyMultipleCountParam() {
        return this.keyEventCallbackMethodsDelegate.getOnKeyMultipleCountParam();
    }

    @Override
    public JSwitch getOnKeyUpSwitchBody() {
        return this.keyEventCallbackMethodsDelegate.getOnKeyUpSwitchBody();
    }

    @Override
    public JVar getOnKeyUpKeyEventParam() {
        return this.keyEventCallbackMethodsDelegate.getOnKeyUpKeyEventParam();
    }

    public JFieldVar getDataBindingField() {
        return this.dataBindingDelegate.getDataBindingField();
    }

    public IJExpression getDataBindingInflationExpression(IJExpression contentViewId, IJExpression container, boolean attachToRoot) {
        return this.dataBindingDelegate.getDataBindingInflationExpression(contentViewId, container, attachToRoot);
    }
}

