/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.holder;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJGenerifiable;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.helper.ModelConstants;
import org.androidannotations.holder.EComponentWithViewSupportHolder;

public class EBeanHolder
extends EComponentWithViewSupportHolder {
    public static final String GET_INSTANCE_METHOD_NAME = "getInstance" + ModelConstants.generationSuffix();
    private JFieldVar contextField;
    private JMethod constructor;

    public EBeanHolder(AndroidAnnotationsEnvironment environment, TypeElement annotatedElement) throws Exception {
        super(environment, annotatedElement);
        this.setConstructor();
    }

    private void setConstructor() {
        this.constructor = this.generatedClass.constructor(4);
        JVar constructorContextParam = this.constructor.param((AbstractJType)this.getClasses().CONTEXT, "context");
        JBlock constructorBody = this.constructor.body();
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(this.annotatedElement.getEnclosedElements());
        ExecutableElement superConstructor = constructors.get(0);
        if (superConstructor.getParameters().size() == 1) {
            constructorBody.invoke("super").arg((IJExpression)constructorContextParam);
        }
        constructorBody.assign((IJAssignmentTarget)this.getContextField(), (IJExpression)constructorContextParam);
    }

    public JFieldVar getContextField() {
        if (this.contextField == null) {
            this.contextField = this.generatedClass.field(4, (AbstractJType)this.getClasses().CONTEXT, "context" + ModelConstants.generationSuffix());
        }
        return this.contextField;
    }

    @Override
    protected void setContextRef() {
        this.contextRef = this.getContextField();
    }

    @Override
    protected void setInit() {
        this.init = this.generatedClass.method(4, (AbstractJType)this.getCodeModel().VOID, "init" + ModelConstants.generationSuffix());
    }

    public void invokeInitInConstructor() {
        JBlock constructorBody = this.constructor.body();
        constructorBody.invoke(this.getInit());
    }

    public void createFactoryMethod(boolean hasSingletonScope) {
        AbstractJClass narrowedGeneratedClass = this.codeModelHelper.narrowGeneratedClass((AbstractJClass)this.generatedClass, this.annotatedElement.asType());
        JMethod factoryMethod = this.generatedClass.method(17, (AbstractJType)narrowedGeneratedClass, GET_INSTANCE_METHOD_NAME);
        this.codeModelHelper.generify((IJGenerifiable)factoryMethod, this.annotatedElement);
        JVar factoryMethodContextParam = factoryMethod.param((AbstractJType)this.getClasses().CONTEXT, "context");
        JBlock factoryMethodBody = factoryMethod.body();
        if (hasSingletonScope) {
            JFieldVar instanceField = this.generatedClass.field(20, (AbstractJType)this.generatedClass, "instance" + ModelConstants.generationSuffix());
            JBlock creationBlock = factoryMethodBody._if(instanceField.eq((IJExpression)JExpr._null()))._then();
            JVar previousNotifier = this.viewNotifierHelper.replacePreviousNotifierWithNull(creationBlock);
            creationBlock.assign((IJAssignmentTarget)instanceField, (IJExpression)JExpr._new((AbstractJClass)narrowedGeneratedClass).arg((IJExpression)factoryMethodContextParam.invoke("getApplicationContext")));
            creationBlock.invoke((IJExpression)instanceField, this.getInit());
            this.viewNotifierHelper.resetPreviousNotifier(creationBlock, previousNotifier);
            factoryMethodBody._return((IJExpression)instanceField);
        } else {
            factoryMethodBody._return((IJExpression)JExpr._new((AbstractJClass)narrowedGeneratedClass).arg((IJExpression)factoryMethodContextParam));
        }
    }

    public void createRebindMethod() {
        JMethod rebindMethod = this.generatedClass.method(1, (AbstractJType)this.getCodeModel().VOID, "rebind");
        JVar contextParam = rebindMethod.param((AbstractJType)this.getClasses().CONTEXT, "context");
        JBlock body = rebindMethod.body();
        body.assign((IJAssignmentTarget)this.getContextField(), (IJExpression)contextParam);
        body.invoke(this.getInit());
    }
}

