/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.holder;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JFieldVar;
import org.androidannotations.helper.ModelConstants;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.holder.GeneratedClassHolderDelegate;

class DataBindingDelegate
extends GeneratedClassHolderDelegate<EComponentWithViewSupportHolder> {
    private JFieldVar dataBindingField;

    DataBindingDelegate(EComponentWithViewSupportHolder holder) {
        super(holder);
    }

    JFieldVar getDataBindingField() {
        if (this.dataBindingField == null) {
            this.setDataBindingField();
        }
        return this.dataBindingField;
    }

    private void setDataBindingField() {
        AbstractJClass viewDataBinding = this.getClasses().VIEW_DATA_BINDING;
        if (this.getEnvironment().getProcessingEnvironment().getElementUtils().getTypeElement("androidx.databinding.ViewDataBinding") != null) {
            viewDataBinding = this.getClasses().ANDROIDX_VIEW_DATA_BINDING;
        }
        this.dataBindingField = ((EComponentWithViewSupportHolder)this.holder).generatedClass.field(4, (AbstractJType)viewDataBinding, "viewDataBinding" + ModelConstants.generationSuffix());
    }

    IJExpression getDataBindingInflationExpression(IJExpression contentViewId, IJExpression container, boolean attachToRoot) {
        AbstractJClass dataBindingUtil = this.getClasses().DATA_BINDING_UTIL;
        if (this.getEnvironment().getProcessingEnvironment().getElementUtils().getTypeElement("androidx.databinding.DataBindingUtil") != null) {
            dataBindingUtil = this.getClasses().ANDROIDX_DATA_BINDING_UTIL;
        }
        return dataBindingUtil.staticInvoke("inflate").arg((IJExpression)this.getClasses().LAYOUT_INFLATER.staticInvoke("from").arg(((EComponentWithViewSupportHolder)this.holder).getContextRef())).arg(contentViewId).arg(container).arg(attachToRoot);
    }
}

