/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.holder;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.EClassType;
import com.helger.jcodemodel.IJAnnotatable;
import com.helger.jcodemodel.IJGenerifiable;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JDirectClass;
import com.helger.jcodemodel.JTypeVar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.Option;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.helper.ModelConstants;
import org.androidannotations.holder.GeneratedClassHolder;
import org.androidannotations.internal.process.ProcessHolder;

public abstract class BaseGeneratedClassHolder
implements GeneratedClassHolder {
    public static final Option OPTION_GENERATE_FINAL_CLASSES = new Option("generateFinalClasses", "true");
    protected final AndroidAnnotationsEnvironment environment;
    protected JDefinedClass generatedClass;
    protected AbstractJClass annotatedClass;
    protected final TypeElement annotatedElement;
    protected final APTCodeModelHelper codeModelHelper;
    private Map<Class<?>, Object> pluginHolders = new HashMap();

    public BaseGeneratedClassHolder(AndroidAnnotationsEnvironment environment, TypeElement annotatedElement) throws Exception {
        this.environment = environment;
        this.annotatedElement = annotatedElement;
        this.codeModelHelper = new APTCodeModelHelper(environment);
        this.setGeneratedClass();
    }

    protected void setGeneratedClass() throws Exception {
        String annotatedComponentQualifiedName = this.annotatedElement.getQualifiedName().toString();
        this.annotatedClass = this.getCodeModel().directClass(this.annotatedElement.asType().toString());
        if (this.annotatedElement.getNestingKind().isNested()) {
            Element enclosingElement = this.annotatedElement.getEnclosingElement();
            GeneratedClassHolder enclosingHolder = this.environment.getGeneratedClassHolder(enclosingElement);
            String generatedBeanSimpleName = this.annotatedElement.getSimpleName().toString() + ModelConstants.classSuffix();
            int modifier = 17;
            if (this.environment.getOptionBooleanValue(OPTION_GENERATE_FINAL_CLASSES)) {
                modifier |= 8;
            }
            this.generatedClass = (JDefinedClass)enclosingHolder.getGeneratedClass()._class(modifier, generatedBeanSimpleName, EClassType.CLASS);
        } else {
            String generatedClassQualifiedName = annotatedComponentQualifiedName + ModelConstants.classSuffix();
            int modifier = 1;
            if (this.environment.getOptionBooleanValue(OPTION_GENERATE_FINAL_CLASSES)) {
                modifier |= 8;
            }
            this.generatedClass = this.getCodeModel()._class(modifier, generatedClassQualifiedName, EClassType.CLASS);
        }
        this.codeModelHelper.generify((IJGenerifiable)this.generatedClass, this.annotatedElement);
        this.setExtends();
        this.codeModelHelper.copyNonAAAnnotations((IJAnnotatable)this.generatedClass, this.annotatedElement.getAnnotationMirrors());
    }

    protected AbstractJClass getAnnotatedClass() {
        return this.annotatedClass;
    }

    protected void setExtends() {
        JDirectClass annotatedComponent = this.getCodeModel().directClass(this.annotatedElement.asType().toString());
        this.generatedClass._extends((AbstractJClass)annotatedComponent);
    }

    @Override
    public JDefinedClass getGeneratedClass() {
        return this.generatedClass;
    }

    @Override
    public TypeElement getAnnotatedElement() {
        return this.annotatedElement;
    }

    @Override
    public AndroidAnnotationsEnvironment getEnvironment() {
        return this.environment;
    }

    protected ProcessingEnvironment getProcessingEnvironment() {
        return this.environment.getProcessingEnvironment();
    }

    protected ProcessHolder.Classes getClasses() {
        return this.environment.getClasses();
    }

    protected JCodeModel getCodeModel() {
        return this.getEnvironment().getCodeModel();
    }

    protected AbstractJClass getJClass(String fullyQualifiedClassName) {
        return this.getEnvironment().getJClass(fullyQualifiedClassName);
    }

    protected AbstractJClass getJClass(Class<?> clazz) {
        return this.getEnvironment().getJClass(clazz);
    }

    public AbstractJClass narrow(AbstractJClass toNarrow) {
        ArrayList<JDirectClass> classes = new ArrayList<JDirectClass>();
        for (JTypeVar type : this.generatedClass.typeParams()) {
            classes.add(this.getCodeModel().directClass(type.name()));
        }
        if (classes.isEmpty()) {
            return toNarrow;
        }
        return toNarrow.narrow(classes);
    }

    public <T> T getPluginHolder(T pluginHolder) {
        Object currentPluginHolder = this.pluginHolders.get(pluginHolder.getClass());
        if (currentPluginHolder == null) {
            currentPluginHolder = pluginHolder;
            this.pluginHolders.put(pluginHolder.getClass(), pluginHolder);
        }
        return (T)currentPluginHolder;
    }
}

