/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.ElementValidation;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.helper.TargetAnnotationHelper;

public class ValidatorParameterHelper {
    protected final TargetAnnotationHelper annotationHelper;

    public Validator noParam() {
        return new NoParamValidator();
    }

    public OneParamValidator type(String qualifiedName) {
        return this.param(new ExactTypeParameterRequirement(qualifiedName));
    }

    public OneParamValidator extendsType(String qualifiedName) {
        return this.param(new ExtendsTypeParameterRequirement(qualifiedName));
    }

    public OneParamValidator extendsAnyOfTypes(String ... types) {
        return this.param(new ExtendsAnyOfTypesParameterRequirement(types));
    }

    public OneParamValidator anyType() {
        return this.param(new AnyTypeParameterRequirement());
    }

    public OneParamValidator annotatedWith(Class<? extends Annotation> annotationClass) {
        return this.param(new AnnotatedWithParameterRequirement(annotationClass));
    }

    public OneParamValidator primitiveOrWrapper(TypeKind primitive) {
        return this.param(new PrimitiveOrWrapperParameterRequirement(primitive));
    }

    public OneParamValidator anyOfTypes(String ... types) {
        return this.param(new AnyOfTypesParameterRequirement(types));
    }

    public OneParamValidator param(ParameterRequirement parameterRequirement) {
        return new OneParamValidator(parameterRequirement);
    }

    public InOrderParamValidator inOrder() {
        return new InOrderParamValidator();
    }

    public AnyOrderParamValidator anyOrder() {
        return new AnyOrderParamValidator();
    }

    public ValidatorParameterHelper(TargetAnnotationHelper targetAnnotationHelper) {
        this.annotationHelper = targetAnnotationHelper;
    }

    public class AnyTypeParameterRequirement
    extends BaseParameterRequirement {
        @Override
        public boolean isSatisfied(VariableElement parameter) {
            return true;
        }

        @Override
        protected String description() {
            return "any type";
        }
    }

    public class AnyOfTypesParameterRequirement
    extends BaseParameterRequirement {
        private List<String> types;

        public AnyOfTypesParameterRequirement(String ... types) {
            this.types = Arrays.asList(types);
        }

        @Override
        public boolean isSatisfied(VariableElement parameter) {
            return this.types.contains(parameter.asType().toString());
        }

        @Override
        protected String description() {
            return Arrays.toString(this.types.toArray());
        }
    }

    public class PrimitiveOrWrapperParameterRequirement
    extends BaseParameterRequirement {
        private TypeKind type;

        public PrimitiveOrWrapperParameterRequirement(TypeKind type) {
            this.type = type;
        }

        @Override
        protected String description() {
            return this.type.toString().toLowerCase() + " or " + this.getWrapperType();
        }

        @Override
        public boolean isSatisfied(VariableElement parameter) {
            return parameter.asType().getKind() == this.type || parameter.asType().toString().equals(this.getWrapperType());
        }

        private String getWrapperType() {
            switch (this.type) {
                case BOOLEAN: {
                    return CanonicalNameConstants.BOOLEAN;
                }
                case INT: {
                    return CanonicalNameConstants.INTEGER;
                }
                case BYTE: {
                    return CanonicalNameConstants.BYTE;
                }
                case SHORT: {
                    return CanonicalNameConstants.SHORT;
                }
                case LONG: {
                    return CanonicalNameConstants.LONG;
                }
                case CHAR: {
                    return CanonicalNameConstants.CHAR;
                }
                case FLOAT: {
                    return CanonicalNameConstants.FLOAT;
                }
                case DOUBLE: {
                    return CanonicalNameConstants.DOUBLE;
                }
            }
            throw new IllegalArgumentException("The TypeKind passed does not represent a primitive");
        }
    }

    public class AnnotatedWithParameterRequirement
    extends BaseParameterRequirement {
        private Class<? extends Annotation> annotationClass;

        public AnnotatedWithParameterRequirement(Class<? extends Annotation> annotationClass) {
            this.annotationClass = annotationClass;
        }

        @Override
        public boolean isSatisfied(VariableElement param) {
            return param.getAnnotation(this.annotationClass) != null;
        }

        @Override
        protected String description() {
            return "annotated with " + this.annotationClass.getSimpleName();
        }
    }

    public class ExtendsAnyOfTypesParameterRequirement
    extends BaseParameterRequirement {
        private List<String> types;

        public ExtendsAnyOfTypesParameterRequirement(String ... types) {
            this.types = Arrays.asList(types);
        }

        @Override
        public boolean isSatisfied(VariableElement parameter) {
            TypeMirror elementType = parameter.asType();
            for (String type : this.types) {
                TypeMirror expectedType;
                TypeElement typeElement = ValidatorParameterHelper.this.annotationHelper.typeElementFromQualifiedName(type);
                if (typeElement == null || !ValidatorParameterHelper.this.annotationHelper.isSubtype(elementType, expectedType = typeElement.asType())) continue;
                return true;
            }
            return false;
        }

        @Override
        protected String description() {
            StringBuilder builder = new StringBuilder();
            builder.append("extending one of the following: [");
            for (int i = 0; i < this.types.size() - 1; ++i) {
                builder.append(this.types.get(i)).append(", ");
            }
            builder.append(this.types.get(this.types.size() - 1)).append(" ]");
            return builder.toString();
        }
    }

    public class ExtendsTypeParameterRequirement
    extends BaseParameterRequirement {
        private String typeName;

        public ExtendsTypeParameterRequirement(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public boolean isSatisfied(VariableElement param) {
            TypeMirror elementType = param.asType();
            TypeElement typeElement = ValidatorParameterHelper.this.annotationHelper.typeElementFromQualifiedName(this.typeName);
            if (typeElement != null) {
                TypeMirror expectedType = typeElement.asType();
                return ValidatorParameterHelper.this.annotationHelper.isSubtype(elementType, expectedType);
            }
            return false;
        }

        @Override
        protected String description() {
            return "extending " + this.typeName;
        }
    }

    public class ExactTypeParameterRequirement
    extends BaseParameterRequirement {
        private String typeName;

        public ExactTypeParameterRequirement(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public boolean isSatisfied(VariableElement param) {
            return param.asType().toString().equals(this.typeName);
        }

        @Override
        protected String description() {
            return this.typeName;
        }
    }

    public abstract class BaseParameterRequirement
    implements ParameterRequirement {
        private boolean required = true;
        private boolean multiple = false;

        @Override
        public void setMultiple() {
            this.multiple = true;
        }

        @Override
        public boolean multiple() {
            return this.multiple;
        }

        @Override
        public void setOptional() {
            this.required = false;
        }

        @Override
        public boolean required() {
            return this.required;
        }

        protected abstract String description();

        public String toString() {
            return String.format("[ %s %s%s]", this.description(), this.required ? "" : "(optional) ", this.multiple ? "(multiple) " : "");
        }
    }

    public class AnyOrderParamValidator
    extends BaseParamValidator<AnyOrderParamValidator> {
        private List<ParameterRequirement> satisfiedParameterRequirements;

        public AnyOrderParamValidator() {
            this.satisfiedParameterRequirements = new ArrayList<ParameterRequirement>();
        }

        @Override
        public void validate(ExecutableElement executableElement, ElementValidation validation) {
            super.validate(executableElement, validation);
            for (VariableElement variableElement : executableElement.getParameters()) {
                ParameterRequirement foundParameter = null;
                for (ParameterRequirement expectedParameter : this.getParamRequirements()) {
                    if (!expectedParameter.isSatisfied(variableElement)) continue;
                    this.satisfiedParameterRequirements.add(expectedParameter);
                    foundParameter = expectedParameter;
                    break;
                }
                if (foundParameter == null) {
                    this.invalidate(executableElement, validation);
                    return;
                }
                if (foundParameter.multiple()) continue;
                this.getParamRequirements().remove(foundParameter);
            }
            for (ParameterRequirement parameterRequirement : this.getParamRequirements()) {
                if (!parameterRequirement.required() || this.satisfiedParameterRequirements.contains(parameterRequirement)) continue;
                this.invalidate(executableElement, validation);
                return;
            }
        }

        @Override
        protected String createMessage(ExecutableElement element) {
            return super.createMessage(element) + " in any order";
        }
    }

    public class InOrderParamValidator
    extends BaseParamValidator<InOrderParamValidator> {
        private int index;
        private ParameterRequirement currentParameterRequirement;
        private List<ParameterRequirement> satisfiedParameterRequirements;

        public InOrderParamValidator() {
            this.index = -1;
            this.satisfiedParameterRequirements = new ArrayList<ParameterRequirement>();
        }

        private void nextParameterRequirement() {
            ++this.index;
            this.currentParameterRequirement = this.index < this.getParamRequirements().size() ? this.getParamRequirements().get(this.index) : null;
        }

        @Override
        public void validate(ExecutableElement executableElement, ElementValidation validation) {
            super.validate(executableElement, validation);
            this.nextParameterRequirement();
            for (VariableElement variableElement : executableElement.getParameters()) {
                if (this.validate(variableElement)) continue;
                this.invalidate(executableElement, validation);
                return;
            }
            for (ParameterRequirement parameterRequirement : this.getParamRequirements()) {
                if (!parameterRequirement.required() || this.satisfiedParameterRequirements.contains(parameterRequirement)) continue;
                this.invalidate(executableElement, validation);
                return;
            }
        }

        private boolean validate(VariableElement parameter) {
            if (this.currentParameterRequirement == null) {
                return false;
            }
            if (this.currentParameterRequirement.isSatisfied(parameter)) {
                this.satisfiedParameterRequirements.add(this.currentParameterRequirement);
                if (!this.currentParameterRequirement.multiple()) {
                    this.nextParameterRequirement();
                }
            } else {
                if (this.currentParameterRequirement.required() && !this.satisfiedParameterRequirements.contains(this.currentParameterRequirement)) {
                    return false;
                }
                this.nextParameterRequirement();
                return this.validate(parameter);
            }
            return true;
        }

        @Override
        protected String createMessage(ExecutableElement element) {
            return super.createMessage(element) + " in the order above";
        }
    }

    private abstract class BaseParamValidator<V extends BaseParamValidator<?>>
    implements Validator {
        private List<ParameterRequirement> parameterRequirements = new ArrayList<ParameterRequirement>();
        private List<ParameterRequirement> originalParameterRequirements;

        private BaseParamValidator() {
        }

        @Override
        public void validate(ExecutableElement executableElement, ElementValidation validation) {
            this.originalParameterRequirements = new ArrayList<ParameterRequirement>(this.parameterRequirements);
        }

        public V type(String qualifiedName) {
            return this.param(new ExactTypeParameterRequirement(qualifiedName));
        }

        public V extendsType(String qualifiedName) {
            return this.param(new ExtendsTypeParameterRequirement(qualifiedName));
        }

        public V extendsAnyOfTypes(String ... types) {
            return this.param(new ExtendsAnyOfTypesParameterRequirement(types));
        }

        public V anyType() {
            return this.param(new AnyTypeParameterRequirement());
        }

        public V annotatedWith(Class<? extends Annotation> annotationClass) {
            return this.param(new AnnotatedWithParameterRequirement(annotationClass));
        }

        public V primitiveOrWrapper(TypeKind primitive) {
            return this.param(new PrimitiveOrWrapperParameterRequirement(primitive));
        }

        public V anyOfTypes(String ... types) {
            return this.param(new AnyOfTypesParameterRequirement(types));
        }

        public V param(ParameterRequirement parameterRequirement) {
            this.parameterRequirements.add(parameterRequirement);
            return this.castThis();
        }

        public V optional() {
            this.lastParam().setOptional();
            return this.castThis();
        }

        public V multiple() {
            this.lastParam().setMultiple();
            return this.castThis();
        }

        protected List<ParameterRequirement> getParamRequirements() {
            return this.parameterRequirements;
        }

        private ParameterRequirement lastParam() {
            if (this.parameterRequirements.isEmpty()) {
                throw new IllegalStateException("Call type, extendsType, annotatedWith or param before");
            }
            return this.parameterRequirements.get(this.parameterRequirements.size() - 1);
        }

        protected void invalidate(ExecutableElement element, ElementValidation validation) {
            validation.addError("%s can only have the following parameters: " + this.createMessage(element));
        }

        protected String createMessage(ExecutableElement element) {
            StringBuilder builder = new StringBuilder();
            builder.append("[ ");
            for (ParameterRequirement parameterRequirement : this.originalParameterRequirements) {
                builder.append(parameterRequirement).append(", ");
            }
            return builder.append(" ]").toString();
        }

        private V castThis() {
            return (V)this;
        }
    }

    public class OneParamValidator
    implements Validator {
        private ParameterRequirement parameterRequirement;

        public OneParamValidator(ParameterRequirement param) {
            this.parameterRequirement = param;
        }

        public OneParamValidator optional() {
            this.parameterRequirement.setOptional();
            return this;
        }

        public OneParamValidator multiple() {
            this.parameterRequirement.setMultiple();
            return this;
        }

        @Override
        public void validate(ExecutableElement executableElement, ElementValidation validation) {
            List<? extends VariableElement> parameters = executableElement.getParameters();
            if (!this.parameterRequirement.multiple()) {
                if (this.parameterRequirement.required() && parameters.size() != 1) {
                    this.invalidate(validation);
                    return;
                }
                if (!this.parameterRequirement.required() && parameters.size() > 1) {
                    this.invalidate(validation);
                    return;
                }
            }
            for (VariableElement variableElement : parameters) {
                if (this.parameterRequirement.isSatisfied(variableElement)) continue;
                this.invalidate(validation);
                return;
            }
        }

        protected void invalidate(ElementValidation validation) {
            validation.addError("method annotated with %s can only have the following parameter: " + this.parameterRequirement);
        }
    }

    public class NoParamValidator
    implements Validator {
        @Override
        public void validate(ExecutableElement executableElement, ElementValidation validation) {
            if (!executableElement.getParameters().isEmpty()) {
                validation.addError("%s cannot have any parameters");
            }
        }
    }

    public static interface ParameterRequirement {
        public void setMultiple();

        public boolean multiple();

        public void setOptional();

        public boolean required();

        public boolean isSatisfied(VariableElement var1);
    }

    public static interface Validator {
        public void validate(ExecutableElement var1, ElementValidation var2);
    }
}

