/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.annotations.EActivity;
import org.androidannotations.annotations.EBean;
import org.androidannotations.annotations.EFragment;
import org.androidannotations.annotations.EIntentService;
import org.androidannotations.annotations.EReceiver;
import org.androidannotations.annotations.EService;
import org.androidannotations.annotations.EView;
import org.androidannotations.annotations.EViewGroup;
import org.androidannotations.annotations.Trace;
import org.androidannotations.annotations.ViewById;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.BundleHelper;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.helper.ModelConstants;
import org.androidannotations.helper.ParcelerHelper;
import org.androidannotations.helper.TargetAnnotationHelper;
import org.androidannotations.helper.ValidatorParameterHelper;
import org.androidannotations.internal.core.model.AndroidSystemServices;
import org.androidannotations.internal.model.AnnotationElements;

public class ValidatorHelper {
    private static final List<String> ANDROID_FRAGMENT_QUALIFIED_NAMES = Arrays.asList("android.app.Fragment", "android.support.v4.app.Fragment", "androidx.fragment.app.Fragment");
    private static final Collection<Integer> VALID_LOG_LEVELS = Arrays.asList(2, 3, 4, 5, 6);
    private static final List<String> VALID_PREFERENCE_CLASSES = Arrays.asList("android.preference.PreferenceActivity", "android.preference.PreferenceFragment", "android.support.v4.preference.PreferenceFragment", "com.github.machinarius.preferencefragment.PreferenceFragment", "android.support.v7.preference.PreferenceFragmentCompat", "android.support.v14.preference.PreferenceFragment", "androidx.preference.PreferenceFragment", "androidx.preference.PreferenceFragmentCompat");
    protected final TargetAnnotationHelper annotationHelper;
    private final ParcelerHelper parcelerHelper;
    public final ValidatorParameterHelper param;

    public ValidatorHelper(TargetAnnotationHelper targetAnnotationHelper) {
        this.annotationHelper = targetAnnotationHelper;
        this.param = new ValidatorParameterHelper(this.annotationHelper);
        this.parcelerHelper = new ParcelerHelper(this.environment());
    }

    protected AndroidAnnotationsEnvironment environment() {
        return this.annotationHelper.getEnvironment();
    }

    protected AnnotationElements validatedModel() {
        return this.environment().getValidatedElements();
    }

    public void isNotFinal(Element element, ElementValidation valid) {
        if (this.annotationHelper.isFinal(element)) {
            valid.addError("%s cannot be used on a final element");
        }
    }

    public void isNotSynchronized(Element element, ElementValidation valid) {
        if (this.annotationHelper.isSynchronized(element)) {
            valid.addError("%s cannot be used on a synchronized element. If you think you shall need to use the synchronized keyword for a specific use case, please post on the mailing list.");
        }
    }

    public void isInterface(TypeElement element, ElementValidation valid) {
        if (!this.annotationHelper.isInterface(element)) {
            valid.addError("%s can only be used on an interface");
        }
    }

    public void isNotInterface(TypeElement element, ElementValidation valid) {
        if (this.annotationHelper.isInterface(element)) {
            valid.addError("%s cannot be used on an interface");
        }
    }

    public void isTopLevel(TypeElement element, ElementValidation valid) {
        if (!this.annotationHelper.isTopLevel(element)) {
            valid.addError("%s can only be used on a top level type");
        }
    }

    public void doesNotReturnPrimitive(ExecutableElement element, ElementValidation valid) {
        if (element.getReturnType().getKind().isPrimitive()) {
            valid.addError("%s cannot return primitive");
        }
    }

    public void isNotPrivate(Element element, ElementValidation valid) {
        if (this.annotationHelper.isPrivate(element)) {
            valid.addError("%s cannot be used on a private element");
        }
    }

    public void isPublic(Element element, ElementValidation valid) {
        if (!this.annotationHelper.isPublic(element)) {
            valid.addError(element, "%s cannot be used on a non public element");
        }
    }

    public void isStatic(Element element, ElementValidation valid) {
        if (!this.annotationHelper.isStatic(element)) {
            valid.addError(element, "%s cannot be used on a non static inner element");
        }
    }

    public void enclosingElementIsNotAbstractIfNotAbstract(Element element, ElementValidation validation) {
        if (!this.annotationHelper.isAbstract(element) && this.annotationHelper.isAbstract(element.getEnclosingElement())) {
            validation.addError("%s cannot be used on a non-abstract inner element whose outer element is abstract");
        }
    }

    public void enclosingElementHasAnnotation(Class<? extends Annotation> annotation, Element element, ElementValidation validation) {
        this.enclosingElementHasOneOfAnnotations(element, Collections.singletonList(annotation), validation);
    }

    public void enclosingElementHasEBeanAnnotation(Element element, ElementValidation valid) {
        this.enclosingElementHasAnnotation(EBean.class, element, valid);
    }

    public void enclosingElementHasEActivity(Element element, ElementValidation valid) {
        this.enclosingElementHasAnnotation(EActivity.class, element, valid);
    }

    public void enclosingElementHasEActivityOrEFragment(Element element, ElementValidation valid) {
        List<Class<? extends Annotation>> validAnnotations = Arrays.asList(EActivity.class, EFragment.class);
        this.enclosingElementHasOneOfAnnotations(element, validAnnotations, valid);
    }

    public void enclosingElementHasEActivityOrEFragmentOrEViewOrEViewGroup(Element element, ElementValidation valid) {
        List<Class<? extends Annotation>> validAnnotations = Arrays.asList(EActivity.class, EFragment.class, EView.class, EViewGroup.class);
        this.enclosingElementHasOneOfAnnotations(element, validAnnotations, valid);
    }

    public void enclosingElementHasEActivityOrEFragmentOrEServiceOrEIntentServiceOrEViewOrEViewGroup(Element element, ElementValidation valid) {
        List<Class<? extends Annotation>> validAnnotations = Arrays.asList(EActivity.class, EFragment.class, EService.class, EIntentService.class, EView.class, EViewGroup.class);
        this.enclosingElementHasOneOfAnnotations(element, validAnnotations, valid);
    }

    public void enclosingElementHasEFragment(Element element, ElementValidation valid) {
        this.enclosingElementHasAnnotation(EFragment.class, element, valid);
    }

    public void enclosingElementHasEIntentService(Element element, ElementValidation valid) {
        this.enclosingElementHasAnnotation(EIntentService.class, element, valid);
    }

    public void enclosingElementHasEReceiver(Element element, ElementValidation valid) {
        this.enclosingElementHasAnnotation(EReceiver.class, element, valid);
    }

    public void hasEActivity(Element element, ElementValidation valid) {
        this.hasAnnotation(element, element, EActivity.class, valid);
    }

    public void hasEActivityOrEFragment(Element element, ElementValidation valid) {
        List<Class<? extends Annotation>> validAnnotations = Arrays.asList(EActivity.class, EFragment.class);
        this.hasOneOfAnnotations(element, element, validAnnotations, valid);
    }

    public void enclosingElementHasEnhancedViewSupportAnnotation(Element element, ElementValidation valid) {
        this.enclosingElementHasOneOfAnnotations(element, ModelConstants.VALID_ENHANCED_VIEW_SUPPORT_ANNOTATIONS, valid);
    }

    public void enclosingElementHasEnhancedComponentAnnotation(Element element, ElementValidation valid) {
        this.enclosingElementHasOneOfAnnotations(element, ModelConstants.VALID_ENHANCED_COMPONENT_ANNOTATIONS, valid);
    }

    public void enclosingElementHasAndroidAnnotation(Element element, ElementValidation valid) {
        this.enclosingElementHasOneOfAnnotations(element, this.environment().getGeneratingAnnotations(), valid);
    }

    private void hasAnnotation(Element element, Element reportElement, Class<? extends Annotation> validAnnotation, ElementValidation valid) {
        ArrayList<Class<? extends Annotation>> validAnnotations = new ArrayList<Class<? extends Annotation>>();
        validAnnotations.add(validAnnotation);
        this.hasOneOfAnnotations(element, reportElement, validAnnotations, valid);
    }

    public void enclosingElementHasOneOfAnnotations(Element element, List<Class<? extends Annotation>> validAnnotations, ElementValidation validation) {
        this.hasOneOfAnnotations(element, element.getEnclosingElement(), validAnnotations, validation);
    }

    public void hasOneOfAnnotations(Element reportElement, Element element, List<Class<? extends Annotation>> validAnnotations, ElementValidation validation) {
        this.checkAnnotations(reportElement, element, validAnnotations, true, validation);
    }

    public void doesNotHaveOneOfAnnotations(Element element, List<Class<? extends Annotation>> validAnnotations, ElementValidation validation) {
        this.checkAnnotations(element, element, validAnnotations, false, validation);
    }

    public void doesNotHaveAnnotation(Element element, Class<? extends Annotation> annotation, ElementValidation validation) {
        this.doesNotHaveOneOfAnnotations(element, Collections.singletonList(annotation), validation);
    }

    public void doesNotHaveAnyOfSupportedAnnotations(Element element, ElementValidation validation) {
        Set<String> supportedAnnotationTypes = this.environment().getSupportedAnnotationTypes();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!supportedAnnotationTypes.contains(annotationMirror.getAnnotationType().toString())) continue;
            validation.addError(element, "method injection does only allow the annotation to be placed on the method OR on each parameter.");
            break;
        }
    }

    private void checkAnnotations(Element reportElement, Element element, List<Class<? extends Annotation>> validAnnotations, boolean shouldFind, ElementValidation validation) {
        boolean foundAnnotation = false;
        for (Class<? extends Annotation> validAnnotation : validAnnotations) {
            if (element.getAnnotation(validAnnotation) == null) continue;
            foundAnnotation = true;
            break;
        }
        if (shouldFind != foundAnnotation) {
            String not = shouldFind ? "" : " not";
            validation.addError(reportElement, "%s can only be used in a " + element.getKind().toString().toLowerCase() + not + " annotated with " + this.getFormattedValidEnhancedBeanAnnotationTypes(validAnnotations) + ".");
        }
    }

    private String getFormattedValidEnhancedBeanAnnotationTypes(List<Class<? extends Annotation>> annotations) {
        StringBuilder sb = new StringBuilder();
        if (!annotations.isEmpty()) {
            sb.append("@" + annotations.get(0).getName());
            for (int i = 1; i < annotations.size(); ++i) {
                sb.append(", ");
                sb.append("@" + annotations.get(i));
            }
        }
        return sb.toString();
    }

    public void hasViewByIdAnnotation(Element element, ElementValidation valid) {
        String error = "can only be used with annotation";
        this.elementHasAnnotation(ViewById.class, element, valid, error);
    }

    public void enclosingElementHasAnnotation(Class<? extends Annotation> annotation, Element element, ElementValidation valid, String error) {
        Element enclosingElement = element.getEnclosingElement();
        this.elementHasAnnotation(annotation, enclosingElement, valid, error);
    }

    public void elementHasAnnotation(Class<? extends Annotation> annotation, Element element, ElementValidation valid, String error) {
        if (!this.elementHasAnnotation(annotation, element) && element.getAnnotation(annotation) == null) {
            valid.addError("%s " + error + " @" + annotation.getName());
        }
    }

    public boolean elementHasAnnotation(Class<? extends Annotation> annotation, Element element) {
        Set<? extends Element> layoutAnnotatedElements = this.validatedModel().getRootAnnotatedElements(annotation.getName());
        return layoutAnnotatedElements.contains(element);
    }

    public void typeHasAnnotation(Class<? extends Annotation> annotation, Element element, ElementValidation valid) {
        TypeMirror elementType = element.asType();
        this.typeHasAnnotation(annotation, elementType, valid);
    }

    public void typeHasValidAnnotation(Class<? extends Annotation> annotation, Element element, ElementValidation valid) {
        this.typeHasAnnotation(annotation, element, valid);
        if (valid.isValid()) {
            this.typeIsValid(annotation, element.asType(), valid);
        }
    }

    public void typeHasAnnotation(Class<? extends Annotation> annotation, TypeMirror elementType, ElementValidation valid) {
        Element typeElement = this.annotationHelper.getTypeUtils().asElement(elementType);
        if (!this.elementHasAnnotationSafe(annotation, typeElement)) {
            valid.addError("%s can only be used on an element annotated with @" + annotation.getName());
        }
    }

    public void typeOrTargetValueHasAnnotation(Class<? extends Annotation> annotation, Element element, ElementValidation valid) {
        Element targetElement = this.findTargetElement(element, valid);
        if (targetElement == null) {
            return;
        }
        DeclaredType targetAnnotationClassValue = this.annotationHelper.extractAnnotationClassParameter(element);
        if (targetAnnotationClassValue != null) {
            targetElement = targetAnnotationClassValue.asElement();
            if (!this.annotationHelper.getTypeUtils().isAssignable(targetAnnotationClassValue, targetElement.asType())) {
                valid.addError("The value of %s must be assignable into the annotated field");
            }
        }
        this.typeHasValidAnnotation(annotation, targetElement, valid);
    }

    Element findTargetElement(Element element, ElementValidation valid) {
        if (element instanceof ExecutableElement) {
            ExecutableElement executableElement = (ExecutableElement)element;
            this.returnTypeIsVoid(executableElement, valid);
            if (!valid.isValid()) {
                return null;
            }
            List<? extends VariableElement> parameters = executableElement.getParameters();
            if (parameters.size() != 1) {
                valid.addError("The method can only have 1 parameter");
                return null;
            }
            return parameters.get(0);
        }
        return element;
    }

    public void typeIsValid(Class<? extends Annotation> annotation, TypeMirror elementType, ElementValidation elementValidation) {
        Element typeElement;
        Set<? extends Element> validElements = this.validatedModel().getRootAnnotatedElements(annotation.getName());
        Set<? extends Element> extractedElements = this.environment().getExtractedElements().getRootAnnotatedElements(annotation.getName());
        if (!extractedElements.contains(typeElement = this.annotationHelper.getTypeUtils().asElement(elementType)) || validElements.contains(typeElement)) {
            return;
        }
        elementValidation.addError("The type " + typeElement.getSimpleName() + " is invalid, please check the messages on that type.");
    }

    private boolean elementHasAnnotationSafe(Class<? extends Annotation> annotation, Element element) {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!annotationMirror.getAnnotationType().toString().equals(annotation.getName())) continue;
            return true;
        }
        return false;
    }

    public int numberOfElementParameterHasAnnotation(ExecutableElement element, Class<? extends Annotation> annotation) {
        int count = 0;
        for (VariableElement variableElement : element.getParameters()) {
            if (variableElement.getAnnotation(annotation) == null) continue;
            ++count;
        }
        return count;
    }

    public void doesntThrowException(Element element, ElementValidation valid) {
        ExecutableElement executableElement = (ExecutableElement)element;
        if (executableElement.getThrownTypes().size() > 0) {
            valid.addError("%s annotated methods should not declare throwing any exception");
        }
    }

    public void returnTypeIsVoidOrBoolean(ExecutableElement executableElement, ElementValidation valid) {
        TypeMirror returnType = executableElement.getReturnType();
        TypeKind returnKind = returnType.getKind();
        if (returnKind != TypeKind.BOOLEAN && returnKind != TypeKind.VOID && !returnType.toString().equals(CanonicalNameConstants.BOOLEAN)) {
            valid.addError("%s can only be used on a method with a boolean or a void return type");
        }
    }

    public void returnTypeIsVoid(ExecutableElement executableElement, ElementValidation valid) {
        TypeMirror returnType = executableElement.getReturnType();
        if (returnType.getKind() != TypeKind.VOID) {
            valid.addError("%s can only be used on a method with a void return type");
        }
    }

    public void returnTypeIsNotVoid(ExecutableElement executableElement, ElementValidation valid) {
        TypeMirror returnType = executableElement.getReturnType();
        if (returnType.getKind() == TypeKind.VOID) {
            valid.addError("%s can only be used on a method with a return type non void");
        }
    }

    public void extendsActivity(Element element, ElementValidation valid) {
        this.extendsType(element, "android.app.Activity", valid);
    }

    public void extendsFragment(Element element, ElementValidation valid) {
        this.extendsOneOfTypes(element, ANDROID_FRAGMENT_QUALIFIED_NAMES, valid);
    }

    public void extendsService(Element element, ElementValidation valid) {
        this.extendsType(element, "android.app.Service", valid);
    }

    public void extendsIntentService(Element element, ElementValidation valid) {
        this.extendsType(element, "android.app.IntentService", valid);
    }

    public void extendsReceiver(Element element, ElementValidation valid) {
        this.extendsType(element, "android.content.BroadcastReceiver", valid);
    }

    public void extendsProvider(Element element, ElementValidation valid) {
        this.extendsType(element, "android.content.ContentProvider", valid);
    }

    public void extendsView(Element element, ElementValidation valid) {
        this.extendsType(element, "android.view.View", valid);
    }

    public void extendsTextView(Element element, ElementValidation valid) {
        this.extendsType(element, "android.widget.TextView", valid);
    }

    public void extendsViewGroup(Element element, ElementValidation valid) {
        this.extendsType(element, "android.view.ViewGroup", valid);
    }

    public void extendsApplication(Element element, ElementValidation valid) {
        this.extendsType(element, "android.app.Application", valid);
    }

    public void extendsContext(Element element, ElementValidation valid) {
        this.extendsType(element, "android.content.Context", valid);
    }

    public void extendsMenuItem(Element element, ElementValidation valid) {
        Element enclosingElement = element.getEnclosingElement();
        String enclosingQualifiedName = enclosingElement.asType().toString();
        TypeElement enclosingTypeElement = this.annotationHelper.typeElementFromQualifiedName(enclosingQualifiedName);
        if (enclosingTypeElement != null) {
            this.extendsType(element, "android.view.MenuItem", valid);
        }
    }

    public void extendsMenu(Element element, ElementValidation validation) {
        Element enclosingElement = element.getEnclosingElement();
        String enclosingQualifiedName = enclosingElement.asType().toString();
        TypeElement enclosingTypeElement = this.annotationHelper.typeElementFromQualifiedName(enclosingQualifiedName);
        if (enclosingTypeElement != null) {
            this.extendsType(element, "android.view.Menu", validation);
        }
    }

    public void extendsListOfView(Element element, ElementValidation valid) {
        DeclaredType elementType = (DeclaredType)element.asType();
        List<? extends TypeMirror> elementTypeArguments = elementType.getTypeArguments();
        TypeMirror viewType = this.annotationHelper.typeElementFromQualifiedName("android.view.View").asType();
        if (!elementType.toString().equals(CanonicalNameConstants.LIST) && elementTypeArguments.size() == 1 && !this.annotationHelper.isSubtype(elementTypeArguments.get(0), viewType)) {
            valid.invalidate();
            valid.addError("%s can only be used on a " + CanonicalNameConstants.LIST + " of elements extending " + "android.view.View");
        }
    }

    public void extendsPreference(Element element, ElementValidation validation) {
        this.extendsOneOfTypes(element, Arrays.asList("android.preference.Preference", "android.support.v7.preference.Preference", "androidx.preference.Preference"), validation);
    }

    public void extendsOneOfTypes(Element element, List<String> typeQualifiedNames, ElementValidation valid) {
        TypeMirror elementType = element.asType();
        for (String typeQualifiedName : typeQualifiedNames) {
            TypeMirror expectedType;
            TypeElement typeElement = this.annotationHelper.typeElementFromQualifiedName(typeQualifiedName);
            if (typeElement == null || !this.annotationHelper.isSubtype(elementType, expectedType = typeElement.asType())) continue;
            return;
        }
        valid.addError("%s can only be used on an element that extends one of the following classes: " + typeQualifiedNames);
    }

    public void extendsType(Element element, String typeQualifiedName, ElementValidation valid) {
        if (!this.extendsType(element, typeQualifiedName)) {
            valid.addError("%s can only be used on an element that extends " + typeQualifiedName);
        }
    }

    protected boolean extendsType(Element element, String typeQualifiedName) {
        TypeMirror elementType = element.asType();
        TypeElement typeElement = this.annotationHelper.typeElementFromQualifiedName(typeQualifiedName);
        if (typeElement != null) {
            TypeMirror expectedType = typeElement.asType();
            return this.annotationHelper.isSubtype(elementType, expectedType);
        }
        return false;
    }

    public void allowedType(Element element, List<String> allowedTypes, ElementValidation valid) {
        String qualifiedName;
        Element enclosingElement = element.getEnclosingElement();
        if (element instanceof VariableElement && enclosingElement instanceof ExecutableElement) {
            qualifiedName = element.asType().toString();
        } else if (element instanceof ExecutableElement) {
            element = ((ExecutableElement)element).getParameters().get(0);
            qualifiedName = element.asType().toString();
        } else {
            qualifiedName = element.asType().toString();
        }
        if (!allowedTypes.contains(qualifiedName)) {
            valid.addError("%s can only be used on a field which is a " + allowedTypes.toString() + ", not " + qualifiedName);
        }
    }

    public void androidService(Element element, ElementValidation valid) {
        TypeMirror serviceType;
        Element targetElement = this.findTargetElement(element, valid);
        if (targetElement == null) {
            return;
        }
        AndroidSystemServices androidSystemServices = new AndroidSystemServices(this.environment());
        if (!androidSystemServices.contains(serviceType = targetElement.asType())) {
            valid.addError("Unknown service type: " + serviceType.toString());
        }
    }

    public void isDeclaredType(Element element, ElementValidation valid) {
        if (!(element.asType() instanceof DeclaredType)) {
            valid.addError("%s can only be used on a field which is a declared type");
        }
    }

    public void notAlreadyValidated(Element element, ElementValidation valid) {
        if (this.validatedModel().getAllElements().contains(element)) {
            valid.addError("%s annotated element cannot be used with the other annotations used on this element.");
        }
    }

    public void isAbstractOrHasEmptyOrContextConstructor(Element element, ElementValidation valid) {
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(element.getEnclosedElements());
        if (!this.annotationHelper.isAbstract(element)) {
            if (constructors.size() == 1) {
                ExecutableElement constructor = constructors.get(0);
                if (!this.annotationHelper.isPrivate(constructor)) {
                    VariableElement parameter;
                    if (constructor.getParameters().size() > 1) {
                        valid.addError("%s annotated element should have a constructor with one parameter max, of type android.content.Context");
                    } else if (constructor.getParameters().size() == 1 && !(parameter = constructor.getParameters().get(0)).asType().toString().equals("android.content.Context")) {
                        valid.addError("%s annotated element should have a constructor with one parameter max, of type android.content.Context");
                    }
                } else {
                    valid.addError("%s annotated element should not have a private constructor");
                }
            } else {
                valid.addError("%s annotated element should have only one constructor");
            }
        }
    }

    public void isAbstractOrHasEmptyConstructor(Element element, ElementValidation valid) {
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(element.getEnclosedElements());
        if (!this.annotationHelper.isAbstract(element)) {
            if (constructors.size() == 1) {
                ExecutableElement constructor = constructors.get(0);
                if (!this.annotationHelper.isPrivate(constructor)) {
                    if (constructor.getParameters().size() != 0) {
                        valid.addError("%s annotated element should have an empty constructor");
                    }
                } else {
                    valid.addError("%s annotated element should not have a private constructor");
                }
            } else {
                valid.addError("%s annotated element should have only one constructor");
            }
        }
    }

    public void hasValidLogLevel(Element element, ElementValidation valid) {
        Trace annotation = element.getAnnotation(Trace.class);
        Integer level = annotation.level();
        if (!VALID_LOG_LEVELS.contains(level)) {
            valid.addError("Unrecognized log level.");
        }
    }

    public void canBePutInABundle(Element element, ElementValidation valid) {
        TypeMirror typeMirror = element.asType();
        String typeString = element.asType().toString();
        if (!this.isKnownBundleCompatibleType(typeString)) {
            if (typeMirror instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)element.asType();
                typeMirror = arrayType.getComponentType();
            }
            if (typeMirror.getKind() != TypeKind.NONE) {
                TypeMirror parcelableType = this.annotationHelper.typeElementFromQualifiedName("android.os.Parcelable").asType();
                TypeMirror serializableType = this.annotationHelper.typeElementFromQualifiedName("java.io.Serializable").asType();
                if (typeString.startsWith("android.util.SparseArray")) {
                    DeclaredType declaredType = (DeclaredType)typeMirror;
                    List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                    if (typeArguments.size() != 1 || !this.annotationHelper.isSubtype(typeArguments.get(0), parcelableType)) {
                        valid.addError("Unrecognized type. The type argument of SparseArray should implement Parcelable.");
                    }
                } else if (!(this.annotationHelper.isSubtype(typeMirror, parcelableType) || this.annotationHelper.isSubtype(typeMirror, serializableType) || this.parcelerHelper.isParcelType(typeMirror))) {
                    valid.addError("Unrecognized type. Please let your attribute be primitive or implement Serializable or Parcelable or an annotated Parceler bean.");
                }
            }
        }
    }

    private boolean isKnownBundleCompatibleType(String type) {
        return BundleHelper.METHOD_SUFFIX_BY_TYPE_NAME.containsKey(type);
    }

    public void componentRegistered(Element element, AndroidManifest androidManifest, ElementValidation valid) {
        this.componentRegistered(element, androidManifest, true, valid);
    }

    public void componentRegistered(Element element, AndroidManifest androidManifest, boolean printWarning, ElementValidation valid) {
        TypeElement typeElement = (TypeElement)element;
        if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return;
        }
        if (androidManifest.isLibraryProject()) {
            return;
        }
        String componentQualifiedName = typeElement.getQualifiedName().toString();
        String generatedComponentQualifiedName = componentQualifiedName + ModelConstants.classSuffix();
        List<String> componentQualifiedNames = androidManifest.getComponentQualifiedNames();
        if (!componentQualifiedNames.contains(generatedComponentQualifiedName)) {
            String simpleName = typeElement.getSimpleName().toString();
            String generatedSimpleName = simpleName + ModelConstants.classSuffix();
            if (componentQualifiedNames.contains(componentQualifiedName)) {
                valid.addError("The AndroidManifest.xml file contains the original component, and not the AndroidAnnotations generated component. Please register " + generatedSimpleName + " instead of " + simpleName);
            } else if (printWarning) {
                valid.addWarning("The component " + generatedSimpleName + " is not registered in the AndroidManifest.xml file.");
            }
        }
    }

    public void isDebuggable(AndroidManifest androidManifest, ElementValidation valid) {
        if (!androidManifest.isDebuggable()) {
            valid.addError("The application must be in debuggable mode. Please set android:debuggable to true in your AndroidManifest.xml file.");
        }
    }

    public void hasInternetPermission(AndroidManifest androidManifest, ElementValidation valid) {
        this.hasPermission(androidManifest, valid, "android.permission.INTERNET");
    }

    public void hasWakeLockPermission(AndroidManifest androidManifest, ElementValidation valid) {
        this.hasPermission(androidManifest, valid, "android.permission.WAKE_LOCK");
    }

    public void hasPermission(AndroidManifest androidManifest, ElementValidation valid, String permissionQualifiedName) {
        List<String> permissionQualifiedNames = androidManifest.getPermissionQualifiedNames();
        if (!permissionQualifiedNames.contains(permissionQualifiedName)) {
            if (androidManifest.isLibraryProject()) {
                valid.addWarning("Your library should require the " + permissionQualifiedName + " permission.");
            } else {
                valid.addError("Your application must require the " + permissionQualifiedName + " permission.");
            }
        }
    }

    public void hasNotMultipleAnnotatedMethodWithSameName(Element element, ElementValidation valid, Class<? extends Annotation> annotation) {
        TreeSet<String> actionNames = new TreeSet<String>();
        List<? extends Element> enclosedElements = element.getEnclosedElements();
        for (Element element2 : enclosedElements) {
            if (element2.getKind() != ElementKind.METHOD || !this.annotationHelper.hasOneOfClassAnnotations(element2, annotation)) continue;
            String enclosedElementName = element2.getSimpleName().toString();
            if (actionNames.contains(enclosedElementName)) {
                valid.addError(element2, "The " + TargetAnnotationHelper.annotationName(annotation) + " annotated method must have unique name even if the signature is not the same");
                continue;
            }
            actionNames.add(enclosedElementName);
        }
    }

    public void extendsPreferenceActivityOrPreferenceFragment(Element element, ElementValidation valid) {
        this.extendsOneOfTypes(element, VALID_PREFERENCE_CLASSES, valid);
    }

    public void extendsPreferenceActivity(Element element, ElementValidation valid) {
        this.extendsType(element, "android.preference.PreferenceActivity", valid);
    }

    public void enclosingElementExtendsPreferenceActivityOrPreferenceFragment(Element element, ElementValidation valid) {
        this.extendsOneOfTypes(element.getEnclosingElement(), VALID_PREFERENCE_CLASSES, valid);
    }

    public boolean isClassPresent(String className) {
        return this.annotationHelper.getElementUtils().getTypeElement(className) != null;
    }

    public void isPreferenceFragmentClassPresent(Element element, ElementValidation valid) {
        if (!this.isClassPresent("android.preference.PreferenceFragment")) {
            valid.addError("The class android.preference.PreferenceFragment cannot be found. You have to use at least API 11");
        }
    }

    public void isViewPagerClassPresent(ElementValidation validation) {
        if (!this.isClassPresent("android.support.v4.view.ViewPager") && !this.isClassPresent("androidx.viewpager.widget.ViewPager")) {
            validation.addError("The classes android.support.v4.view.ViewPager and androidx.viewpager.widget.ViewPager cannot be found. You have to include support-v4 or androidx.viewpager library");
        }
    }
}

