/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import java.lang.annotation.Annotation;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.helper.AnnotationHelper;

public class TargetAnnotationHelper
extends AnnotationHelper {
    private String annotationName;

    public TargetAnnotationHelper(AndroidAnnotationsEnvironment environment, String annotationName) {
        super(environment);
        this.annotationName = annotationName;
    }

    public <T> T extractAnnotationValueParameter(Element element) {
        return this.extractAnnotationParameter(element, "value");
    }

    public <T> T extractAnnotationParameter(Element element, String methodName) {
        return this.extractAnnotationParameter(element, this.annotationName, methodName);
    }

    public DeclaredType extractAnnotationClassParameter(Element element) {
        return this.extractAnnotationClassParameter(element, this.annotationName);
    }

    public String getTarget() {
        return this.annotationName;
    }

    public String actionName() {
        return this.actionName(this.annotationName);
    }

    public static String annotationName(String annotationName) {
        return "@" + annotationName;
    }

    public static String annotationName(Class<? extends Annotation> annotation) {
        return TargetAnnotationHelper.annotationName(annotation.getName());
    }

    public String annotationName() {
        return TargetAnnotationHelper.annotationName(this.annotationName);
    }
}

