/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.helper.AnnotationHelper;

public class ParcelerHelper
extends AnnotationHelper {
    private static final Map<String, Integer> SUPPORTED_PARCEL_TYPES = new HashMap<String, Integer>();

    public ParcelerHelper(AndroidAnnotationsEnvironment environment) {
        super(environment);
    }

    public boolean isParcelType(TypeMirror typeMirror) {
        return this.isParcelType(typeMirror, true);
    }

    public boolean isParcelType(TypeMirror typeMirror, boolean root) {
        if (typeMirror instanceof DeclaredType && this.getElementUtils().getTypeElement("org.parceler.Parcel") != null) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            TypeElement element = (TypeElement)declaredType.asElement();
            String name = element.getQualifiedName().toString();
            if (this.isAnnotatedWith(element, "org.parceler.Parcel")) {
                return true;
            }
            if (SUPPORTED_PARCEL_TYPES.containsKey(name)) {
                boolean genericsMatch = true;
                Integer genericsSize = SUPPORTED_PARCEL_TYPES.get(name);
                if (!(genericsSize.intValue() != declaredType.getTypeArguments().size() || root && genericsSize <= 0)) {
                    for (int i = 0; i < genericsSize; ++i) {
                        genericsMatch &= this.isParcelType(declaredType.getTypeArguments().get(i), false);
                    }
                    return genericsMatch;
                }
            }
        }
        return false;
    }

    static {
        SUPPORTED_PARCEL_TYPES.put(Collection.class.getName(), 1);
        SUPPORTED_PARCEL_TYPES.put(List.class.getName(), 1);
        SUPPORTED_PARCEL_TYPES.put(ArrayList.class.getName(), 1);
        SUPPORTED_PARCEL_TYPES.put(Set.class.getName(), 1);
        SUPPORTED_PARCEL_TYPES.put(HashSet.class.getName(), 2);
        SUPPORTED_PARCEL_TYPES.put(TreeSet.class.getName(), 2);
        SUPPORTED_PARCEL_TYPES.put("android.util.SparseArray", 1);
        SUPPORTED_PARCEL_TYPES.put(Map.class.getName(), 2);
        SUPPORTED_PARCEL_TYPES.put(HashMap.class.getName(), 2);
        SUPPORTED_PARCEL_TYPES.put(TreeMap.class.getName(), 2);
        SUPPORTED_PARCEL_TYPES.put(Integer.class.getName(), 0);
        SUPPORTED_PARCEL_TYPES.put(Long.class.getName(), 0);
        SUPPORTED_PARCEL_TYPES.put(Double.class.getName(), 0);
        SUPPORTED_PARCEL_TYPES.put(Float.class.getName(), 0);
        SUPPORTED_PARCEL_TYPES.put(Byte.class.getName(), 0);
        SUPPORTED_PARCEL_TYPES.put(String.class.getName(), 0);
        SUPPORTED_PARCEL_TYPES.put(Character.class.getName(), 0);
        SUPPORTED_PARCEL_TYPES.put(Boolean.class.getName(), 0);
        SUPPORTED_PARCEL_TYPES.put(byte[].class.getName(), 0);
        SUPPORTED_PARCEL_TYPES.put(char[].class.getName(), 0);
        SUPPORTED_PARCEL_TYPES.put(boolean[].class.getName(), 0);
        SUPPORTED_PARCEL_TYPES.put("android.os.IBinder", 0);
        SUPPORTED_PARCEL_TYPES.put("android.os.Bundle", 0);
        SUPPORTED_PARCEL_TYPES.put("android.util.SparseBooleanArray", 0);
        SUPPORTED_PARCEL_TYPES.put(LinkedList.class.getName(), 1);
        SUPPORTED_PARCEL_TYPES.put(LinkedHashMap.class.getName(), 2);
        SUPPORTED_PARCEL_TYPES.put(SortedMap.class.getName(), 2);
        SUPPORTED_PARCEL_TYPES.put(SortedSet.class.getName(), 1);
        SUPPORTED_PARCEL_TYPES.put(LinkedHashSet.class.getName(), 1);
    }
}

