/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.SourceVersion;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.Option;
import org.androidannotations.annotations.EActivity;
import org.androidannotations.annotations.EApplication;
import org.androidannotations.annotations.EBean;
import org.androidannotations.annotations.EFragment;
import org.androidannotations.annotations.EIntentService;
import org.androidannotations.annotations.EProvider;
import org.androidannotations.annotations.EReceiver;
import org.androidannotations.annotations.EService;
import org.androidannotations.annotations.EView;
import org.androidannotations.annotations.EViewGroup;

public abstract class ModelConstants {
    public static final Option OPTION_CLASS_SUFFIX = new Option("classSuffix", "_");
    private static String generationSuffix = "_";
    private static String classSuffix;
    public static final List<Class<? extends Annotation>> VALID_ENHANCED_VIEW_SUPPORT_ANNOTATIONS;
    public static final List<Class<? extends Annotation>> VALID_ENHANCED_COMPONENT_ANNOTATIONS;

    private ModelConstants() {
    }

    public static void init(AndroidAnnotationsEnvironment environment) {
        classSuffix = environment.getOptionValue(OPTION_CLASS_SUFFIX).trim();
        if (classSuffix.isEmpty()) {
            throw new IllegalArgumentException("'" + classSuffix + "' may not be an empty string.");
        }
        if (!SourceVersion.isName("ValidName" + classSuffix) || classSuffix.contains(".")) {
            throw new IllegalArgumentException("'" + classSuffix + "' may not be a valid Java identifier.");
        }
    }

    public static String classSuffix() {
        return classSuffix;
    }

    public static String generationSuffix() {
        return generationSuffix;
    }

    static {
        VALID_ENHANCED_VIEW_SUPPORT_ANNOTATIONS = Arrays.asList(EActivity.class, EViewGroup.class, EView.class, EBean.class, EFragment.class);
        VALID_ENHANCED_COMPONENT_ANNOTATIONS = Arrays.asList(EApplication.class, EActivity.class, EViewGroup.class, EView.class, EBean.class, EService.class, EIntentService.class, EReceiver.class, EProvider.class, EFragment.class);
    }
}

