/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.helper.CaseHelper;
import org.androidannotations.helper.TargetAnnotationHelper;

public class KeyCodeHelper
extends TargetAnnotationHelper {
    public static final String KEYCODE_PREFIX = "KEYCODE";
    public static final int KEYCODE_NOT_FOUND = -1;
    private static final Pattern METHOD_NAME_PATTERN = Pattern.compile("^(on)?(.+?)(Pressed)?$");
    private Map<String, Integer> keyCodesByName;
    private Map<Integer, String> keyNamesByCode;

    public KeyCodeHelper(AndroidAnnotationsEnvironment environment, String annotationName) {
        super(environment, annotationName);
    }

    public int[] extractKeyCode(Element element) {
        Matcher matcher;
        int[] value = (int[])this.extractAnnotationValueParameter(element);
        if (value.length == 0 && (matcher = METHOD_NAME_PATTERN.matcher(element.getSimpleName())).matches()) {
            String extractedKeyName = matcher.group(2).toLowerCase();
            String constantName = CaseHelper.camelCaseToUpperSnakeCase(KEYCODE_PREFIX, extractedKeyName, "");
            int keyCode = this.getKeyCodeForName(constantName);
            if (keyCode == -1) {
                return value;
            }
            value = new int[]{keyCode};
        }
        return value;
    }

    public int getKeyCodeForName(String fieldName) {
        Integer keyCode;
        if (this.keyCodesByName == null) {
            this.keyCodesByName = new HashMap<String, Integer>();
            List<VariableElement> keyEventEnclosedFieldElements = this.getKeyEventEnclosedFieldElements();
            for (VariableElement element : keyEventEnclosedFieldElements) {
                if (!element.getSimpleName().toString().contains(KEYCODE_PREFIX)) continue;
                this.keyCodesByName.put(element.getSimpleName().toString(), (Integer)element.getConstantValue());
            }
        }
        return (keyCode = this.keyCodesByName.get(fieldName)) != null ? keyCode : -1;
    }

    public String getFieldNameForKeyCode(int keyCode) {
        if (this.keyNamesByCode == null) {
            this.keyNamesByCode = new HashMap<Integer, String>();
            List<VariableElement> keyEventEnclosedFieldElements = this.getKeyEventEnclosedFieldElements();
            for (VariableElement element : keyEventEnclosedFieldElements) {
                if (!element.getSimpleName().toString().contains(KEYCODE_PREFIX)) continue;
                this.keyNamesByCode.put((Integer)element.getConstantValue(), element.getSimpleName().toString());
            }
        }
        return this.keyNamesByCode.get(keyCode);
    }

    private List<VariableElement> getKeyEventEnclosedFieldElements() {
        TypeElement keyEventElement = this.getElementUtils().getTypeElement("android.view.KeyEvent");
        return ElementFilter.fieldsIn(keyEventElement.getEnclosedElements());
    }

    public boolean uniqueKeyCode(Element element, String targetAnnotationClass) {
        int[] elementsKeyCodes = this.extractKeyCode(element);
        if (elementsKeyCodes.length == 0) {
            return false;
        }
        HashSet<Integer> uniqueKeyCodes = new HashSet<Integer>(elementsKeyCodes.length);
        for (int n : elementsKeyCodes) {
            uniqueKeyCodes.add(n);
        }
        Element enclosingElement = element.getEnclosingElement();
        List<ExecutableElement> enclosedMethodElements = ElementFilter.methodsIn(enclosingElement.getEnclosedElements());
        for (Element element2 : enclosedMethodElements) {
            if (element2 == element) continue;
            List<? extends AnnotationMirror> annotationMirrors = element2.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                int[] keyCodes;
                if (!annotationMirror.getAnnotationType().asElement().toString().equals(targetAnnotationClass)) continue;
                for (int keyCode : keyCodes = this.extractKeyCode(element2)) {
                    if (uniqueKeyCodes.contains(keyCode)) {
                        return false;
                    }
                    uniqueKeyCodes.add(keyCode);
                }
            }
        }
        return true;
    }
}

