/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JVar;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.ElementValidation;
import org.androidannotations.handler.MethodInjectionHandler;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.helper.ValidatorHelper;
import org.androidannotations.holder.GeneratedClassHolder;

public class InjectHelper<T extends GeneratedClassHolder> {
    private final Map<ExecutableElement, List<ParamHelper>> methodParameterMap = new HashMap<ExecutableElement, List<ParamHelper>>();
    private final Map<ExecutableElement, JBlock> methodBlockMap = new HashMap<ExecutableElement, JBlock>();
    private final ValidatorHelper validatorHelper;
    private final MethodInjectionHandler<T> handler;
    private final APTCodeModelHelper codeModelHelper;

    public InjectHelper(ValidatorHelper validatorHelper, MethodInjectionHandler<T> handler) {
        this.codeModelHelper = new APTCodeModelHelper(validatorHelper.environment());
        this.validatorHelper = validatorHelper;
        this.handler = handler;
    }

    public void validate(Class<? extends Annotation> expectedAnnotation, Element element, ElementValidation valid) {
        Element enclosingElement = element.getEnclosingElement();
        if (element instanceof VariableElement && enclosingElement instanceof ExecutableElement) {
            this.validatorHelper.param.annotatedWith(expectedAnnotation).multiple().validate((ExecutableElement)enclosingElement, valid);
            this.validatorHelper.doesNotHaveAnyOfSupportedAnnotations(enclosingElement, valid);
            this.handler.validateEnclosingElement(enclosingElement, valid);
        } else if (element instanceof ExecutableElement) {
            this.handler.validateEnclosingElement(element, valid);
            this.validatorHelper.param.anyType().validate((ExecutableElement)element, valid);
            List<? extends VariableElement> parameters = ((ExecutableElement)element).getParameters();
            for (VariableElement variableElement : parameters) {
                this.validatorHelper.doesNotHaveAnyOfSupportedAnnotations(variableElement, valid);
            }
        } else {
            this.handler.validateEnclosingElement(element, valid);
            this.validatorHelper.isNotFinal(element, valid);
        }
    }

    public Element getParam(Element element) {
        if (element instanceof ExecutableElement) {
            return ((ExecutableElement)element).getParameters().get(0);
        }
        return element;
    }

    public void process(Element element, T holder) {
        if (element instanceof ExecutableElement) {
            this.processMethod(element, holder);
        } else {
            Element enclosingElement = element.getEnclosingElement();
            if (enclosingElement instanceof ExecutableElement) {
                this.processParam(element, holder);
            } else {
                this.processField(element, holder);
            }
        }
    }

    private void processParam(Element element, T holder) {
        ExecutableElement method = (ExecutableElement)element.getEnclosingElement();
        List<? extends VariableElement> parameters = method.getParameters();
        List<ParamHelper> parameterList = this.methodParameterMap.get(method);
        JBlock targetBlock = this.methodBlockMap.get(method);
        int paramCount = parameters.size();
        if (parameterList == null) {
            parameterList = new ArrayList<ParamHelper>();
            this.methodParameterMap.put(method, parameterList);
        }
        if (targetBlock == null) {
            targetBlock = this.createBlock(holder, true);
            this.methodBlockMap.put(method, targetBlock);
        }
        for (int paramIndex = 0; paramIndex < paramCount; ++paramIndex) {
            VariableElement param = parameters.get(paramIndex);
            if (!param.equals(element)) continue;
            AbstractJClass type = this.codeModelHelper.typeMirrorToJClass(param.asType());
            JVar fieldRef = targetBlock.decl((AbstractJType)type, param.getSimpleName().toString(), this.getDefault(param.asType()));
            this.handler.assignValue(targetBlock, (IJAssignmentTarget)fieldRef, holder, param, param);
            parameterList.add(new ParamHelper((IJExpression)fieldRef, paramIndex, param));
        }
        if (parameterList.size() == paramCount) {
            String methodName = method.getSimpleName().toString();
            Collections.sort(parameterList);
            JInvocation invocation = JExpr.invoke((String)methodName);
            for (ParamHelper parameter : parameterList) {
                invocation.arg(parameter.beanInstance);
            }
            targetBlock.add((IJStatement)invocation);
            if (this.handler instanceof MethodInjectionHandler.AfterAllParametersInjectedHandler) {
                ((MethodInjectionHandler.AfterAllParametersInjectedHandler)((Object)this.handler)).afterAllParametersInjected(holder, method, parameterList);
            }
            this.methodParameterMap.remove(method);
        }
    }

    private void processField(Element element, T holder) {
        String fieldName = element.getSimpleName().toString();
        JFieldRef fieldRef = JExpr._this().ref(fieldName);
        this.handler.assignValue(this.createBlock(holder, false), (IJAssignmentTarget)fieldRef, holder, element, element);
    }

    private void processMethod(Element element, T holder) {
        ExecutableElement executableElement = (ExecutableElement)element;
        VariableElement param = executableElement.getParameters().get(0);
        String methodName = executableElement.getSimpleName().toString();
        JBlock block = this.createBlock(holder, true);
        AbstractJClass type = this.codeModelHelper.typeMirrorToJClass(param.asType());
        JVar fieldRef = block.decl((AbstractJType)type, param.getSimpleName().toString(), this.getDefault(param.asType()));
        this.handler.assignValue(block, (IJAssignmentTarget)fieldRef, holder, element, param);
        block.add((IJStatement)JExpr.invoke((String)methodName).arg((IJExpression)fieldRef));
    }

    private IJExpression getDefault(TypeMirror typeMirror) {
        switch (typeMirror.toString()) {
            case "int": {
                return JExpr.lit((int)0);
            }
            case "float": {
                return JExpr.lit((float)0.0f);
            }
            case "double": {
                return JExpr.lit((double)0.0);
            }
            case "long": {
                return JExpr.lit((long)0L);
            }
            case "short": {
                return JExpr.lit((int)0);
            }
            case "char": {
                return JExpr.lit((char)'\u0000');
            }
            case "byte": {
                return JExpr.lit((int)0);
            }
            case "boolean": {
                return JExpr.lit((boolean)false);
            }
        }
        return JExpr._null();
    }

    private JBlock createBlock(T holder, boolean requiresBracers) {
        if (requiresBracers) {
            return this.handler.getInvocationBlock(holder).block();
        }
        return this.handler.getInvocationBlock(holder);
    }

    public static class ParamHelper
    implements Comparable<ParamHelper> {
        private final int argumentOrder;
        private final Element parameterElement;
        private final IJExpression beanInstance;

        ParamHelper(IJExpression beanInstance, int argumentOrder, Element parameterElement) {
            this.beanInstance = beanInstance;
            this.argumentOrder = argumentOrder;
            this.parameterElement = parameterElement;
        }

        public int getArgumentOrder() {
            return this.argumentOrder;
        }

        public Element getParameterElement() {
            return this.parameterElement;
        }

        public IJExpression getBeanInstance() {
            return this.beanInstance;
        }

        @Override
        public int compareTo(ParamHelper o) {
            return this.argumentOrder - o.argumentOrder;
        }
    }
}

