/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import org.androidannotations.ElementValidation;
import org.androidannotations.helper.IdAnnotationHelper;
import org.androidannotations.helper.ValidatorHelper;
import org.androidannotations.rclass.IRClass;

public class IdValidatorHelper
extends ValidatorHelper {
    private final IdAnnotationHelper idAnnotationHelper;

    public IdValidatorHelper(IdAnnotationHelper idAnnotationHelper) {
        super(idAnnotationHelper);
        this.idAnnotationHelper = idAnnotationHelper;
    }

    public void resIdsExist(Element element, IRClass.Res res, FallbackStrategy fallbackStrategy, ElementValidation valid) {
        block5: {
            int[] resIds;
            block2: {
                String[] resNames;
                block3: {
                    block4: {
                        String annotationName = this.idAnnotationHelper.getTarget();
                        resIds = this.idAnnotationHelper.extractAnnotationResIdValueParameter(element, annotationName);
                        if (!this.idAnnotationHelper.defaultResIdValue(resIds)) break block2;
                        resNames = this.idAnnotationHelper.extractAnnotationResNameParameter(element, annotationName);
                        if (!this.idAnnotationHelper.defaultResName(resNames)) break block3;
                        if (fallbackStrategy != FallbackStrategy.USE_ELEMENT_NAME) break block4;
                        String elementName = this.idAnnotationHelper.extractElementName(element, annotationName);
                        if (this.idAnnotationHelper.containsField(elementName, res)) break block5;
                        valid.addError("Resource name not found in R." + res.rName() + ": " + elementName);
                        break block5;
                    }
                    if (fallbackStrategy != FallbackStrategy.NEED_RES_ID) break block5;
                    valid.addError("%s needs an annotation value");
                    break block5;
                }
                for (String resName : resNames) {
                    if (this.idAnnotationHelper.containsField(resName, res)) continue;
                    valid.addError("Resource name not found in R." + res.rName() + ": " + resName);
                }
                break block5;
            }
            for (int resId : resIds) {
                if (this.idAnnotationHelper.containsIdValue(resId, res)) continue;
                valid.addError("Resource id value not found in R." + res.rName() + ": " + resId);
            }
        }
    }

    public void annotationParameterIsOptionalValidResId(Element element, IRClass.Res res, String parameterName, ElementValidation valid) {
        Integer resId = (Integer)this.annotationHelper.extractAnnotationParameter(element, parameterName);
        if (!resId.equals(-1) && !this.idAnnotationHelper.containsIdValue(resId, res)) {
            valid.addError("Id value not found in R." + res.rName() + ": " + resId);
        }
    }

    public void uniqueResourceId(Element element, IRClass.Res resourceType, ElementValidation valid) {
        if (valid.isValid()) {
            List<String> annotationQualifiedIds = this.idAnnotationHelper.extractAnnotationResources(element, resourceType, true);
            Element elementEnclosingElement = element.getEnclosingElement();
            Set<? extends Element> annotatedElements = this.validatedModel().getRootAnnotatedElements(this.annotationHelper.getTarget());
            for (Element element2 : annotatedElements) {
                Element uniqueCheckEnclosingElement = element2.getEnclosingElement();
                if (!elementEnclosingElement.equals(uniqueCheckEnclosingElement)) continue;
                List<String> checkQualifiedIds = this.idAnnotationHelper.extractAnnotationResources(element2, resourceType, true);
                for (String checkQualifiedId : checkQualifiedIds) {
                    for (String annotationQualifiedId : annotationQualifiedIds) {
                        if (!annotationQualifiedId.equals(checkQualifiedId)) continue;
                        String annotationSimpleId = annotationQualifiedId.substring(annotationQualifiedId.lastIndexOf(46) + 1);
                        valid.addError("The resource id " + annotationSimpleId + " is already used on the following " + this.annotationHelper.annotationName() + " method: " + element2);
                        return;
                    }
                }
            }
        }
    }

    public void uniqueId(Element element, ElementValidation valid) {
        this.uniqueResourceId(element, IRClass.Res.ID, valid);
    }

    public void annotationValuePositiveAndInAShort(int value, ElementValidation valid) {
        if (value < 0 || value > 65535) {
            valid.addError("Due to a restriction in the fragment API, the requestCode has to be a positive integer inferior or equal to 0xFFFF");
        }
    }

    public static enum FallbackStrategy {
        USE_ELEMENT_NAME,
        ALLOW_NO_RES_ID,
        NEED_RES_ID;

    }
}

