/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import com.helger.jcodemodel.JFieldRef;
import java.util.List;
import javax.lang.model.element.Element;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.helper.TargetAnnotationHelper;
import org.androidannotations.rclass.IRClass;
import org.androidannotations.rclass.IRInnerClass;

public class IdAnnotationHelper
extends TargetAnnotationHelper {
    public IdAnnotationHelper(AndroidAnnotationsEnvironment environment, String annotationName) {
        super(environment, annotationName);
    }

    private IRClass getRClass() {
        return this.getEnvironment().getRClass();
    }

    public boolean containsIdValue(Integer idValue, IRClass.Res res) {
        IRInnerClass rInnerClass = this.getRClass().get(res);
        return rInnerClass.containsIdValue(idValue);
    }

    public boolean containsField(String name, IRClass.Res res) {
        IRInnerClass rInnerClass = this.getRClass().get(res);
        return rInnerClass.containsField(name);
    }

    public List<String> extractAnnotationResources(Element element, IRClass.Res res, boolean useElementName) {
        return super.extractAnnotationResources(element, this.getTarget(), this.getRClass().get(res), useElementName);
    }

    public List<JFieldRef> extractAnnotationFieldRefs(Element element, IRClass.Res res, boolean useElementName) {
        return this.extractAnnotationFieldRefs(element, res, useElementName, "value", "resName");
    }

    public List<JFieldRef> extractAnnotationFieldRefs(Element element, IRClass.Res res, boolean useElementName, String idFieldName, String resFieldName) {
        return super.extractAnnotationFieldRefs(element, this.getTarget(), this.getRClass().get(res), useElementName, idFieldName, resFieldName);
    }

    public JFieldRef extractOneAnnotationFieldRef(Element element, IRClass.Res res, boolean useElementName) {
        return this.extractOneAnnotationFieldRef(element, this.getTarget(), res, useElementName);
    }

    public JFieldRef extractOneAnnotationFieldRef(Element element, String annotationName, IRClass.Res res, boolean useElementName) {
        return this.extractOneAnnotationFieldRef(element, annotationName, res, useElementName, "value", "resName");
    }

    public JFieldRef extractOneAnnotationFieldRef(Element element, String annotationName, IRClass.Res res, boolean useElementName, String idFieldName, String resFieldName) {
        return this.extractOneAnnotationFieldRef(element, annotationName, this.getRClass().get(res), useElementName, idFieldName, resFieldName);
    }

    public JFieldRef extractOneAnnotationFieldRef(Element element, String annotationName, IRInnerClass rInnerClass, boolean useElementName, String idFieldName, String resFieldName) {
        List<JFieldRef> jFieldRefs = this.extractAnnotationFieldRefs(element, annotationName, rInnerClass, useElementName, idFieldName, resFieldName);
        if (jFieldRefs.size() == 1) {
            return jFieldRefs.get(0);
        }
        return null;
    }
}

