/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAnnotatable;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JArrayClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.helper.AnnotationHelper;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.helper.ParcelerHelper;

public class BundleHelper {
    public static final Map<String, String> METHOD_SUFFIX_BY_TYPE_NAME = new HashMap<String, String>();
    private AndroidAnnotationsEnvironment environment;
    private AnnotationHelper annotationHelper;
    private APTCodeModelHelper codeModelHelper;
    private boolean restoreCallNeedCastStatement = false;
    private boolean restoreCallNeedsSuppressWarning = false;
    private boolean parcelerBean = false;
    private String methodNameToSave;
    private String methodNameToRestore;
    private TypeMirror upperBound;

    public BundleHelper(AndroidAnnotationsEnvironment environment, TypeMirror element) {
        this.environment = environment;
        this.annotationHelper = new AnnotationHelper(environment);
        this.codeModelHelper = new APTCodeModelHelper(environment);
        String typeString = element.toString();
        TypeMirror type = element;
        if (METHOD_SUFFIX_BY_TYPE_NAME.containsKey(typeString)) {
            this.methodNameToSave = "put" + METHOD_SUFFIX_BY_TYPE_NAME.get(typeString);
            this.methodNameToRestore = "get" + METHOD_SUFFIX_BY_TYPE_NAME.get(typeString);
        } else if (element.getKind() == TypeKind.ARRAY) {
            ArrayType arrayType = (ArrayType)element;
            boolean hasTypeArguments = false;
            if (arrayType.getComponentType() instanceof DeclaredType) {
                DeclaredType declaredType = (DeclaredType)arrayType.getComponentType();
                type = declaredType;
                hasTypeArguments = declaredType.getTypeArguments().size() > 0;
            } else if (arrayType.getComponentType().getKind() == TypeKind.TYPEVAR) {
                type = arrayType.getComponentType();
                this.upperBound = this.getUpperBound(type);
                this.restoreCallNeedCastStatement = true;
                this.restoreCallNeedsSuppressWarning = true;
            } else {
                type = arrayType.getComponentType();
            }
            if (this.isTypeParcelable(type)) {
                this.methodNameToSave = "putParcelableArray";
                this.methodNameToRestore = "getParcelableArray";
                if (hasTypeArguments) {
                    this.restoreCallNeedsSuppressWarning = true;
                }
            } else {
                this.methodNameToSave = "putSerializable";
                this.methodNameToRestore = "getSerializable";
                this.restoreCallNeedCastStatement = true;
            }
        } else if (typeString.startsWith(CanonicalNameConstants.ARRAYLIST)) {
            DeclaredType declaredType;
            List<? extends TypeMirror> typeArguments;
            boolean hasTypeArguments = false;
            if (element instanceof DeclaredType && (typeArguments = (declaredType = (DeclaredType)element).getTypeArguments()).size() == 1) {
                TypeMirror typeArgument = typeArguments.get(0);
                if (typeArgument instanceof DeclaredType) {
                    declaredType = (DeclaredType)typeArgument;
                    type = declaredType;
                    boolean bl = hasTypeArguments = declaredType.getTypeArguments().size() > 0;
                }
                if (this.isTypeParcelable(type)) {
                    this.methodNameToSave = "putParcelableArrayList";
                    this.methodNameToRestore = "getParcelableArrayList";
                    if (hasTypeArguments) {
                        this.restoreCallNeedsSuppressWarning = true;
                    }
                }
            }
            if (this.methodNameToSave == null) {
                this.methodNameToSave = "putSerializable";
                this.methodNameToRestore = "getSerializable";
                this.restoreCallNeedCastStatement = true;
                this.restoreCallNeedsSuppressWarning = true;
            }
        } else if (typeString.startsWith("android.util.SparseArray")) {
            this.methodNameToSave = "putSparseParcelableArray";
            this.methodNameToRestore = "getSparseParcelableArray";
        } else {
            boolean hasTypeArguments = element.getKind() == TypeKind.DECLARED && this.hasTypeArguments(element) || element.getKind() == TypeKind.TYPEVAR && this.hasTypeArguments(this.getUpperBound(element));
            ParcelerHelper parcelerHelper = new ParcelerHelper(environment);
            if (this.isTypeParcelable(type)) {
                this.methodNameToSave = "putParcelable";
                this.methodNameToRestore = "getParcelable";
            } else if (parcelerHelper.isParcelType(type)) {
                this.methodNameToSave = "putParcelable";
                this.methodNameToRestore = "getParcelable";
                this.parcelerBean = true;
            } else {
                this.methodNameToSave = "putSerializable";
                this.methodNameToRestore = "getSerializable";
                this.restoreCallNeedCastStatement = true;
                if (hasTypeArguments) {
                    this.restoreCallNeedsSuppressWarning = true;
                }
            }
        }
    }

    private boolean isTypeParcelable(TypeMirror typeMirror) {
        TypeMirror parcelableType = this.annotationHelper.typeElementFromQualifiedName("android.os.Parcelable").asType();
        return this.annotationHelper.isSubtype(typeMirror, parcelableType);
    }

    private TypeMirror getUpperBound(TypeMirror type) {
        TypeVariable typeVariable = (TypeVariable)type;
        return typeVariable.getUpperBound();
    }

    private boolean hasTypeArguments(TypeMirror type) {
        DeclaredType declaredType = (DeclaredType)type;
        return declaredType.getTypeArguments().size() > 0;
    }

    public IJExpression getExpressionToRestoreFromBundle(AbstractJClass variableClass, IJExpression bundle, IJExpression extraKey, JMethod method) {
        JInvocation expressionToRestore;
        if (this.methodNameToRestore.equals("getParcelableArray")) {
            JArrayClass erasure = this.upperBound != null ? this.codeModelHelper.typeMirrorToJClass(this.upperBound).erasure().array() : variableClass.elementType().erasure().array();
            expressionToRestore = this.environment.getJClass(org.androidannotations.api.bundle.BundleHelper.class).staticInvoke("getParcelableArray").arg(bundle).arg(extraKey).arg(erasure.dotclass());
        } else {
            expressionToRestore = JExpr.invoke((IJExpression)bundle, (String)this.methodNameToRestore).arg(extraKey);
        }
        if (this.parcelerBean) {
            expressionToRestore = this.environment.getJClass("org.parceler.Parcels").staticInvoke("unwrap").arg((IJExpression)expressionToRestore);
        }
        if (this.restoreCallNeedCastStatement) {
            expressionToRestore = JExpr.cast((AbstractJType)variableClass, (IJExpression)expressionToRestore);
            if (this.restoreCallNeedsSuppressWarning) {
                this.codeModelHelper.addSuppressWarnings((IJAnnotatable)method, "unchecked");
            }
        }
        return expressionToRestore;
    }

    public IJStatement getExpressionToSaveFromField(IJExpression saveStateBundleParam, IJExpression fieldName, IJExpression variableRef) {
        IJExpression refExpression = variableRef;
        if (this.parcelerBean) {
            refExpression = this.environment.getJClass("org.parceler.Parcels").staticInvoke("wrap").arg(refExpression);
        }
        return JExpr.invoke((IJExpression)saveStateBundleParam, (String)this.methodNameToSave).arg(fieldName).arg(refExpression);
    }

    static {
        METHOD_SUFFIX_BY_TYPE_NAME.put("android.os.Bundle", "Bundle");
        METHOD_SUFFIX_BY_TYPE_NAME.put("boolean", "Boolean");
        METHOD_SUFFIX_BY_TYPE_NAME.put("boolean[]", "BooleanArray");
        METHOD_SUFFIX_BY_TYPE_NAME.put("byte", "Byte");
        METHOD_SUFFIX_BY_TYPE_NAME.put("byte[]", "ByteArray");
        METHOD_SUFFIX_BY_TYPE_NAME.put("char", "Char");
        METHOD_SUFFIX_BY_TYPE_NAME.put("char[]", "CharArray");
        METHOD_SUFFIX_BY_TYPE_NAME.put(CanonicalNameConstants.CHAR_SEQUENCE, "CharSequence");
        METHOD_SUFFIX_BY_TYPE_NAME.put(CanonicalNameConstants.CHAR_SEQUENCE + "[]", "CharSequenceArray");
        METHOD_SUFFIX_BY_TYPE_NAME.put("java.util.ArrayList<" + CanonicalNameConstants.CHAR_SEQUENCE + ">", "CharSequenceArrayList");
        METHOD_SUFFIX_BY_TYPE_NAME.put("double", "Double");
        METHOD_SUFFIX_BY_TYPE_NAME.put("double[]", "DoubleArray");
        METHOD_SUFFIX_BY_TYPE_NAME.put("float", "Float");
        METHOD_SUFFIX_BY_TYPE_NAME.put("float[]", "FloatArray");
        METHOD_SUFFIX_BY_TYPE_NAME.put("int", "Int");
        METHOD_SUFFIX_BY_TYPE_NAME.put("int[]", "IntArray");
        METHOD_SUFFIX_BY_TYPE_NAME.put("java.util.ArrayList<java.lang.Integer>", "IntegerArrayList");
        METHOD_SUFFIX_BY_TYPE_NAME.put("long", "Long");
        METHOD_SUFFIX_BY_TYPE_NAME.put("long[]", "LongArray");
        METHOD_SUFFIX_BY_TYPE_NAME.put("short", "Short");
        METHOD_SUFFIX_BY_TYPE_NAME.put("short[]", "ShortArray");
        METHOD_SUFFIX_BY_TYPE_NAME.put(CanonicalNameConstants.STRING, "String");
        METHOD_SUFFIX_BY_TYPE_NAME.put("java.lang.String[]", "StringArray");
        METHOD_SUFFIX_BY_TYPE_NAME.put("java.util.ArrayList<java.lang.String>", "StringArrayList");
    }
}

