/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import com.helger.jcodemodel.JFieldRef;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.annotations.EditorAction;
import org.androidannotations.annotations.OnActivityResult;
import org.androidannotations.annotations.OptionsItem;
import org.androidannotations.annotations.SeekBarTouchStop;
import org.androidannotations.helper.ModelConstants;
import org.androidannotations.internal.rclass.RInnerClass;
import org.androidannotations.logger.Logger;
import org.androidannotations.logger.LoggerFactory;
import org.androidannotations.rclass.IRInnerClass;

public class AnnotationHelper {
    public static final String DEFAULT_FIELD_NAME_VALUE = "value";
    public static final String DEFAULT_FIELD_NAME_RESNAME = "resName";
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationHelper.class);
    private final AndroidAnnotationsEnvironment environment;

    public AnnotationHelper(AndroidAnnotationsEnvironment environment) {
        this.environment = environment;
    }

    public AndroidAnnotationsEnvironment getEnvironment() {
        return this.environment;
    }

    public ProcessingEnvironment getProcessingEnvironment() {
        return this.environment.getProcessingEnvironment();
    }

    public boolean isSubtype(TypeMirror potentialSubtype, TypeMirror potentialSupertype) {
        return this.getTypeUtils().isSubtype(potentialSubtype, potentialSupertype);
    }

    public boolean isSubtype(TypeElement t1, TypeElement t2) {
        return this.isSubtype(t1.asType(), t2.asType());
    }

    public List<? extends TypeMirror> directSupertypes(TypeMirror typeMirror) {
        return this.getTypeUtils().directSupertypes(typeMirror);
    }

    public TypeElement typeElementFromQualifiedName(String qualifiedName) {
        return this.getElementUtils().getTypeElement(qualifiedName);
    }

    public boolean isAnnotatedWith(Element element, String qualifiedName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(qualifiedName)) continue;
            return true;
        }
        return false;
    }

    public String generatedClassQualifiedNameFromQualifiedName(String qualifiedName) {
        TypeElement type = this.typeElementFromQualifiedName(qualifiedName);
        if (type.getNestingKind() == NestingKind.MEMBER) {
            String parentGeneratedClass = this.generatedClassQualifiedNameFromQualifiedName(type.getEnclosingElement().asType().toString());
            return parentGeneratedClass + "." + type.getSimpleName().toString() + ModelConstants.classSuffix();
        }
        return qualifiedName + ModelConstants.classSuffix();
    }

    public AnnotationMirror findAnnotationMirror(Element annotatedElement, String annotationName) {
        List<? extends AnnotationMirror> annotationMirrors = annotatedElement.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!this.isAnnotation(annotationElement, annotationName)) continue;
            return annotationMirror;
        }
        return null;
    }

    public boolean isAnnotation(TypeElement annotation, String annotationName) {
        return annotation.getQualifiedName().toString().equals(annotationName);
    }

    public boolean isPrivate(Element element) {
        return element.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    public boolean isPublic(Element element) {
        return element.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    public boolean isStatic(Element element) {
        return element.getModifiers().contains((Object)Modifier.STATIC);
    }

    public boolean isAbstract(Element element) {
        return element.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public boolean isInterface(TypeElement element) {
        return element.getKind().isInterface();
    }

    public boolean isTopLevel(TypeElement element) {
        return element.getNestingKind() == NestingKind.TOP_LEVEL;
    }

    public boolean isFinal(Element element) {
        return element.getModifiers().contains((Object)Modifier.FINAL);
    }

    public boolean isSynchronized(Element element) {
        return element.getModifiers().contains((Object)Modifier.SYNCHRONIZED);
    }

    public Elements getElementUtils() {
        return this.getProcessingEnvironment().getElementUtils();
    }

    public Types getTypeUtils() {
        return this.getProcessingEnvironment().getTypeUtils();
    }

    public List<JFieldRef> extractAnnotationFieldRefs(Element element, String annotationName, IRInnerClass rInnerClass, boolean useElementName) {
        return this.extractAnnotationFieldRefs(element, annotationName, rInnerClass, useElementName, DEFAULT_FIELD_NAME_VALUE, DEFAULT_FIELD_NAME_RESNAME);
    }

    public List<JFieldRef> extractAnnotationFieldRefs(Element element, String annotationName, IRInnerClass rInnerClass, boolean useElementName, String idFieldName, String resFieldName) {
        ArrayList<JFieldRef> fieldRefs = new ArrayList<JFieldRef>();
        for (String refQualifiedName : this.extractAnnotationResources(element, annotationName, rInnerClass, useElementName, idFieldName, resFieldName)) {
            fieldRefs.add(RInnerClass.extractIdStaticRef(this.environment, refQualifiedName));
        }
        return fieldRefs;
    }

    public List<String> extractAnnotationResources(Element element, String annotationName, IRInnerClass rInnerClass, boolean useElementName) {
        return this.extractAnnotationResources(element, annotationName, rInnerClass, useElementName, DEFAULT_FIELD_NAME_VALUE, DEFAULT_FIELD_NAME_RESNAME);
    }

    public List<String> extractAnnotationResources(Element element, String annotationName, IRInnerClass rInnerClass, boolean useElementName, String idFieldName, String resFieldName) {
        ArrayList<String> resourceIdQualifiedNames;
        block4: {
            int[] values;
            block2: {
                String[] resNames;
                block3: {
                    values = this.extractAnnotationResIdValueParameter(element, annotationName, idFieldName);
                    resourceIdQualifiedNames = new ArrayList<String>();
                    if (!this.defaultResIdValue(values)) break block2;
                    resNames = this.extractAnnotationResNameParameter(element, annotationName, resFieldName);
                    if (!this.defaultResName(resNames)) break block3;
                    if (!useElementName) break block4;
                    String elementName = this.extractElementName(element, annotationName);
                    String clickQualifiedId = rInnerClass.getIdQualifiedName(elementName);
                    resourceIdQualifiedNames.add(clickQualifiedId);
                    break block4;
                }
                for (String resName : resNames) {
                    String resourceIdQualifiedName = rInnerClass.getIdQualifiedName(resName);
                    resourceIdQualifiedNames.add(resourceIdQualifiedName);
                }
                break block4;
            }
            for (int value : values) {
                String resourceIdQualifiedName = rInnerClass.getIdQualifiedName(value);
                resourceIdQualifiedNames.add(resourceIdQualifiedName);
            }
        }
        return resourceIdQualifiedNames;
    }

    public String extractElementName(Element element, String annotationName) {
        String elementName = element.getSimpleName().toString();
        int lastIndex = elementName.lastIndexOf(this.actionName(annotationName));
        if (lastIndex != -1) {
            elementName = elementName.substring(0, lastIndex);
        }
        return elementName;
    }

    public boolean defaultResName(String[] resNames) {
        return resNames.length == 0 || resNames.length == 1 && "".equals(resNames[0]);
    }

    public boolean defaultResIdValue(int[] values) {
        return values.length == 0 || values.length == 1 && values[0] == -1;
    }

    public String[] extractAnnotationResNameParameter(Element element, String annotationName) {
        return this.extractAnnotationResNameParameter(element, annotationName, DEFAULT_FIELD_NAME_RESNAME);
    }

    public String[] extractAnnotationResNameParameter(Element element, String annotationName, String fieldName) {
        Object annotationResName = this.extractAnnotationParameter(element, annotationName, fieldName);
        if (annotationResName == null) {
            return new String[0];
        }
        String[] resNames = annotationResName.getClass().isArray() ? (String[])annotationResName : new String[]{(String)annotationResName};
        return resNames;
    }

    public int[] extractAnnotationResIdValueParameter(Element element, String annotationName) {
        return this.extractAnnotationResIdValueParameter(element, annotationName, DEFAULT_FIELD_NAME_VALUE);
    }

    public int[] extractAnnotationResIdValueParameter(Element element, String annotationName, String fieldName) {
        Object annotationValue = this.extractAnnotationParameter(element, annotationName, fieldName);
        if (annotationValue == null) {
            return new int[0];
        }
        int[] values = annotationValue.getClass().isArray() ? (int[])annotationValue : new int[]{(Integer)annotationValue};
        return values;
    }

    public <T> T extractAnnotationParameter(Element element, String annotationName, String methodName) {
        Object annotation;
        try {
            annotation = element.getAnnotation(Class.forName(annotationName));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load annotation class " + annotationName, e);
        }
        try {
            Method method = annotation.getClass().getMethod(methodName, new Class[0]);
            return (T)method.invoke(annotation, new Object[0]);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof MirroredTypeException) {
                MirroredTypeException cause = (MirroredTypeException)e.getCause();
                return (T)cause.getTypeMirror();
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String actionName(String annotationName) {
        if (OptionsItem.class.getName().equals(annotationName)) {
            return "Selected";
        }
        if (OnActivityResult.class.getName().equals(annotationName)) {
            return "Result";
        }
        if (SeekBarTouchStop.class.getName().equals(annotationName)) {
            return "SeekBarTouchStopped";
        }
        if (EditorAction.class.getName().equals(annotationName)) {
            return EditorAction.class.getSimpleName();
        }
        String annotationSimpleName = annotationName.substring(annotationName.lastIndexOf(46) + 1);
        if (annotationSimpleName.endsWith("e")) {
            return annotationSimpleName + "d";
        }
        return annotationSimpleName + "ed";
    }

    public List<DeclaredType> extractAnnotationClassArrayParameter(Element element, Class<? extends Annotation> annotation, String methodName) {
        return this.extractAnnotationClassArrayParameter(element, annotation.getName(), methodName);
    }

    public List<DeclaredType> extractAnnotationClassArrayParameter(Element element, String annotationName, String methodName) {
        AnnotationMirror annotationMirror = this.findAnnotationMirror(element, annotationName);
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
            if (!methodName.equals(entry.getKey().getSimpleName().toString())) continue;
            AnnotationValue annotationValue = entry.getValue();
            List annotationClassArray = (List)annotationValue.getValue();
            ArrayList<DeclaredType> result = new ArrayList<DeclaredType>(annotationClassArray.size());
            for (AnnotationValue annotationClassValue : annotationClassArray) {
                result.add((DeclaredType)annotationClassValue.getValue());
            }
            return result;
        }
        return null;
    }

    public DeclaredType extractAnnotationClassParameter(Element element, Class<? extends Annotation> annotation, String methodName) {
        return this.extractAnnotationClassParameter(element, annotation.getName(), methodName);
    }

    public DeclaredType extractAnnotationClassParameter(Element element, String annotationName, String methodName) {
        AnnotationMirror annotationMirror = this.findAnnotationMirror(element, annotationName);
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
            if (!methodName.equals(entry.getKey().getSimpleName().toString())) continue;
            AnnotationValue annotationValue = entry.getValue();
            return (DeclaredType)annotationValue.getValue();
        }
        return null;
    }

    public DeclaredType extractAnnotationClassParameter(Element element, String annotationName) {
        return this.extractAnnotationClassParameter(element, annotationName, DEFAULT_FIELD_NAME_VALUE);
    }

    public boolean hasOneOfClassAnnotations(Element element, Class<? extends Annotation> validAnnotation) {
        ArrayList<Class<? extends Annotation>> annotations = new ArrayList<Class<? extends Annotation>>();
        annotations.add(validAnnotation);
        return this.hasOneOfClassAnnotations(element, annotations);
    }

    public boolean enclosingElementHasEnhancedComponentAnnotation(Element element) {
        Element enclosingElement = element.getEnclosingElement();
        return this.hasOneOfClassAnnotations(enclosingElement, ModelConstants.VALID_ENHANCED_COMPONENT_ANNOTATIONS);
    }

    public boolean hasOneOfClassAnnotations(Element element, List<Class<? extends Annotation>> validAnnotations) {
        for (Class<? extends Annotation> validAnnotation : validAnnotations) {
            if (element.getAnnotation(validAnnotation) == null) continue;
            return true;
        }
        return false;
    }
}

