/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import com.helger.jcodemodel.AbstractJAnnotationValue;
import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAnnotatable;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJGenerable;
import com.helger.jcodemodel.IJGenerifiable;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JAnnotationArrayMember;
import com.helger.jcodemodel.JAnnotationUse;
import com.helger.jcodemodel.JAnonymousClass;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JPrimitiveType;
import com.helger.jcodemodel.JTypeVar;
import com.helger.jcodemodel.JVar;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.annotations.EBean;
import org.androidannotations.helper.ModelConstants;
import org.androidannotations.holder.EBeanHolder;
import org.androidannotations.holder.GeneratedClassHolder;
import org.androidannotations.internal.helper.AnnotationParamExtractor;

public class APTCodeModelHelper {
    private static final List<String> IGNORED_ANNOTATIONS = Collections.singletonList("kotlin.Metadata");
    private AndroidAnnotationsEnvironment environment;

    public APTCodeModelHelper(AndroidAnnotationsEnvironment environment) {
        this.environment = environment;
    }

    public AbstractJClass typeMirrorToJClass(TypeMirror type) {
        return this.typeMirrorToJClass(type, Collections.emptyMap());
    }

    private AbstractJClass typeMirrorToJClass(TypeMirror type, Map<String, TypeMirror> substitute) {
        if (type instanceof DeclaredType) {
            return this.typeMirrorToJClass((DeclaredType)type, substitute);
        }
        if (type instanceof WildcardType) {
            return this.typeMirrorToJClass((WildcardType)type, substitute);
        }
        if (type instanceof ArrayType) {
            return this.typeMirrorToJClass((ArrayType)type, substitute);
        }
        TypeMirror substituted = substitute.get(type.toString());
        if (substituted != null && type != substituted) {
            return this.typeMirrorToJClass(substituted, substitute);
        }
        return this.environment.getJClass(type.toString());
    }

    private AbstractJClass typeMirrorToJClass(DeclaredType declaredType, Map<String, TypeMirror> substitute) {
        String declaredTypeName = declaredType.asElement().toString();
        AbstractJClass declaredClass = this.environment.getJClass(declaredTypeName);
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        ArrayList<AbstractJClass> typeArgumentJClasses = new ArrayList<AbstractJClass>();
        for (TypeMirror typeMirror : typeArguments) {
            typeArgumentJClasses.add(this.typeMirrorToJClass(typeMirror, substitute));
        }
        if (typeArgumentJClasses.size() > 0) {
            declaredClass = declaredClass.narrow(typeArgumentJClasses);
        }
        return declaredClass;
    }

    private AbstractJClass typeMirrorToJClass(WildcardType wildcardType, Map<String, TypeMirror> substitute) {
        TypeMirror bound = wildcardType.getExtendsBound();
        if (bound == null) {
            bound = wildcardType.getSuperBound();
            if (bound == null) {
                return this.environment.getClasses().OBJECT.wildcardExtends();
            }
            return this.typeMirrorToJClass(bound, substitute).wildcardSuper();
        }
        TypeMirror extendsBound = wildcardType.getExtendsBound();
        if (extendsBound == null) {
            return this.environment.getClasses().OBJECT.wildcardExtends();
        }
        return this.typeMirrorToJClass(extendsBound, substitute).wildcardExtends();
    }

    private AbstractJClass typeMirrorToJClass(ArrayType arrayType, Map<String, TypeMirror> substitute) {
        AbstractJClass refClass = this.typeMirrorToJClass(arrayType.getComponentType(), substitute);
        return refClass.array();
    }

    private Map<String, TypeMirror> getActualTypes(Types typeUtils, DeclaredType baseClass, TypeMirror annotatedClass) {
        ArrayList<? extends TypeMirror> superTypes = new ArrayList<TypeMirror>();
        superTypes.add(annotatedClass);
        while (!superTypes.isEmpty()) {
            TypeMirror x = (TypeMirror)superTypes.remove(0);
            if (typeUtils.isSameType(typeUtils.erasure(x), typeUtils.erasure(baseClass))) {
                DeclaredType type = (DeclaredType)x;
                HashMap<String, TypeMirror> actualTypes = new HashMap<String, TypeMirror>();
                for (int i = 0; i < type.getTypeArguments().size(); ++i) {
                    TypeMirror formalArg;
                    TypeMirror actualArg = type.getTypeArguments().get(i);
                    if (typeUtils.isSameType(actualArg, formalArg = baseClass.getTypeArguments().get(i))) continue;
                    actualTypes.put(formalArg.toString(), actualArg);
                }
                return actualTypes;
            }
            superTypes.addAll(typeUtils.directSupertypes(x));
        }
        return Collections.emptyMap();
    }

    public List<AbstractJClass> typeBoundsToJClass(List<? extends TypeMirror> bounds) {
        return this.typeBoundsToJClass(bounds, Collections.emptyMap());
    }

    private List<AbstractJClass> typeBoundsToJClass(List<? extends TypeMirror> bounds, Map<String, TypeMirror> actualTypes) {
        if (bounds.isEmpty()) {
            return Collections.singletonList(this.environment.getClasses().OBJECT);
        }
        ArrayList<AbstractJClass> jClassBounds = new ArrayList<AbstractJClass>();
        for (TypeMirror typeMirror : bounds) {
            jClassBounds.add(this.typeMirrorToJClass(typeMirror, actualTypes));
        }
        return jClassBounds;
    }

    private void addTypeBounds(IJGenerifiable generifiable, List<AbstractJClass> bounds, String name) {
        JTypeVar typeVar = null;
        for (AbstractJClass bound : bounds) {
            if (typeVar == null) {
                typeVar = generifiable.generify(name, bound);
                continue;
            }
            typeVar.bound(bound);
        }
    }

    public JMethod overrideAnnotatedMethod(ExecutableElement executableElement, GeneratedClassHolder holder) {
        TypeMirror annotatedClass = holder.getAnnotatedElement().asType();
        DeclaredType baseClass = (DeclaredType)executableElement.getEnclosingElement().asType();
        Types typeUtils = this.environment.getProcessingEnvironment().getTypeUtils();
        Map<String, TypeMirror> actualTypes = this.getActualTypes(typeUtils, baseClass, annotatedClass);
        LinkedHashMap<String, List<AbstractJClass>> methodTypes = new LinkedHashMap<String, List<AbstractJClass>>();
        for (TypeParameterElement typeParameterElement : executableElement.getTypeParameters()) {
            List<? extends TypeMirror> bounds = typeParameterElement.getBounds();
            List<AbstractJClass> addedBounds = this.typeBoundsToJClass(bounds, actualTypes);
            methodTypes.put(typeParameterElement.toString(), addedBounds);
        }
        actualTypes.keySet().removeAll(methodTypes.keySet());
        JMethod existingMethod = this.findAlreadyGeneratedMethod(executableElement, holder);
        if (existingMethod != null) {
            return existingMethod;
        }
        String string = executableElement.getSimpleName().toString();
        AbstractJClass returnType = this.typeMirrorToJClass(executableElement.getReturnType(), actualTypes);
        int modifier = this.elementVisibilityModifierToJMod(executableElement);
        JMethod method = holder.getGeneratedClass().method(modifier, (AbstractJType)returnType, string);
        this.copyNonAAAnnotations((IJAnnotatable)method, executableElement.getAnnotationMirrors());
        if (!this.hasAnnotation((IJAnnotatable)method, Override.class)) {
            method.annotate(Override.class);
        }
        for (Map.Entry typeDeclaration : methodTypes.entrySet()) {
            List list = (List)typeDeclaration.getValue();
            this.addTypeBounds((IJGenerifiable)method, list, (String)typeDeclaration.getKey());
        }
        int i = 0;
        for (VariableElement variableElement : executableElement.getParameters()) {
            boolean varParam = i == executableElement.getParameters().size() - 1 && executableElement.isVarArgs();
            this.addParamToMethod(method, variableElement, 8, actualTypes, varParam);
            ++i;
        }
        for (TypeMirror typeMirror : executableElement.getThrownTypes()) {
            AbstractJClass thrownType = this.typeMirrorToJClass(typeMirror, actualTypes);
            method._throws(thrownType);
        }
        this.callSuperMethod(method, holder, method.body());
        return method;
    }

    public int elementVisibilityModifierToJMod(Element element) {
        Set<Modifier> modifiers = element.getModifiers();
        if (modifiers.contains((Object)Modifier.PUBLIC)) {
            return 1;
        }
        if (modifiers.contains((Object)Modifier.PROTECTED)) {
            return 2;
        }
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            return 4;
        }
        return 0;
    }

    public void generify(IJGenerifiable generifiable, TypeElement fromTypeParameters) {
        for (TypeParameterElement typeParameterElement : fromTypeParameters.getTypeParameters()) {
            List<AbstractJClass> bounds = this.typeBoundsToJClass(typeParameterElement.getBounds());
            this.addTypeBounds(generifiable, bounds, typeParameterElement.getSimpleName().toString());
        }
    }

    public AbstractJClass narrowGeneratedClass(AbstractJClass generatedClass, TypeMirror fromTypeArguments) {
        DeclaredType type = (DeclaredType)fromTypeArguments;
        for (TypeMirror typeMirror : type.getTypeArguments()) {
            AbstractJClass paramClass = this.typeMirrorToJClass(typeMirror);
            generatedClass = generatedClass.narrow(paramClass);
        }
        return generatedClass;
    }

    private JMethod findAlreadyGeneratedMethod(ExecutableElement executableElement, GeneratedClassHolder holder) {
        JDefinedClass definedClass = holder.getGeneratedClass();
        String methodName = executableElement.getSimpleName().toString();
        List<? extends VariableElement> parameters = executableElement.getParameters();
        block0: for (JMethod method : definedClass.methods()) {
            if (!method.name().equals(methodName) || method.params().size() != parameters.size()) continue;
            int i = 0;
            for (JVar param : method.params()) {
                String searchedParamType = this.typeMirrorToJClass(parameters.get(i).asType()).fullName();
                if (!param.type().fullName().equals(searchedParamType)) continue block0;
                ++i;
            }
            return method;
        }
        return null;
    }

    private void addParamToMethod(JMethod method, VariableElement parameter, int mod, Map<String, TypeMirror> actualTypes, boolean varParam) {
        String parameterName = parameter.getSimpleName().toString();
        AbstractJClass parameterClass = this.typeMirrorToJClass(parameter.asType(), actualTypes);
        JVar param = varParam ? method.varParam(mod, parameterClass.elementType(), parameterName) : method.param(mod, (AbstractJType)parameterClass, parameterName);
        this.copyNonAAAnnotations((IJAnnotatable)param, parameter.getAnnotationMirrors());
    }

    public void copyNonAAAnnotations(IJAnnotatable annotatable, List<? extends AnnotationMirror> annotationMirrors) {
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            AbstractJClass annotationClass;
            if (annotationMirror.getAnnotationType().asElement().getAnnotation(Inherited.class) != null || this.environment.isAndroidAnnotation((annotationClass = this.typeMirrorToJClass(annotationMirror.getAnnotationType())).fullName()) || IGNORED_ANNOTATIONS.contains(annotationClass.fullName())) continue;
            this.copyAnnotation(annotatable, annotationMirror);
        }
    }

    public void copyAnnotation(IJAnnotatable annotatable, AnnotationMirror annotationMirror) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> parameters = annotationMirror.getElementValues();
        if (!this.hasAnnotation(annotatable, annotationMirror) || annotatable instanceof JAnnotationArrayMember) {
            AbstractJClass annotation = this.typeMirrorToJClass(annotationMirror.getAnnotationType());
            JAnnotationUse annotate = annotatable.annotate(annotation);
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> param : parameters.entrySet()) {
                param.getValue().accept(new AnnotationParamExtractor(annotate, this), param.getKey().getSimpleName().toString());
            }
        }
    }

    private boolean hasAnnotation(IJAnnotatable annotatable, AnnotationMirror annotationMirror) {
        return this.hasAnnotation(annotatable, annotationMirror.getAnnotationType().toString());
    }

    public boolean hasAnnotation(IJAnnotatable annotatable, Class<? extends Annotation> annotationClass) {
        return this.hasAnnotation(annotatable, annotationClass.getCanonicalName());
    }

    private boolean hasAnnotation(IJAnnotatable annotatable, String annotationFQN) {
        for (JAnnotationUse annotation : annotatable.annotations()) {
            if (!annotation.getAnnotationClass().fullName().equals(annotationFQN)) continue;
            return true;
        }
        return false;
    }

    public JInvocation getSuperCall(GeneratedClassHolder holder, JMethod superMethod) {
        JFieldRef activitySuper = holder.getGeneratedClass().staticRef("super");
        JInvocation superCall = JExpr.invoke((IJExpression)activitySuper, (JMethod)superMethod);
        for (JVar param : superMethod.params()) {
            superCall.arg((IJExpression)param);
        }
        if (superMethod.hasVarArgs()) {
            superCall.arg((IJExpression)superMethod.varParam());
        }
        return superCall;
    }

    public void callSuperMethod(JMethod superMethod, GeneratedClassHolder holder, JBlock callBlock) {
        JInvocation superCall = this.getSuperCall(holder, superMethod);
        AbstractJType returnType = superMethod.type();
        if (returnType.fullName().equals("void")) {
            callBlock.add((IJStatement)superCall);
        } else {
            callBlock._return((IJExpression)superCall);
        }
    }

    public JBlock removeBody(JMethod method) {
        JBlock body = method.body();
        try {
            Field bodyField = JMethod.class.getDeclaredField("m_aBody");
            bodyField.setAccessible(true);
            bodyField.set(method, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        JBlock clonedBody = new JBlock().bracesRequired(false).indentRequired(false);
        this.copy(body, clonedBody);
        return clonedBody;
    }

    public void copy(JBlock body, JBlock newBody) {
        for (Object statement : body.getContents()) {
            if (statement instanceof JVar) {
                JVar var = (JVar)statement;
                try {
                    Field varInitField = JVar.class.getDeclaredField("m_aInitExpr");
                    varInitField.setAccessible(true);
                    IJExpression varInit = (IJExpression)varInitField.get(var);
                    newBody.decl(var.type(), var.name(), varInit);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            newBody.add((IJStatement)statement);
        }
    }

    public void replaceSuperCall(JMethod method, JBlock replacement) {
        String superCallStart = "super." + method.name() + "(";
        JBlock oldBody = this.removeBody(method);
        JBlock newBody = method.body();
        for (Object content : oldBody.getContents()) {
            StringWriter writer = new StringWriter();
            JFormatter formatter = new JFormatter((Writer)writer);
            IJStatement statement = (IJStatement)content;
            statement.state(formatter);
            String statementString = writer.getBuffer().toString();
            if (statementString.startsWith(superCallStart)) {
                newBody.add((IJStatement)replacement);
                continue;
            }
            newBody.add(statement);
        }
    }

    public JDefinedClass createDelegatingAnonymousRunnableClass(JBlock previousBody) {
        JCodeModel codeModel = this.environment.getCodeModel();
        JAnonymousClass anonymousRunnableClass = codeModel.anonymousClass(Runnable.class);
        JMethod runMethod = anonymousRunnableClass.method(1, (AbstractJType)codeModel.VOID, "run");
        runMethod.annotate(Override.class);
        runMethod.body().add((IJStatement)previousBody);
        return anonymousRunnableClass;
    }

    public List<ExecutableElement> getMethods(TypeElement typeElement) {
        List<? extends Element> enclosedElements = typeElement.getEnclosedElements();
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>(ElementFilter.methodsIn(enclosedElements));
        for (TypeMirror typeMirror : typeElement.getInterfaces()) {
            DeclaredType dt = (DeclaredType)typeMirror;
            methods.addAll(ElementFilter.methodsIn(dt.asElement().getEnclosedElements()));
        }
        return methods;
    }

    public JMethod implementMethod(GeneratedClassHolder holder, List<ExecutableElement> methods, String methodName, String returnType, String ... parameterTypes) {
        return this.implementMethod(holder, methods, methodName, returnType, false, parameterTypes);
    }

    public JMethod implementMethod(GeneratedClassHolder holder, List<ExecutableElement> methods, String methodName, String returnType, boolean finalParams, String ... parameterTypes) {
        ExecutableElement method = this.getMethod(methods, methodName, returnType, parameterTypes);
        JMethod jmethod = null;
        if (method != null) {
            JPrimitiveType jcReturnType = returnType.equals(TypeKind.VOID.toString()) ? this.environment.getCodeModel().VOID : this.environment.getJClass(returnType);
            jmethod = holder.getGeneratedClass().method(1, (AbstractJType)jcReturnType, method.getSimpleName().toString());
            jmethod.annotate(Override.class);
            int paramMods = finalParams ? 8 : 0;
            for (int i = 0; i < method.getParameters().size(); ++i) {
                VariableElement param = method.getParameters().get(i);
                jmethod.param(paramMods, (AbstractJType)this.environment.getJClass(parameterTypes[i]), param.getSimpleName().toString());
            }
        }
        return jmethod;
    }

    private ExecutableElement getMethod(List<ExecutableElement> methods, String methodName, String returnType, String ... parameterTypes) {
        for (ExecutableElement method : methods) {
            String methodReturnType;
            List<? extends VariableElement> parameters = method.getParameters();
            String string = methodReturnType = method.getReturnType().getKind() == TypeKind.VOID ? TypeKind.VOID.toString() : method.getReturnType().toString();
            if (parameters.size() != parameterTypes.length || !methodReturnType.equals(returnType) || methodName != null && !method.getSimpleName().toString().equals(methodName)) continue;
            boolean validMethod = true;
            for (int i = 0; i < parameters.size(); ++i) {
                VariableElement param = parameters.get(i);
                if (param.asType().toString().equals(parameterTypes[i])) continue;
                validMethod = false;
                break;
            }
            if (!validMethod) continue;
            return method;
        }
        return null;
    }

    public JInvocation newBeanOrEBean(DeclaredType beanType, JVar contextVar) {
        if (beanType.asElement().getAnnotation(EBean.class) != null) {
            String typeQualifiedName = beanType.toString();
            AbstractJClass injectedClass = this.environment.getJClass(typeQualifiedName + ModelConstants.classSuffix());
            return injectedClass.staticInvoke(EBeanHolder.GET_INSTANCE_METHOD_NAME).arg((IJExpression)contextVar);
        }
        return JExpr._new((AbstractJClass)this.environment.getJClass(beanType.toString()));
    }

    public IJExpression litObject(Object o) {
        if (o instanceof Integer) {
            return JExpr.lit((int)((Integer)o));
        }
        if (o instanceof Float) {
            return JExpr.lit((float)((Float)o).floatValue());
        }
        if (o instanceof Long) {
            return JExpr.lit((long)((Long)o));
        }
        if (o instanceof Boolean) {
            return JExpr.lit((boolean)((Boolean)o));
        }
        return JExpr.lit((String)((String)o));
    }

    public TypeMirror getActualType(Element element, GeneratedClassHolder holder) {
        DeclaredType enclosingClassType = (DeclaredType)element.getEnclosingElement().asType();
        return this.getActualType(element, enclosingClassType, holder);
    }

    public TypeMirror getActualType(Element element, DeclaredType enclosingClassType, GeneratedClassHolder holder) {
        TypeMirror annotatedClass;
        Types types = this.environment.getProcessingEnvironment().getTypeUtils();
        Map<String, TypeMirror> actualTypes = this.getActualTypes(types, enclosingClassType, annotatedClass = holder.getAnnotatedElement().asType());
        TypeMirror type = actualTypes.get(element.asType().toString());
        return type == null ? element.asType() : type;
    }

    public TypeMirror getActualTypeOfEnclosingElementOfInjectedElement(GeneratedClassHolder holder, Element param) {
        DeclaredType enclosingClassType = param.getKind() == ElementKind.PARAMETER ? (DeclaredType)param.getEnclosingElement().getEnclosingElement().asType() : (DeclaredType)param.getEnclosingElement().asType();
        return this.getActualType(param, enclosingClassType, holder);
    }

    public void addSuppressWarnings(IJAnnotatable generatedElement, String annotationValue) {
        Collection annotations = generatedElement.annotations();
        for (JAnnotationUse annotationUse : annotations) {
            if (!SuppressWarnings.class.getCanonicalName().equals(annotationUse.getAnnotationClass().fullName())) continue;
            AbstractJAnnotationValue value = annotationUse.getParam("value");
            StringWriter code = new StringWriter();
            JFormatter formatter = new JFormatter((Writer)code);
            formatter.generable((IJGenerable)value);
            if (!code.toString().contains(annotationValue)) {
                if (value instanceof JAnnotationArrayMember) {
                    ((JAnnotationArrayMember)value).param(annotationValue);
                } else {
                    String foundValue = code.toString().substring(1, code.toString().length() - 1);
                    JAnnotationArrayMember newParamArray = annotationUse.paramArray("value");
                    newParamArray.param(foundValue).param(annotationValue);
                }
            }
            return;
        }
        generatedElement.annotate(SuppressWarnings.class).param("value", annotationValue);
    }

    public void addTrimmedDocComment(JMethod method, String docComment) {
        if (docComment != null) {
            method.javadoc().append((Object)docComment.replaceAll("\r", "").trim());
        }
    }
}

