/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.JCodeModel;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.handler.AnnotationHandler;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.helper.IdAnnotationHelper;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.GeneratedClassHolder;
import org.androidannotations.internal.process.ProcessHolder;

public abstract class BaseAnnotationHandler<T extends GeneratedClassHolder>
implements AnnotationHandler<T> {
    private final String target;
    protected IdAnnotationHelper annotationHelper;
    protected IdValidatorHelper validatorHelper;
    protected APTCodeModelHelper codeModelHelper;
    private AndroidAnnotationsEnvironment environment;

    public BaseAnnotationHandler(Class<?> targetClass, AndroidAnnotationsEnvironment environment) {
        this(targetClass.getCanonicalName(), environment);
    }

    public BaseAnnotationHandler(String target, AndroidAnnotationsEnvironment environment) {
        this.target = target;
        this.environment = environment;
        this.annotationHelper = new IdAnnotationHelper(environment, target);
        this.validatorHelper = new IdValidatorHelper(this.annotationHelper);
        this.codeModelHelper = new APTCodeModelHelper(environment);
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    @Override
    public ElementValidation validate(Element element) {
        ElementValidation validation = new ElementValidation(this.target, element);
        this.validate(element, validation);
        return validation;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    protected abstract void validate(Element var1, ElementValidation var2);

    protected AndroidAnnotationsEnvironment getEnvironment() {
        return this.environment;
    }

    protected ProcessingEnvironment getProcessingEnvironment() {
        return this.environment.getProcessingEnvironment();
    }

    protected ProcessHolder.Classes getClasses() {
        return this.environment.getClasses();
    }

    protected JCodeModel getCodeModel() {
        return this.environment.getCodeModel();
    }

    protected AbstractJClass getJClass(String fullyQualifiedClassName) {
        return this.environment.getJClass(fullyQualifiedClassName);
    }

    protected AbstractJClass getJClass(Class<?> clazz) {
        return this.environment.getJClass(clazz);
    }

    protected boolean hasTargetMethod(TypeElement type, String methodName) {
        if (type == null) {
            return false;
        }
        List<? extends Element> allMembers = this.getProcessingEnvironment().getElementUtils().getAllMembers(type);
        for (ExecutableElement element : ElementFilter.methodsIn(allMembers)) {
            if (!element.getSimpleName().contentEquals(methodName)) continue;
            return true;
        }
        return false;
    }
}

