/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

public class ElementValidation {
    private String annotationName;
    private Element element;
    private boolean isValid = true;
    private List<Error> errors = new ArrayList<Error>();
    private List<String> warnings = new ArrayList<String>();

    public ElementValidation(String annotationName, Element element) {
        this.annotationName = annotationName;
        this.element = element;
    }

    public Element getElement() {
        return this.element;
    }

    public void invalidate() {
        this.isValid = false;
    }

    public void addError(String error) {
        this.addError(this.element, error);
    }

    public void addError(Element element, String error) {
        this.isValid = false;
        this.errors.add(new Error(element, String.format(error, this.annotationName)));
    }

    public boolean isValid() {
        return this.isValid;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public void addWarning(String error) {
        this.warnings.add(String.format(error, this.annotationName));
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public String getAnnotationName() {
        return this.annotationName;
    }

    public AnnotationMirror getAnnotationMirror() {
        List<? extends AnnotationMirror> annotationMirrors = this.element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!annotationElement.getQualifiedName().toString().equals(this.annotationName)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static class Error {
        private Element element;
        private String message;

        public Error(Element element, String message) {
            this.element = element;
            this.message = message;
        }

        public Element getElement() {
            return this.element;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

