/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.logger;

import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;

public final class StackTraceLogger {
    private static final Configuration CONFIG = ConfigurationFactory.getInstance();
    private static final String STACK_TRACE_LOGGER_PREFIX = "[stacktrace]";

    public static void info(Logger logger, Throwable cause, String format, Object[] args) {
        if (logger.isInfoEnabled()) {
            int rate = StackTraceLogger.getRate();
            if (ThreadLocalRandom.current().nextInt(rate) == 0) {
                logger.info(STACK_TRACE_LOGGER_PREFIX + format, (Object)args, (Object)cause);
            } else {
                logger.info(format, args);
            }
        }
    }

    public static void warn(Logger logger, Throwable cause, String format, Object[] args) {
        if (logger.isWarnEnabled()) {
            int rate = StackTraceLogger.getRate();
            if (ThreadLocalRandom.current().nextInt(rate) == 0) {
                logger.warn(STACK_TRACE_LOGGER_PREFIX + format, (Object)args, (Object)cause);
            } else {
                logger.warn(format, args);
            }
        }
    }

    public static void error(Logger logger, Throwable cause, String format, Object[] args) {
        if (logger.isErrorEnabled()) {
            int rate = StackTraceLogger.getRate();
            if (ThreadLocalRandom.current().nextInt(rate) == 0) {
                logger.error(STACK_TRACE_LOGGER_PREFIX + format, (Object)args, (Object)cause);
            } else {
                logger.error(format, args);
            }
        }
    }

    private static int getRate() {
        return CONFIG.getInt("client.log.exceptionRate", 100);
    }
}

