/*
 * Decompiled with CFR 0.152.
 */
package io.minio.messages;

import io.minio.messages.Metadata;
import io.minio.messages.Owner;
import io.minio.messages.ResponseDate;
import java.time.ZonedDateTime;
import java.util.Map;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="Contents", strict=false)
public class Item {
    @Element(name="Key")
    private String objectName;
    @Element(name="LastModified")
    private ResponseDate lastModified;
    @Element(name="ETag")
    private String etag;
    @Element(name="Size")
    private long size;
    @Element(name="StorageClass")
    private String storageClass;
    @Element(name="Owner")
    private Owner owner;
    @Element(name="UserMetadata", required=false)
    private Metadata userMetadata;
    private boolean isDir = false;

    public Item() {
    }

    public Item(String prefix) {
        this.objectName = prefix;
        this.isDir = true;
    }

    public String objectName() {
        return this.objectName;
    }

    public ZonedDateTime lastModified() {
        return this.lastModified.zonedDateTime();
    }

    public String etag() {
        return this.etag;
    }

    public long size() {
        return this.size;
    }

    public String storageClass() {
        return this.storageClass;
    }

    public Owner owner() {
        return this.owner;
    }

    public Map<String, String> userMetadata() {
        if (this.userMetadata == null) {
            return null;
        }
        return this.userMetadata.get();
    }

    public boolean isDir() {
        return this.isDir;
    }
}

