/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.websocketapi;

import com.binance.connector.client.utils.JSONParser;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.websocketapi.WebSocketApiRequestHandler;
import org.json.JSONObject;

public class WebSocketApiTrade {
    private WebSocketApiRequestHandler handler;

    public WebSocketApiTrade(WebSocketApiRequestHandler handler) {
        this.handler = handler;
    }

    public void newOrder(String symbol, String side, String type, JSONObject parameters) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        ParameterChecker.checkParameterType(side, String.class, "side");
        ParameterChecker.checkParameterType(type, String.class, "type");
        parameters = JSONParser.addKeyValue(parameters, "symbol", symbol);
        parameters = JSONParser.addKeyValue(parameters, "side", side);
        parameters = JSONParser.addKeyValue(parameters, "type", type);
        this.handler.signedRequest("order.place", parameters);
    }

    public void testNewOrder(String symbol, String side, String type, JSONObject parameters) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        ParameterChecker.checkParameterType(side, String.class, "side");
        ParameterChecker.checkParameterType(type, String.class, "type");
        parameters = JSONParser.addKeyValue(parameters, "symbol", symbol);
        parameters = JSONParser.addKeyValue(parameters, "side", side);
        parameters = JSONParser.addKeyValue(parameters, "type", type);
        this.handler.signedRequest("order.test", parameters);
    }

    public void getOrder(String symbol, JSONObject parameters) {
        ParameterChecker.checkOneOfParametersRequired(parameters, "orderId", "origClientOrderId");
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        parameters = JSONParser.addKeyValue(parameters, "symbol", symbol);
        this.handler.signedRequest("order.status", parameters);
    }

    public void cancelOrder(String symbol, JSONObject parameters) {
        ParameterChecker.checkOneOfParametersRequired(parameters, "orderId", "origClientOrderId");
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        parameters = JSONParser.addKeyValue(parameters, "symbol", symbol);
        this.handler.signedRequest("order.cancel", parameters);
    }

    public void cancelReplaceOrder(String symbol, String cancelReplaceMode, String side, String type, JSONObject parameters) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        ParameterChecker.checkParameterType(cancelReplaceMode, String.class, "cancelReplaceMode");
        ParameterChecker.checkParameterType(side, String.class, "side");
        ParameterChecker.checkParameterType(type, String.class, "type");
        ParameterChecker.checkOneOfParametersRequired(parameters, "cancelOrderId", "cancelOrigClientOrderId");
        parameters = JSONParser.addKeyValue(parameters, "symbol", symbol);
        parameters = JSONParser.addKeyValue(parameters, "cancelReplaceMode", cancelReplaceMode);
        parameters = JSONParser.addKeyValue(parameters, "side", side);
        parameters = JSONParser.addKeyValue(parameters, "type", type);
        this.handler.signedRequest("order.cancelReplace", parameters);
    }

    public void getOpenOrders(JSONObject parameters) {
        this.handler.signedRequest("openOrders.status", parameters);
    }

    public void cancelAllOpenOrders(String symbol, JSONObject parameters) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        parameters = JSONParser.addKeyValue(parameters, "symbol", symbol);
        this.handler.signedRequest("openOrders.cancelAll", parameters);
    }

    public void newOcoOrder(String symbol, String side, double price, double quantity, JSONObject parameters) {
        ParameterChecker.checkOneOfParametersRequired(parameters, "stopPrice", "trailingDelta");
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        ParameterChecker.checkParameterType(side, String.class, "side");
        ParameterChecker.checkParameterType(price, Double.class, "price");
        ParameterChecker.checkParameterType(quantity, Double.class, "quantity");
        parameters = JSONParser.addKeyValue(parameters, "symbol", symbol);
        parameters = JSONParser.addKeyValue(parameters, "side", side);
        parameters = JSONParser.addKeyValue(parameters, "price", price);
        parameters = JSONParser.addKeyValue(parameters, "quantity", quantity);
        this.handler.signedRequest("orderList.place", parameters);
    }

    public void getOcoOrder(JSONObject parameters) {
        ParameterChecker.checkOneOfParametersRequired(parameters, "origClientOrderId", "orderListId");
        this.handler.signedRequest("orderList.status", parameters);
    }

    public void cancelOcoOrder(String symbol, JSONObject parameters) {
        ParameterChecker.checkOneOfParametersRequired(parameters, "listClientOrderId", "orderListId");
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        parameters = JSONParser.addKeyValue(parameters, "symbol", symbol);
        this.handler.signedRequest("orderList.cancel", parameters);
    }

    public void getOpenOcoOrders(JSONObject parameters) {
        this.handler.signedRequest("openOrderLists.status", parameters);
    }
}

