/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.spot;

import com.binance.connector.client.enums.HttpMethod;
import com.binance.connector.client.exceptions.BinanceConnectorException;
import com.binance.connector.client.utils.JSONParser;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.ProxyAuth;
import com.binance.connector.client.utils.RequestHandler;
import java.util.ArrayList;
import java.util.Map;

public class Market {
    private final String baseUrl;
    private final RequestHandler requestHandler;
    private final boolean showLimitUsage;
    private final String PING = "/api/v3/ping";
    private final String TIME = "/api/v3/time";
    private final String EXCHANGE_INFO = "/api/v3/exchangeInfo";
    private final String DEPTH = "/api/v3/depth";
    private final String TRADES = "/api/v3/trades";
    private final String HISTORICAL_TRADES = "/api/v3/historicalTrades";
    private final String AGG_TRADES = "/api/v3/aggTrades";
    private final String KLINES = "/api/v3/klines";
    private final String UIKLINES = "/api/v3/uiKlines";
    private final String AVG_PRICE = "/api/v3/avgPrice";
    private final String TICKER_24H = "/api/v3/ticker/24hr";
    private final String TICKER_SYMBOL = "/api/v3/ticker/price";
    private final String BOOK_TICKER = "/api/v3/ticker/bookTicker";
    private final String TICKER = "/api/v3/ticker";

    public Market(String baseUrl, String apiKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String ping() {
        return this.requestHandler.sendPublicRequest(this.baseUrl, "/api/v3/ping", null, HttpMethod.GET, this.showLimitUsage);
    }

    public String time() {
        return this.requestHandler.sendPublicRequest(this.baseUrl, "/api/v3/time", null, HttpMethod.GET, this.showLimitUsage);
    }

    public String exchangeInfo(Map<String, Object> parameters) {
        if (parameters.containsKey("symbol") && parameters.containsKey("symbols")) {
            throw new BinanceConnectorException("symbol and symbols cannot be sent together.");
        }
        if (parameters.containsKey("symbol") && parameters.containsKey("permissions") || parameters.containsKey("symbols") && parameters.containsKey("permissions")) {
            throw new BinanceConnectorException("permissions cannot be sent together with symbol or symbols.");
        }
        if (parameters.containsKey("symbols")) {
            ParameterChecker.checkParameterType(parameters.get("symbols"), ArrayList.class, "symbols");
            parameters.put("symbols", JSONParser.getJSONArray((ArrayList)parameters.get("symbols"), "symbols"));
        }
        if (parameters.containsKey("permissions")) {
            ParameterChecker.checkParameterType(parameters.get("permissions"), ArrayList.class, "permissions");
            parameters.put("permissions", JSONParser.getJSONArray((ArrayList)parameters.get("permissions"), "permissions"));
        }
        return this.requestHandler.sendPublicRequest(this.baseUrl, "/api/v3/exchangeInfo", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String depth(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendPublicRequest(this.baseUrl, "/api/v3/depth", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String trades(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendPublicRequest(this.baseUrl, "/api/v3/trades", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String historicalTrades(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendApiRequest(this.baseUrl, "/api/v3/historicalTrades", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String aggTrades(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendPublicRequest(this.baseUrl, "/api/v3/aggTrades", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String klines(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkParameter(parameters, "interval", String.class);
        return this.requestHandler.sendPublicRequest(this.baseUrl, "/api/v3/klines", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String uiKlines(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkParameter(parameters, "interval", String.class);
        return this.requestHandler.sendPublicRequest(this.baseUrl, "/api/v3/uiKlines", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String averagePrice(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        return this.requestHandler.sendPublicRequest(this.baseUrl, "/api/v3/avgPrice", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String ticker24H(Map<String, Object> parameters) {
        if (parameters.containsKey("symbol") && parameters.containsKey("symbols")) {
            throw new BinanceConnectorException("symbol and symbols cannot be sent together.");
        }
        if (parameters.containsKey("symbols")) {
            ParameterChecker.checkParameterType(parameters.get("symbols"), ArrayList.class, "symbols");
            parameters.put("symbols", JSONParser.getJSONArray((ArrayList)parameters.get("symbols"), "symbols"));
        }
        return this.requestHandler.sendPublicRequest(this.baseUrl, "/api/v3/ticker/24hr", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String tickerSymbol(Map<String, Object> parameters) {
        if (parameters.containsKey("symbol") && parameters.containsKey("symbols")) {
            throw new BinanceConnectorException("symbol and symbols cannot be sent together.");
        }
        if (parameters.containsKey("symbols")) {
            ParameterChecker.checkParameterType(parameters.get("symbols"), ArrayList.class, "symbols");
            parameters.put("symbols", JSONParser.getJSONArray((ArrayList)parameters.get("symbols"), "symbols"));
        }
        return this.requestHandler.sendPublicRequest(this.baseUrl, "/api/v3/ticker/price", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String bookTicker(Map<String, Object> parameters) {
        if (parameters.containsKey("symbol") && parameters.containsKey("symbols")) {
            throw new BinanceConnectorException("symbol and symbols cannot be sent together.");
        }
        if (parameters.containsKey("symbols")) {
            ParameterChecker.checkParameterType(parameters.get("symbols"), ArrayList.class, "symbols");
            parameters.put("symbols", JSONParser.getJSONArray((ArrayList)parameters.get("symbols"), "symbols"));
        }
        return this.requestHandler.sendPublicRequest(this.baseUrl, "/api/v3/ticker/bookTicker", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String ticker(Map<String, Object> parameters) {
        if (parameters.containsKey("symbol") && parameters.containsKey("symbols")) {
            throw new BinanceConnectorException("symbol and symbols cannot be sent together.");
        }
        if (parameters.containsKey("symbols")) {
            ParameterChecker.checkParameterType(parameters.get("symbols"), ArrayList.class, "symbols");
            parameters.put("symbols", JSONParser.getJSONArray((ArrayList)parameters.get("symbols"), "symbols"));
        } else {
            ParameterChecker.checkParameter(parameters, "symbol", String.class);
        }
        return this.requestHandler.sendPublicRequest(this.baseUrl, "/api/v3/ticker", parameters, HttpMethod.GET, this.showLimitUsage);
    }
}

