/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.spot;

import com.binance.connector.client.enums.HttpMethod;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.ProxyAuth;
import com.binance.connector.client.utils.RequestHandler;
import com.binance.connector.client.utils.signaturegenerator.HmacSignatureGenerator;
import com.binance.connector.client.utils.signaturegenerator.SignatureGenerator;
import java.util.Map;

public class GiftCard {
    private final String baseUrl;
    private final RequestHandler requestHandler;
    private final boolean showLimitUsage;
    private final String CREATE_CODE = "/sapi/v1/giftcard/createCode";
    private final String REDEEM_CODE = "/sapi/v1/giftcard/redeemCode";
    private final String VERIFY = "/sapi/v1/giftcard/verify";
    private final String RSA_PUB = "/sapi/v1/giftcard/cryptography/rsa-public-key";

    public GiftCard(String baseUrl, String apiKey, String secretKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, new HmacSignatureGenerator(secretKey), proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public GiftCard(String baseUrl, String apiKey, SignatureGenerator signatureGenerator, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, signatureGenerator, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String createCode(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "token", String.class);
        ParameterChecker.checkParameter(parameters, "amount", Double.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/giftcard/createCode", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String redeemCode(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "code", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/giftcard/redeemCode", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String verify(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "referenceNo", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/giftcard/verify", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String rsaPublicKey(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/giftcard/cryptography/rsa-public-key", parameters, HttpMethod.GET, this.showLimitUsage);
    }
}

