/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.spot;

import com.binance.connector.client.enums.HttpMethod;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.ProxyAuth;
import com.binance.connector.client.utils.RequestHandler;
import com.binance.connector.client.utils.signaturegenerator.HmacSignatureGenerator;
import com.binance.connector.client.utils.signaturegenerator.SignatureGenerator;
import java.util.Map;

public class Futures {
    private final String baseUrl;
    private final RequestHandler requestHandler;
    private final boolean showLimitUsage;
    private final String FUTURES_TRANSFER = "/sapi/v1/futures/transfer";
    private final String BORROW_HISTORY = "/sapi/v1/futures/loan/borrow/history";
    private final String REPAY_HISTORY = "/sapi/v1/futures/loan/repay/history";
    private final String WALLET = "/sapi/v2/futures/loan/wallet";
    private final String ADJUST_COLLATERAL_HISTORY = "/sapi/v1/futures/loan/adjustCollateral/history";
    private final String LIQUIDATION_HISTORY = "/sapi/v1/futures/loan/liquidationHistory";
    private final String INTEREST_HISTORY = "/sapi/v1/futures/loan/interestHistory";

    public Futures(String baseUrl, String apiKey, String secretKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, new HmacSignatureGenerator(secretKey), proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public Futures(String baseUrl, String apiKey, SignatureGenerator signatureGenerator, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, signatureGenerator, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String futuresTransfer(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        ParameterChecker.checkParameter(parameters, "type", Integer.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/futures/transfer", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String futuresTransferHistory(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        ParameterChecker.checkParameter(parameters, "startTime", Long.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/futures/transfer", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String borrowHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/futures/loan/borrow/history", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String repayHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/futures/loan/repay/history", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String loanWallet(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v2/futures/loan/wallet", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String adjustCollateralHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/futures/loan/adjustCollateral/history", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String liquidationHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/futures/loan/liquidationHistory", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String interestHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/futures/loan/interestHistory", parameters, HttpMethod.GET, this.showLimitUsage);
    }
}

