/*
 * Decompiled with CFR 0.152.
 */
package io.github.adraffy.ens;

import io.github.adraffy.ens.ReadOnlyIntList;
import io.github.adraffy.ens.StringUtils;
import java.util.Arrays;

public class EmojiSequence {
    public final String form;
    public final ReadOnlyIntList beautified;
    public final ReadOnlyIntList normalized;

    EmojiSequence(int[] cps) {
        this.form = StringUtils.implode(cps);
        this.beautified = new ReadOnlyIntList(cps);
        int[] norm = Arrays.stream(cps).filter(cp -> cp != 65039).toArray();
        this.normalized = norm.length < cps.length ? new ReadOnlyIntList(norm) : this.beautified;
    }

    public boolean isMangled() {
        return this.beautified != this.normalized;
    }

    public String toString() {
        return String.format("Emoji[%s]", StringUtils.toHexSequence(this.beautified.array));
    }
}

