/*
 * Decompiled with CFR 0.152.
 */
package de.psdev.licensesdialog.licenses;

import android.content.Context;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;

public abstract class License
implements Serializable {
    private static final long serialVersionUID = 3100331505738956523L;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String mCachedSummaryText = null;
    private String mCachedFullText = null;

    public abstract String getName();

    public abstract String readSummaryTextFromResources(Context var1);

    public abstract String readFullTextFromResources(Context var1);

    public abstract String getVersion();

    public abstract String getUrl();

    public final String getSummaryText(Context context) {
        if (this.mCachedSummaryText == null) {
            this.mCachedSummaryText = this.readSummaryTextFromResources(context);
        }
        return this.mCachedSummaryText;
    }

    public final String getFullText(Context context) {
        if (this.mCachedFullText == null) {
            this.mCachedFullText = this.readFullTextFromResources(context);
        }
        return this.mCachedFullText;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getContent(Context context, int contentResourceId) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(context.getResources().openRawResource(contentResourceId), "UTF-8"));){
            String string2 = this.toString(reader);
            return string2;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private String toString(BufferedReader reader) throws IOException {
        String line;
        StringBuilder builder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            builder.append(line).append(LINE_SEPARATOR);
        }
        return builder.toString();
    }
}

