/*
 * Decompiled with CFR 0.152.
 */
package de.psdev.licensesdialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.annotation.RawRes;
import android.support.annotation.StringRes;
import android.support.annotation.StyleRes;
import android.support.v4.app.DialogFragment;
import de.psdev.licensesdialog.LicensesDialog;
import de.psdev.licensesdialog.NoticesHtmlBuilder;
import de.psdev.licensesdialog.NoticesXmlParser;
import de.psdev.licensesdialog.R;
import de.psdev.licensesdialog.model.Notice;
import de.psdev.licensesdialog.model.Notices;

public class LicensesDialogFragment
extends DialogFragment {
    private static final String ARGUMENT_NOTICES = "ARGUMENT_NOTICES";
    private static final String ARGUMENT_NOTICES_XML_ID = "ARGUMENT_NOTICES_XML_ID";
    private static final String ARGUMENT_INCLUDE_OWN_LICENSE = "ARGUMENT_INCLUDE_OWN_LICENSE";
    private static final String ARGUMENT_FULL_LICENSE_TEXT = "ARGUMENT_FULL_LICENSE_TEXT";
    private static final String ARGUMENT_THEME_XML_ID = "ARGUMENT_THEME_XML_ID";
    private static final String ARGUMENT_DIVIDER_COLOR = "ARGUMENT_DIVIDER_COLOR";
    private static final String ARGUMENT_NOTICE_STYLE = "ARGUMENT_NOTICE_STYLE";
    private static final String STATE_TITLE_TEXT = "title_text";
    private static final String STATE_LICENSES_TEXT = "licenses_text";
    private static final String STATE_CLOSE_TEXT = "close_text";
    private static final String STATE_THEME_XML_ID = "theme_xml_id";
    private static final String STATE_DIVIDER_COLOR = "divider_color";
    private String mTitleText;
    private String mCloseButtonText;
    private String mLicensesText;
    private int mThemeResourceId;
    private int mDividerColor;
    private DialogInterface.OnDismissListener mOnDismissListener;

    private static LicensesDialogFragment newInstance(Notices notices, boolean showFullLicenseText, boolean includeOwnLicense, String noticeStyle, int themeResourceId, int dividerColor) {
        LicensesDialogFragment licensesDialogFragment = new LicensesDialogFragment();
        Bundle args = new Bundle();
        args.putParcelable(ARGUMENT_NOTICES, (Parcelable)notices);
        args.putBoolean(ARGUMENT_FULL_LICENSE_TEXT, showFullLicenseText);
        args.putBoolean(ARGUMENT_INCLUDE_OWN_LICENSE, includeOwnLicense);
        args.putString(ARGUMENT_NOTICE_STYLE, noticeStyle);
        args.putInt(ARGUMENT_THEME_XML_ID, themeResourceId);
        args.putInt(ARGUMENT_DIVIDER_COLOR, dividerColor);
        licensesDialogFragment.setArguments(args);
        return licensesDialogFragment;
    }

    private static LicensesDialogFragment newInstance(int rawNoticesResourceId, boolean showFullLicenseText, boolean includeOwnLicense, String noticeStyle, int themeResourceId, int dividerColor) {
        LicensesDialogFragment licensesDialogFragment = new LicensesDialogFragment();
        Bundle args = new Bundle();
        args.putInt(ARGUMENT_NOTICES_XML_ID, rawNoticesResourceId);
        args.putBoolean(ARGUMENT_FULL_LICENSE_TEXT, showFullLicenseText);
        args.putBoolean(ARGUMENT_INCLUDE_OWN_LICENSE, includeOwnLicense);
        args.putString(ARGUMENT_NOTICE_STYLE, noticeStyle);
        args.putInt(ARGUMENT_THEME_XML_ID, themeResourceId);
        args.putInt(ARGUMENT_DIVIDER_COLOR, dividerColor);
        licensesDialogFragment.setArguments(args);
        return licensesDialogFragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Resources resources = this.getResources();
        if (savedInstanceState != null) {
            this.mTitleText = savedInstanceState.getString(STATE_TITLE_TEXT);
            this.mLicensesText = savedInstanceState.getString(STATE_LICENSES_TEXT);
            this.mCloseButtonText = savedInstanceState.getString(STATE_CLOSE_TEXT);
            if (savedInstanceState.containsKey(STATE_THEME_XML_ID)) {
                this.mThemeResourceId = savedInstanceState.getInt(STATE_THEME_XML_ID);
            }
            if (savedInstanceState.containsKey(STATE_DIVIDER_COLOR)) {
                this.mDividerColor = savedInstanceState.getInt(STATE_DIVIDER_COLOR);
            }
        } else {
            this.mTitleText = resources.getString(R.string.notices_title);
            this.mCloseButtonText = resources.getString(R.string.notices_close);
            try {
                String noticeStyle;
                boolean showFullLicenseText;
                Notices notices;
                Bundle arguments = this.getArguments();
                if (arguments != null) {
                    if (arguments.containsKey(ARGUMENT_NOTICES_XML_ID)) {
                        notices = NoticesXmlParser.parse(resources.openRawResource(this.getNoticesXmlResourceId()));
                    } else if (arguments.containsKey(ARGUMENT_NOTICES)) {
                        notices = (Notices)arguments.getParcelable(ARGUMENT_NOTICES);
                    } else {
                        throw new IllegalStateException("Missing ARGUMENT_NOTICES_XML_ID / ARGUMENT_NOTICES");
                    }
                    if (arguments.getBoolean(ARGUMENT_INCLUDE_OWN_LICENSE, false)) {
                        notices.getNotices().add(LicensesDialog.LICENSES_DIALOG_NOTICE);
                    }
                    showFullLicenseText = arguments.getBoolean(ARGUMENT_FULL_LICENSE_TEXT, false);
                    if (arguments.containsKey(ARGUMENT_THEME_XML_ID)) {
                        this.mThemeResourceId = Build.VERSION.SDK_INT >= 14 ? arguments.getInt(ARGUMENT_THEME_XML_ID, 16974130) : arguments.getInt(ARGUMENT_THEME_XML_ID);
                    }
                    if (arguments.containsKey(ARGUMENT_DIVIDER_COLOR)) {
                        this.mDividerColor = Build.VERSION.SDK_INT >= 14 ? arguments.getInt(ARGUMENT_DIVIDER_COLOR, 17170450) : arguments.getInt(ARGUMENT_DIVIDER_COLOR);
                    }
                    if ((noticeStyle = arguments.getString(ARGUMENT_NOTICE_STYLE)) == null) {
                        noticeStyle = resources.getString(R.string.notices_default_style);
                    }
                } else {
                    throw new IllegalStateException("Missing arguments");
                }
                this.mLicensesText = NoticesHtmlBuilder.create((Context)this.getActivity()).setNotices(notices).setShowFullLicenseText(showFullLicenseText).setStyle(noticeStyle).build();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(STATE_TITLE_TEXT, this.mTitleText);
        outState.putString(STATE_LICENSES_TEXT, this.mLicensesText);
        outState.putString(STATE_CLOSE_TEXT, this.mCloseButtonText);
        if (this.mThemeResourceId != 0) {
            outState.putInt(STATE_THEME_XML_ID, this.mThemeResourceId);
        }
        if (this.mDividerColor != 0) {
            outState.putInt(STATE_DIVIDER_COLOR, this.mDividerColor);
        }
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        LicensesDialog.Builder builder = new LicensesDialog.Builder(this.requireContext()).setNotices(this.mLicensesText).setTitle(this.mTitleText).setCloseText(this.mCloseButtonText).setThemeResourceId(this.mThemeResourceId).setDividerColor(this.mDividerColor);
        LicensesDialog licensesDialog = builder.build();
        return licensesDialog.create();
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss(dialog);
        }
    }

    public DialogInterface.OnDismissListener getOnDismissListener() {
        return this.mOnDismissListener;
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
    }

    private int getNoticesXmlResourceId() {
        int resourceId = R.raw.notices;
        Bundle arguments = this.getArguments();
        if (arguments != null && arguments.containsKey(ARGUMENT_NOTICES_XML_ID)) {
            resourceId = arguments.getInt(ARGUMENT_NOTICES_XML_ID);
            if (!"raw".equalsIgnoreCase(this.getResources().getResourceTypeName(resourceId))) {
                throw new IllegalStateException("not a raw resource");
            }
        }
        return resourceId;
    }

    public static class Builder {
        private final Context mContext;
        private Notices mNotices;
        private Integer mRawNoticesResourceId;
        private boolean mShowFullLicenseText;
        private boolean mIncludeOwnLicense;
        private String mNoticesStyle;
        private int mThemeResourceId;
        private int mDividerColor;

        public Builder(@NonNull Context context) {
            this.mContext = context;
            this.mShowFullLicenseText = false;
            this.mIncludeOwnLicense = true;
            this.mNoticesStyle = context.getString(R.string.notices_default_style);
            this.mThemeResourceId = 0;
            this.mDividerColor = 0;
        }

        public Builder setNotice(Notice notice) {
            this.mNotices = new Notices();
            this.mNotices.addNotice(notice);
            return this;
        }

        public Builder setNotices(Notices notices) {
            this.mNotices = notices;
            return this;
        }

        public Builder setNotices(@RawRes int rawNoticesResourceId) {
            this.mRawNoticesResourceId = rawNoticesResourceId;
            return this;
        }

        public Builder setShowFullLicenseText(boolean showFullLicenseText) {
            this.mShowFullLicenseText = showFullLicenseText;
            return this;
        }

        public Builder setIncludeOwnLicense(boolean includeOwnLicense) {
            this.mIncludeOwnLicense = includeOwnLicense;
            return this;
        }

        public Builder setNoticesCssStyle(@StringRes int cssStyleTextId) {
            this.mNoticesStyle = this.mContext.getString(cssStyleTextId);
            return this;
        }

        public Builder setNoticesCssStyle(String cssStyleText) {
            this.mNoticesStyle = cssStyleText;
            return this;
        }

        public Builder setThemeResourceId(@StyleRes int themeResourceId) {
            this.mThemeResourceId = themeResourceId;
            return this;
        }

        public Builder setDividerColorRes(@ColorRes int dividerColor) {
            this.mDividerColor = this.mContext.getResources().getColor(dividerColor);
            return this;
        }

        public Builder setDividerColor(@ColorInt int dividerColor) {
            this.mDividerColor = dividerColor;
            return this;
        }

        public LicensesDialogFragment build() {
            if (this.mNotices != null) {
                return LicensesDialogFragment.newInstance(this.mNotices, this.mShowFullLicenseText, this.mIncludeOwnLicense, this.mNoticesStyle, this.mThemeResourceId, this.mDividerColor);
            }
            if (this.mRawNoticesResourceId != null) {
                return LicensesDialogFragment.newInstance(this.mRawNoticesResourceId, this.mShowFullLicenseText, this.mIncludeOwnLicense, this.mNoticesStyle, this.mThemeResourceId, this.mDividerColor);
            }
            throw new IllegalStateException("Required parameter not set. You need to call setNotices.");
        }
    }
}

