/*
 * Decompiled with CFR 0.152.
 */
package de.psdev.licensesdialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Message;
import android.support.annotation.Nullable;
import android.support.v7.app.AlertDialog;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import de.psdev.licensesdialog.NoticesHtmlBuilder;
import de.psdev.licensesdialog.NoticesXmlParser;
import de.psdev.licensesdialog.R;
import de.psdev.licensesdialog.licenses.ApacheSoftwareLicense20;
import de.psdev.licensesdialog.model.Notice;
import de.psdev.licensesdialog.model.Notices;
import java.util.List;

public class LicensesDialog {
    public static final Notice LICENSES_DIALOG_NOTICE = new Notice("LicensesDialog", "http://psdev.de/LicensesDialog", "Copyright 2013-2016 Philip Schiffer", new ApacheSoftwareLicense20());
    private final Context mContext;
    private final String mTitleText;
    private final String mLicensesText;
    private final String mCloseText;
    private final int mThemeResourceId;
    private final int mDividerColor;
    private DialogInterface.OnDismissListener mOnDismissListener;

    private LicensesDialog(Context context, String licensesText, String titleText, String closeText, int themeResourceId, int dividerColor) {
        this.mContext = context;
        this.mTitleText = titleText;
        this.mLicensesText = licensesText;
        this.mCloseText = closeText;
        this.mThemeResourceId = themeResourceId;
        this.mDividerColor = dividerColor;
    }

    public LicensesDialog setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
        return this;
    }

    public Dialog create() {
        WebView webView = LicensesDialog.createWebView(this.mContext);
        webView.loadDataWithBaseURL(null, this.mLicensesText, "text/html", "utf-8", null);
        AlertDialog.Builder builder = this.mThemeResourceId != 0 ? new AlertDialog.Builder((Context)new ContextThemeWrapper(this.mContext, this.mThemeResourceId)) : new AlertDialog.Builder(this.mContext);
        builder.setTitle((CharSequence)this.mTitleText).setView((View)webView).setPositiveButton((CharSequence)this.mCloseText, (dialogInterface, i) -> dialogInterface.dismiss());
        AlertDialog dialog = builder.create();
        dialog.setOnDismissListener(dialog1 -> {
            if (this.mOnDismissListener != null) {
                this.mOnDismissListener.onDismiss(dialog1);
            }
        });
        dialog.setOnShowListener(dialogInterface -> {
            int titleDividerId;
            View titleDivider;
            if (this.mDividerColor != 0 && (titleDivider = dialog.findViewById(titleDividerId = this.mContext.getResources().getIdentifier("titleDivider", "id", "android"))) != null) {
                titleDivider.setBackgroundColor(this.mDividerColor);
            }
        });
        return dialog;
    }

    public Dialog show() {
        Dialog dialog = this.create();
        dialog.show();
        return dialog;
    }

    private static WebView createWebView(final Context context) {
        WebView webView = new WebView(context);
        webView.getSettings().setSupportMultipleWindows(true);
        webView.setWebChromeClient(new WebChromeClient(){

            public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
                WebView.HitTestResult result = view.getHitTestResult();
                String data = result.getExtra();
                if (data != null) {
                    Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)data));
                    context.startActivity(browserIntent);
                }
                return false;
            }
        });
        return webView;
    }

    public static final class Builder {
        private final Context mContext;
        private String mTitleText;
        private String mCloseText;
        @Nullable
        private Integer mRawNoticesId;
        @Nullable
        private Notices mNotices;
        @Nullable
        private String mNoticesText;
        private String mNoticesStyle;
        private boolean mShowFullLicenseText;
        private boolean mIncludeOwnLicense;
        private int mThemeResourceId;
        private int mDividerColor;

        public Builder(Context context) {
            this.mContext = context;
            this.mTitleText = context.getString(R.string.notices_title);
            this.mCloseText = context.getString(R.string.notices_close);
            this.mNoticesStyle = context.getString(R.string.notices_default_style);
            this.mShowFullLicenseText = false;
            this.mIncludeOwnLicense = false;
            this.mThemeResourceId = 0;
            this.mDividerColor = 0;
        }

        public Builder setTitle(int titleId) {
            this.mTitleText = this.mContext.getString(titleId);
            return this;
        }

        public Builder setTitle(String title) {
            this.mTitleText = title;
            return this;
        }

        public Builder setCloseText(int closeId) {
            this.mCloseText = this.mContext.getString(closeId);
            return this;
        }

        public Builder setCloseText(String closeText) {
            this.mCloseText = closeText;
            return this;
        }

        public Builder setNotices(int rawNoticesId) {
            this.mRawNoticesId = rawNoticesId;
            this.mNotices = null;
            return this;
        }

        public Builder setNotices(Notices notices) {
            this.mNotices = notices;
            this.mRawNoticesId = null;
            return this;
        }

        public Builder setNotices(Notice notice) {
            return this.setNotices(Builder.getSingleNoticeNotices(notice));
        }

        Builder setNotices(String notices) {
            this.mNotices = null;
            this.mRawNoticesId = null;
            this.mNoticesText = notices;
            return this;
        }

        public Builder setNoticesCssStyle(int cssStyleTextId) {
            this.mNoticesStyle = this.mContext.getString(cssStyleTextId);
            return this;
        }

        public Builder setNoticesCssStyle(String cssStyleText) {
            this.mNoticesStyle = cssStyleText;
            return this;
        }

        public Builder setShowFullLicenseText(boolean showFullLicenseText) {
            this.mShowFullLicenseText = showFullLicenseText;
            return this;
        }

        public Builder setIncludeOwnLicense(boolean includeOwnLicense) {
            this.mIncludeOwnLicense = includeOwnLicense;
            return this;
        }

        public Builder setThemeResourceId(int themeResourceId) {
            this.mThemeResourceId = themeResourceId;
            return this;
        }

        public Builder setDividerColor(int dividerColor) {
            this.mDividerColor = dividerColor;
            return this;
        }

        public Builder setDividerColorId(int dividerColorId) {
            this.mDividerColor = this.mContext.getResources().getColor(dividerColorId);
            return this;
        }

        public LicensesDialog build() {
            String licensesText;
            if (this.mNotices != null) {
                licensesText = Builder.getLicensesText(this.mContext, this.mNotices, this.mShowFullLicenseText, this.mIncludeOwnLicense, this.mNoticesStyle);
            } else if (this.mRawNoticesId != null) {
                licensesText = Builder.getLicensesText(this.mContext, Builder.getNotices(this.mContext, this.mRawNoticesId), this.mShowFullLicenseText, this.mIncludeOwnLicense, this.mNoticesStyle);
            } else if (this.mNoticesText != null) {
                licensesText = this.mNoticesText;
            } else {
                throw new IllegalStateException("Notices have to be provided, see setNotices");
            }
            return new LicensesDialog(this.mContext, licensesText, this.mTitleText, this.mCloseText, this.mThemeResourceId, this.mDividerColor);
        }

        private static Notices getNotices(Context context, int rawNoticesResourceId) {
            try {
                Resources resources = context.getResources();
                if ("raw".equals(resources.getResourceTypeName(rawNoticesResourceId))) {
                    return NoticesXmlParser.parse(resources.openRawResource(rawNoticesResourceId));
                }
                throw new IllegalStateException("not a raw resource");
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        private static String getLicensesText(Context context, Notices notices, boolean showFullLicenseText, boolean includeOwnLicense, String style) {
            try {
                if (includeOwnLicense) {
                    List<Notice> noticeList = notices.getNotices();
                    noticeList.add(LICENSES_DIALOG_NOTICE);
                }
                return NoticesHtmlBuilder.create(context).setShowFullLicenseText(showFullLicenseText).setNotices(notices).setStyle(style).build();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        private static Notices getSingleNoticeNotices(Notice notice) {
            Notices notices = new Notices();
            notices.addNotice(notice);
            return notices;
        }
    }
}

