/*
 * Decompiled with CFR 0.152.
 */
package de.psdev.licensesdialog.licenses;

import android.content.Context;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;

public abstract class License
implements Serializable {
    private static final long serialVersionUID = 3100331505738956523L;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String mCachedSummaryText = null;
    private String mCachedFullText = null;

    public abstract String getName();

    public abstract String readSummaryTextFromResources(Context var1);

    public abstract String readFullTextFromResources(Context var1);

    public abstract String getVersion();

    public abstract String getUrl();

    public final String getSummaryText(Context context) {
        if (this.mCachedSummaryText == null) {
            this.mCachedSummaryText = this.readSummaryTextFromResources(context);
        }
        return this.mCachedSummaryText;
    }

    public final String getFullText(Context context) {
        if (this.mCachedFullText == null) {
            this.mCachedFullText = this.readFullTextFromResources(context);
        }
        return this.mCachedFullText;
    }

    protected String getContent(Context context, int contentResourceId) {
        BufferedReader reader = null;
        try {
            InputStream inputStream = context.getResources().openRawResource(contentResourceId);
            if (inputStream != null) {
                reader = new BufferedReader(new InputStreamReader(inputStream));
                String string2 = this.toString(reader);
                return string2;
            }
            try {
                throw new IOException("Error opening license file.");
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String toString(BufferedReader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            builder.append(line).append(LINE_SEPARATOR);
        }
        return builder.toString();
    }
}

