/*
 * Decompiled with CFR 0.152.
 */
package de.psdev.licensesdialog;

import de.psdev.licensesdialog.licenses.ApacheSoftwareLicense20;
import de.psdev.licensesdialog.licenses.BSD2ClauseLicense;
import de.psdev.licensesdialog.licenses.BSD3ClauseLicense;
import de.psdev.licensesdialog.licenses.CreativeCommonsAttributionNoDerivs30Unported;
import de.psdev.licensesdialog.licenses.GnuGeneralPublicLicense20;
import de.psdev.licensesdialog.licenses.GnuGeneralPublicLicense30;
import de.psdev.licensesdialog.licenses.GnuLesserGeneralPublicLicense21;
import de.psdev.licensesdialog.licenses.GnuLesserGeneralPublicLicense3;
import de.psdev.licensesdialog.licenses.ISCLicense;
import de.psdev.licensesdialog.licenses.License;
import de.psdev.licensesdialog.licenses.MITLicense;
import de.psdev.licensesdialog.licenses.MozillaPublicLicense11;
import de.psdev.licensesdialog.licenses.SILOpenFontLicense11;
import java.util.HashMap;
import java.util.Map;

public final class LicenseResolver {
    private static final int INITIAL_LICENSES_COUNT = 4;
    private static final Map<String, License> sLicenses = new HashMap<String, License>(4);

    static void registerDefaultLicenses() {
        sLicenses.clear();
        LicenseResolver.registerLicense(new ApacheSoftwareLicense20());
        LicenseResolver.registerLicense(new BSD2ClauseLicense());
        LicenseResolver.registerLicense(new BSD3ClauseLicense());
        LicenseResolver.registerLicense(new ISCLicense());
        LicenseResolver.registerLicense(new MITLicense());
        LicenseResolver.registerLicense(new GnuLesserGeneralPublicLicense21());
        LicenseResolver.registerLicense(new GnuLesserGeneralPublicLicense3());
        LicenseResolver.registerLicense(new CreativeCommonsAttributionNoDerivs30Unported());
        LicenseResolver.registerLicense(new GnuGeneralPublicLicense30());
        LicenseResolver.registerLicense(new GnuGeneralPublicLicense20());
        LicenseResolver.registerLicense(new MozillaPublicLicense11());
        LicenseResolver.registerLicense(new SILOpenFontLicense11());
    }

    public static void registerLicense(License license) {
        sLicenses.put(license.getName(), license);
    }

    public static License read(String license) {
        String trimmedLicense = license.trim();
        if (sLicenses.containsKey(trimmedLicense)) {
            return sLicenses.get(trimmedLicense);
        }
        throw new IllegalStateException(String.format("no such license available: %s, did you forget to register it?", trimmedLicense));
    }

    private LicenseResolver() {
    }

    static {
        LicenseResolver.registerDefaultLicenses();
    }
}

