/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import com.squareup.leakcanary.ExcludedRefs;
import com.squareup.leakcanary.Preconditions;
import com.squareup.leakcanary.Reachability;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class HeapDump
implements Serializable {
    public final File heapDumpFile;
    public final String referenceKey;
    public final String referenceName;
    public final ExcludedRefs excludedRefs;
    public final long watchDurationMs;
    public final long gcDurationMs;
    public final long heapDumpDurationMs;
    public final boolean computeRetainedHeapSize;
    public final List<Class<? extends Reachability.Inspector>> reachabilityInspectorClasses;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public HeapDump(File heapDumpFile, String referenceKey, String referenceName, ExcludedRefs excludedRefs, long watchDurationMs, long gcDurationMs, long heapDumpDurationMs) {
        this(new Builder().heapDumpFile(heapDumpFile).referenceKey(referenceKey).referenceName(referenceName).excludedRefs(excludedRefs).computeRetainedHeapSize(true).watchDurationMs(watchDurationMs).gcDurationMs(gcDurationMs).heapDumpDurationMs(heapDumpDurationMs));
    }

    HeapDump(Builder builder) {
        this.heapDumpFile = builder.heapDumpFile;
        this.referenceKey = builder.referenceKey;
        this.referenceName = builder.referenceName;
        this.excludedRefs = builder.excludedRefs;
        this.computeRetainedHeapSize = builder.computeRetainedHeapSize;
        this.watchDurationMs = builder.watchDurationMs;
        this.gcDurationMs = builder.gcDurationMs;
        this.heapDumpDurationMs = builder.heapDumpDurationMs;
        this.reachabilityInspectorClasses = builder.reachabilityInspectorClasses;
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public static final class Builder {
        File heapDumpFile;
        String referenceKey;
        String referenceName;
        ExcludedRefs excludedRefs;
        long watchDurationMs;
        long gcDurationMs;
        long heapDumpDurationMs;
        boolean computeRetainedHeapSize;
        List<Class<? extends Reachability.Inspector>> reachabilityInspectorClasses;

        Builder() {
            this.heapDumpFile = null;
            this.referenceKey = null;
            this.referenceName = "";
            this.excludedRefs = null;
            this.watchDurationMs = 0L;
            this.gcDurationMs = 0L;
            this.heapDumpDurationMs = 0L;
            this.computeRetainedHeapSize = false;
            this.reachabilityInspectorClasses = null;
        }

        Builder(HeapDump heapDump) {
            this.heapDumpFile = heapDump.heapDumpFile;
            this.referenceKey = heapDump.referenceKey;
            this.referenceName = heapDump.referenceName;
            this.excludedRefs = heapDump.excludedRefs;
            this.computeRetainedHeapSize = heapDump.computeRetainedHeapSize;
            this.watchDurationMs = heapDump.watchDurationMs;
            this.gcDurationMs = heapDump.gcDurationMs;
            this.heapDumpDurationMs = heapDump.heapDumpDurationMs;
            this.reachabilityInspectorClasses = heapDump.reachabilityInspectorClasses;
        }

        public Builder heapDumpFile(File heapDumpFile) {
            this.heapDumpFile = Preconditions.checkNotNull(heapDumpFile, "heapDumpFile");
            return this;
        }

        public Builder referenceKey(String referenceKey) {
            this.referenceKey = Preconditions.checkNotNull(referenceKey, "referenceKey");
            return this;
        }

        public Builder referenceName(String referenceName) {
            this.referenceName = Preconditions.checkNotNull(referenceName, "referenceName");
            return this;
        }

        public Builder excludedRefs(ExcludedRefs excludedRefs) {
            this.excludedRefs = Preconditions.checkNotNull(excludedRefs, "excludedRefs");
            return this;
        }

        public Builder watchDurationMs(long watchDurationMs) {
            this.watchDurationMs = watchDurationMs;
            return this;
        }

        public Builder gcDurationMs(long gcDurationMs) {
            this.gcDurationMs = gcDurationMs;
            return this;
        }

        public Builder heapDumpDurationMs(long heapDumpDurationMs) {
            this.heapDumpDurationMs = heapDumpDurationMs;
            return this;
        }

        public Builder computeRetainedHeapSize(boolean computeRetainedHeapSize) {
            this.computeRetainedHeapSize = computeRetainedHeapSize;
            return this;
        }

        public Builder reachabilityInspectorClasses(List<Class<? extends Reachability.Inspector>> reachabilityInspectorClasses) {
            Preconditions.checkNotNull(reachabilityInspectorClasses, "reachabilityInspectorClasses");
            this.reachabilityInspectorClasses = Collections.unmodifiableList(new ArrayList<Class<? extends Reachability.Inspector>>(reachabilityInspectorClasses));
            return this;
        }

        public HeapDump build() {
            Preconditions.checkNotNull(this.excludedRefs, "excludedRefs");
            Preconditions.checkNotNull(this.heapDumpFile, "heapDumpFile");
            Preconditions.checkNotNull(this.referenceKey, "referenceKey");
            Preconditions.checkNotNull(this.reachabilityInspectorClasses, "reachabilityInspectorClasses");
            return new HeapDump(this);
        }
    }

    public static interface Listener {
        public static final Listener NONE = new Listener(){

            @Override
            public void analyze(HeapDump heapDump) {
            }
        };

        public void analyze(HeapDump var1);
    }
}

