/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.support.annotation.NonNull;
import com.squareup.leakcanary.LeakTraceElement;
import com.squareup.leakcanary.Reachability;
import java.io.Serializable;
import java.util.List;

public final class LeakTrace
implements Serializable {
    @NonNull
    public final List<LeakTraceElement> elements;
    @NonNull
    public final List<Reachability> expectedReachability;

    LeakTrace(List<LeakTraceElement> elements, List<Reachability> expectedReachability) {
        this.elements = elements;
        this.expectedReachability = expectedReachability;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.elements.size(); ++i) {
            LeakTraceElement element = this.elements.get(i);
            sb.append("* ");
            if (i != 0) {
                sb.append("\u21b3 ");
            }
            boolean maybeLeakCause = false;
            Reachability currentReachability = this.expectedReachability.get(i);
            if (currentReachability == Reachability.UNKNOWN) {
                maybeLeakCause = true;
            } else if (currentReachability == Reachability.REACHABLE) {
                if (i < this.elements.size() - 1) {
                    Reachability nextReachability = this.expectedReachability.get(i + 1);
                    if (nextReachability != Reachability.REACHABLE) {
                        maybeLeakCause = true;
                    }
                } else {
                    maybeLeakCause = true;
                }
            }
            sb.append(element.toString(maybeLeakCause)).append("\n");
        }
        return sb.toString();
    }

    @NonNull
    public String toDetailedString() {
        String string = "";
        for (LeakTraceElement element : this.elements) {
            string = string + element.toDetailedString();
        }
        return string;
    }
}

