/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerThread {
    private static final Logger logger = LoggerFactory.getLogger(WorkerThread.class);
    private final ExecutorService threadPool;
    private final boolean sleep;
    private final int sleepMillis;
    private final Worker worker;
    private volatile boolean stopWorker = false;
    private volatile Future<Void> future;

    public WorkerThread(Worker worker) {
        this(worker, 15000, true);
    }

    public WorkerThread(Worker worker, boolean sleep) {
        this(worker, 15000, sleep);
    }

    public WorkerThread(Worker worker, int sleepMillis) {
        this(worker, sleepMillis, true);
    }

    public WorkerThread(Worker worker, int sleepMillis, boolean sleep) {
        this.worker = worker;
        this.sleepMillis = sleepMillis;
        this.sleep = sleep;
        this.threadPool = Executors.newSingleThreadExecutor();
    }

    public void start() throws Exception {
        if (this.isRunningTask()) {
            return;
        }
        try {
            this.worker.init();
        }
        catch (Throwable t) {
            this.stopWorker = true;
            this.worker.cleanup();
            this.threadPool.shutdownNow();
            throw new Exception(t);
        }
        this.future = this.threadPool.submit(new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                try {
                    while (!WorkerThread.this.stopWorker) {
                        WorkerThread.this.worker.doWork();
                        if (!WorkerThread.this.sleep || WorkerThread.this.stopWorker) continue;
                        Thread.sleep(WorkerThread.this.sleepMillis);
                    }
                    Void void_ = null;
                    return void_;
                }
                catch (InterruptedException ex) {
                    logger.info("Worker got interrupted, shutting down");
                    Void void_ = null;
                    return void_;
                }
                catch (Throwable t) {
                    logger.info("Worker caught throwable, shutting down", t);
                    Void void_ = null;
                    return void_;
                }
                finally {
                    WorkerThread.this.stopWorker = true;
                    WorkerThread.this.worker.cleanup();
                    WorkerThread.this.threadPool.shutdownNow();
                }
            }
        });
    }

    public void stop() {
        this.stopWorker = true;
        if (this.future != null && !this.future.isDone() && !this.future.isCancelled()) {
            this.future.cancel(true);
        }
        this.threadPool.shutdownNow();
    }

    public void stopAndBlock() {
        this.stop();
        while (!this.threadPool.isTerminated()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public boolean isRunning() {
        return !this.threadPool.isTerminated();
    }

    private boolean isRunningTask() {
        return this.future != null && !this.future.isDone() && !this.future.isCancelled();
    }

    public boolean isStopRequested() {
        return this.stopWorker;
    }

    public static class UnitTest {
        @Test
        public void testNormalFlow() throws Exception {
            Worker worker = (Worker)Mockito.mock(Worker.class);
            WorkerThread thread = new WorkerThread(worker, 20, true);
            thread.start();
            ((Worker)Mockito.verify((Object)worker, (VerificationMode)Mockito.atLeastOnce())).init();
            ((Worker)Mockito.verify((Object)worker, (VerificationMode)Mockito.atMost((int)1))).init();
            Thread.sleep(200L);
            ((Worker)Mockito.verify((Object)worker, (VerificationMode)Mockito.atLeastOnce())).doWork();
            Assert.assertTrue((boolean)thread.isRunning());
            Assert.assertTrue((boolean)thread.isRunningTask());
            thread.stop();
            Thread.sleep(100L);
            ((Worker)Mockito.verify((Object)worker, (VerificationMode)Mockito.atLeastOnce())).cleanup();
            ((Worker)Mockito.verify((Object)worker, (VerificationMode)Mockito.atMost((int)1))).cleanup();
            Assert.assertFalse((boolean)thread.isRunning());
            Assert.assertFalse((boolean)thread.isRunningTask());
        }

        @Test
        public void testBlowUpOnInit() throws Exception {
            Worker worker = (Worker)Mockito.mock(Worker.class);
            ((Worker)Mockito.doAnswer((Answer)new Answer<Void>(){

                public Void answer(InvocationOnMock invocation) throws Throwable {
                    throw new Exception("Kaboom!");
                }
            }).when((Object)worker)).init();
            WorkerThread thread = new WorkerThread(worker, 20, true);
            try {
                thread.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((Worker)Mockito.verify((Object)worker, (VerificationMode)Mockito.atLeastOnce())).init();
            ((Worker)Mockito.verify((Object)worker, (VerificationMode)Mockito.atMost((int)1))).init();
            Thread.sleep(200L);
            ((Worker)Mockito.verify((Object)worker, (VerificationMode)Mockito.never())).doWork();
            Assert.assertFalse((boolean)thread.isRunning());
            Assert.assertFalse((boolean)thread.isRunningTask());
            ((Worker)Mockito.verify((Object)worker, (VerificationMode)Mockito.atLeastOnce())).cleanup();
            ((Worker)Mockito.verify((Object)worker, (VerificationMode)Mockito.atMost((int)1))).cleanup();
        }

        @Test
        public void testBlowUpOnDoWork() throws Exception {
            Worker worker = (Worker)Mockito.mock(Worker.class);
            ((Worker)Mockito.doAnswer((Answer)new Answer<Void>(){
                int count = 0;

                public Void answer(InvocationOnMock invocation) throws Throwable {
                    ++this.count;
                    if (this.count <= 10) {
                        return null;
                    }
                    throw new Exception("Kaboom!");
                }
            }).when((Object)worker)).doWork();
            WorkerThread thread = new WorkerThread(worker, 20, true);
            thread.start();
            ((Worker)Mockito.verify((Object)worker, (VerificationMode)Mockito.atLeastOnce())).init();
            ((Worker)Mockito.verify((Object)worker, (VerificationMode)Mockito.atMost((int)1))).init();
            Thread.sleep(500L);
            ((Worker)Mockito.verify((Object)worker, (VerificationMode)Mockito.atMost((int)11))).doWork();
            Assert.assertFalse((boolean)thread.isRunning());
            Assert.assertFalse((boolean)thread.isRunningTask());
            ((Worker)Mockito.verify((Object)worker, (VerificationMode)Mockito.atLeastOnce())).cleanup();
            ((Worker)Mockito.verify((Object)worker, (VerificationMode)Mockito.atMost((int)1))).cleanup();
        }

        @Test
        public void testStartIsIdempotent() throws Exception {
            Worker worker = (Worker)Mockito.mock(Worker.class);
            WorkerThread thread = new WorkerThread(worker, 20, true);
            thread.start();
            Thread.sleep(200L);
            ((Worker)Mockito.verify((Object)worker, (VerificationMode)Mockito.atLeastOnce())).doWork();
            Assert.assertTrue((boolean)thread.isRunning());
            Assert.assertTrue((boolean)thread.isRunningTask());
            for (int i = 0; i < 1000; ++i) {
                thread.start();
            }
            ((Worker)Mockito.verify((Object)worker, (VerificationMode)Mockito.atLeastOnce())).init();
            ((Worker)Mockito.verify((Object)worker, (VerificationMode)Mockito.atMost((int)1))).init();
            thread.stop();
            Thread.sleep(100L);
            ((Worker)Mockito.verify((Object)worker, (VerificationMode)Mockito.atLeastOnce())).cleanup();
            ((Worker)Mockito.verify((Object)worker, (VerificationMode)Mockito.atMost((int)1))).cleanup();
            Assert.assertFalse((boolean)thread.isRunning());
            Assert.assertFalse((boolean)thread.isRunningTask());
        }
    }

    public static interface Worker {
        public void init() throws Exception;

        public void doWork() throws Exception;

        public void cleanup() throws Exception;
    }
}

