/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.handler;

import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;

public interface PerformanceCriteria {
    public boolean isCritical();

    public int getMaxQueueSize();

    public int numThreads();

    public static class AggClusterPerformanceCriteria
    implements PerformanceCriteria {
        private final DynamicBooleanProperty isCritical;
        private final DynamicIntProperty queueSize;
        private final DynamicIntProperty numThreads;

        public AggClusterPerformanceCriteria(String clusterName) {
            this.isCritical = DynamicPropertyFactory.getInstance().getBooleanProperty("turbine.aggCluster.performance.isCritical." + clusterName, true);
            this.queueSize = DynamicPropertyFactory.getInstance().getIntProperty("turbine.aggCluster.performance.queueSize." + clusterName, 10000);
            this.numThreads = DynamicPropertyFactory.getInstance().getIntProperty("turbine.aggCluster.performance.numThreads." + clusterName, 1);
        }

        @Override
        public boolean isCritical() {
            return this.isCritical.get();
        }

        @Override
        public int getMaxQueueSize() {
            return this.queueSize.get();
        }

        @Override
        public int numThreads() {
            return this.numThreads.get();
        }
    }
}

