/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.discovery;

import com.google.common.collect.Lists;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.turbine.discovery.Instance;
import com.netflix.turbine.discovery.InstanceDiscovery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ConfigPropertyBasedDiscovery
implements InstanceDiscovery {
    private static final DynamicStringProperty DefaultClusterInstanceList = DynamicPropertyFactory.getInstance().getStringProperty("turbine.ConfigPropertyBasedDiscovery.default.instances", null);
    private static final DynamicStringProperty ClusterList = DynamicPropertyFactory.getInstance().getStringProperty("turbine.aggregator.clusterConfig", null);

    @Override
    public Collection<Instance> getInstanceList() throws Exception {
        List<String> clusters = this.getClusterList();
        ArrayList<Instance> instances = new ArrayList<Instance>();
        for (String cluster : clusters) {
            instances.addAll(this.getInstancesForCluster(cluster));
        }
        return instances;
    }

    private List<String> getClusterList() throws Exception {
        String clusterConfig = ClusterList.get();
        if (clusterConfig == null || clusterConfig.trim().length() == 0) {
            String defaultInstannceList = DefaultClusterInstanceList.get();
            if (defaultInstannceList == null || defaultInstannceList.trim().length() == 0) {
                throw new Exception("Must configure instance list using property: " + DefaultClusterInstanceList.getName());
            }
            return Lists.newArrayList((Object[])new String[]{"default"});
        }
        ArrayList clusters = Lists.newArrayList((Object[])clusterConfig.trim().split(","));
        if (clusters.size() == 0) {
            throw new Exception("Must configure property: " + ClusterList.getName());
        }
        return clusters;
    }

    private List<Instance> getInstancesForCluster(String cluster) throws Exception {
        DynamicStringProperty instanceListProp = DynamicPropertyFactory.getInstance().getStringProperty("turbine.ConfigPropertyBasedDiscovery." + cluster + ".instances", null);
        String instanceList = instanceListProp.get();
        if (instanceList == null || instanceList.trim().length() == 0) {
            throw new Exception("Must configure Instance list property: " + instanceListProp.getName());
        }
        String[] parts = instanceList.split(",");
        ArrayList<Instance> instances = new ArrayList<Instance>();
        for (String s : parts) {
            instances.add(new Instance(s, cluster, true));
        }
        return instances;
    }

    public static class UnitTest {
        @Test(expected=Exception.class)
        public void testNothingConfigured() throws Exception {
            new ConfigPropertyBasedDiscovery().getInstanceList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test(expected=Exception.class)
        public void testWrongClusterConfigured() throws Exception {
            ConfigurationManager.getConfigInstance().setProperty("turbine.aggregator.clusterConfig", (Object)"test");
            try {
                new ConfigPropertyBasedDiscovery().getInstanceList();
            }
            finally {
                ConfigurationManager.getConfigInstance().setProperty("turbine.aggregator.clusterConfig", (Object)"");
            }
        }

        @Test
        public void testUsingDefaults() throws Exception {
            ConfigurationManager.getConfigInstance().setProperty("turbine.ConfigPropertyBasedDiscovery.default.instances", (Object)"foo,bar");
            List instances = (List)new ConfigPropertyBasedDiscovery().getInstanceList();
            Assert.assertEquals((Object)"foo", (Object)((Instance)instances.get(0)).getHostname());
            Assert.assertEquals((Object)"default", (Object)((Instance)instances.get(0)).getCluster());
            Assert.assertEquals((Object)"bar", (Object)((Instance)instances.get(1)).getHostname());
            Assert.assertEquals((Object)"default", (Object)((Instance)instances.get(1)).getCluster());
            ConfigurationManager.getConfigInstance().setProperty("turbine.ConfigPropertyBasedDiscovery.default.instances", (Object)"");
        }

        @Test
        public void testUsingConfiguredCluster() throws Exception {
            ConfigurationManager.getConfigInstance().setProperty("turbine.aggregator.clusterConfig", (Object)"test");
            ConfigurationManager.getConfigInstance().setProperty("turbine.ConfigPropertyBasedDiscovery.test.instances", (Object)"foo1,bar1");
            List instances = (List)new ConfigPropertyBasedDiscovery().getInstanceList();
            Assert.assertEquals((Object)"foo1", (Object)((Instance)instances.get(0)).getHostname());
            Assert.assertEquals((Object)"test", (Object)((Instance)instances.get(0)).getCluster());
            Assert.assertEquals((Object)"bar1", (Object)((Instance)instances.get(1)).getHostname());
            Assert.assertEquals((Object)"test", (Object)((Instance)instances.get(1)).getCluster());
            ConfigurationManager.getConfigInstance().setProperty("turbine.aggregator.clusterConfig", (Object)"");
            ConfigurationManager.getConfigInstance().setProperty("turbine.ConfigPropertyBasedDiscovery.default.instances", (Object)"");
        }
    }
}

