/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.data;

import com.netflix.turbine.data.TurbineData;
import com.netflix.turbine.discovery.Instance;
import com.netflix.turbine.monitor.TurbineDataMonitor;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class DataFromSingleInstance
extends TurbineData {
    private final Instance host;
    private final HashMap<String, Long> numericAttributes;
    private final HashMap<String, String> stringAttributes;
    private final HashMap<String, Map<String, ? extends Number>> nestedMapAttrs;

    public DataFromSingleInstance(TurbineDataMonitor<DataFromSingleInstance> monitor, String type, String name, Instance host, HashMap<String, Object> attributes, long dateTime) {
        super(monitor, type, name);
        this.host = host;
        super.setCreationTime(dateTime);
        this.numericAttributes = new HashMap();
        this.stringAttributes = new HashMap();
        this.nestedMapAttrs = new HashMap();
        for (String key : attributes.keySet()) {
            Object value = attributes.get(key);
            if (value instanceof Integer || value instanceof Long) {
                long longValue = Long.parseLong(String.valueOf(value));
                this.numericAttributes.put(key, longValue);
                continue;
            }
            if (value instanceof Map) {
                this.nestedMapAttrs.put(key, (Map)value);
                continue;
            }
            this.stringAttributes.put(key, String.valueOf(value));
        }
    }

    public DataFromSingleInstance(TurbineDataMonitor<DataFromSingleInstance> monitor, String type, String name, Instance host, HashMap<String, Long> nAttrs, HashMap<String, String> sAttrs, long dataTime) {
        this(monitor, type, name, host, nAttrs, sAttrs, new HashMap<String, Map<String, ? extends Number>>(), dataTime);
    }

    public DataFromSingleInstance(TurbineDataMonitor<DataFromSingleInstance> monitor, String type, String name, Instance host, HashMap<String, Long> nAttrs, HashMap<String, String> sAttrs, HashMap<String, Map<String, ? extends Number>> mapAttrs, long dataTime) {
        super(monitor, type, name);
        this.host = host;
        super.setCreationTime(dataTime);
        this.numericAttributes = nAttrs;
        this.stringAttributes = sAttrs;
        this.nestedMapAttrs = mapAttrs;
    }

    @Override
    public HashMap<String, Long> getNumericAttributes() {
        return this.numericAttributes;
    }

    @Override
    public HashMap<String, String> getStringAttributes() {
        return this.stringAttributes;
    }

    @Override
    public HashMap<String, Map<String, ? extends Number>> getNestedMapAttributes() {
        return this.nestedMapAttrs;
    }

    public Instance getHost() {
        return this.host;
    }

    public static class UnitTest {
        @Test
        public void testParseAttributes() throws Exception {
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            attrs.put("s1", "v1");
            attrs.put("n1", 1234);
            attrs.put("b1", true);
            attrs.put("b2", false);
            HashMap<String, Integer> nestedAttrs1 = new HashMap<String, Integer>();
            nestedAttrs1.put("v1", 10);
            nestedAttrs1.put("v2", 11);
            attrs.put("nested1", nestedAttrs1);
            HashMap<String, Long> nestedAttrs2 = new HashMap<String, Long>();
            nestedAttrs2.put("v1", 10L);
            nestedAttrs2.put("v2", 11L);
            attrs.put("nested2", nestedAttrs2);
            Instance host = new Instance("host", "cluster", true);
            DataFromSingleInstance data = new DataFromSingleInstance(null, "type", "name", host, attrs, System.currentTimeMillis());
            Assert.assertEquals((Object)"v1", (Object)data.getStringAttributes().get("s1"));
            Assert.assertEquals((Object)"true", (Object)data.getStringAttributes().get("b1"));
            Assert.assertEquals((Object)"false", (Object)data.getStringAttributes().get("b2"));
            Assert.assertTrue((1234L == data.getNumericAttributes().get("n1") ? 1 : 0) != 0);
            Assert.assertTrue((10 == data.getNestedMapAttributes().get("nested1").get("v1").intValue() ? 1 : 0) != 0);
            Assert.assertTrue((11 == data.getNestedMapAttributes().get("nested1").get("v2").intValue() ? 1 : 0) != 0);
            Assert.assertTrue((10 == data.getNestedMapAttributes().get("nested2").get("v1").intValue() ? 1 : 0) != 0);
            Assert.assertTrue((11 == data.getNestedMapAttributes().get("nested2").get("v2").intValue() ? 1 : 0) != 0);
        }
    }
}

