/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.hystrix;

import com.netflix.hystrix.HystrixObservableCommand;
import com.netflix.ribbon.CacheProvider;
import java.util.Map;
import rx.Observable;

public class CacheObservableCommand<T>
extends HystrixObservableCommand<T> {
    private final CacheProvider<T> cacheProvider;
    private final String key;
    private final String hystrixCacheKey;
    private final Map<String, Object> requestProperties;

    public CacheObservableCommand(CacheProvider<T> cacheProvider, String key, String hystrixCacheKey, Map<String, Object> requestProperties, HystrixObservableCommand.Setter setter) {
        super(setter);
        this.cacheProvider = cacheProvider;
        this.key = key;
        this.hystrixCacheKey = hystrixCacheKey;
        this.requestProperties = requestProperties;
    }

    protected String getCacheKey() {
        if (this.hystrixCacheKey == null) {
            return super.getCacheKey();
        }
        return this.hystrixCacheKey;
    }

    protected Observable<T> run() {
        return this.cacheProvider.get(this.key, this.requestProperties);
    }
}

