/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.http;

import com.netflix.hystrix.HystrixExecutableInfo;
import com.netflix.hystrix.HystrixObservableCommand;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import com.netflix.ribbon.ResponseValidator;
import com.netflix.ribbon.ServerError;
import com.netflix.ribbon.UnsuccessfulResponseException;
import com.netflix.ribbon.hystrix.FallbackHandler;
import io.netty.buffer.ByteBuf;
import io.reactivex.netty.protocol.http.client.HttpClient;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import java.util.Map;
import rx.Observable;
import rx.functions.Func1;

public class HttpResourceObservableCommand<T>
extends HystrixObservableCommand<T> {
    private final HttpClient<ByteBuf, ByteBuf> httpClient;
    private final HttpClientRequest<ByteBuf> httpRequest;
    private final String hystrixCacheKey;
    private final Map<String, Object> requestProperties;
    private final FallbackHandler<T> fallbackHandler;
    private final Class<? extends T> classType;
    private final ResponseValidator<HttpClientResponse<ByteBuf>> validator;

    public HttpResourceObservableCommand(HttpClient<ByteBuf, ByteBuf> httpClient, HttpClientRequest<ByteBuf> httpRequest, String hystrixCacheKey, Map<String, Object> requestProperties, FallbackHandler<T> fallbackHandler, ResponseValidator<HttpClientResponse<ByteBuf>> validator, Class<? extends T> classType, HystrixObservableCommand.Setter setter) {
        super(setter);
        this.httpClient = httpClient;
        this.fallbackHandler = fallbackHandler;
        this.validator = validator;
        this.httpRequest = httpRequest;
        this.hystrixCacheKey = hystrixCacheKey;
        this.classType = classType;
        this.requestProperties = requestProperties;
    }

    protected String getCacheKey() {
        if (this.hystrixCacheKey == null) {
            return super.getCacheKey();
        }
        return this.hystrixCacheKey;
    }

    protected Observable<T> getFallback() {
        if (this.fallbackHandler == null) {
            return super.getFallback();
        }
        return this.fallbackHandler.getFallback((HystrixExecutableInfo<?>)this, this.requestProperties);
    }

    protected Observable<T> run() {
        Observable httpResponseObservable = this.httpClient.submit(this.httpRequest);
        if (this.validator != null) {
            httpResponseObservable = httpResponseObservable.map((Func1)new Func1<HttpClientResponse<ByteBuf>, HttpClientResponse<ByteBuf>>(){

                public HttpClientResponse<ByteBuf> call(HttpClientResponse<ByteBuf> t1) {
                    try {
                        HttpResourceObservableCommand.this.validator.validate(t1);
                    }
                    catch (UnsuccessfulResponseException e) {
                        throw new HystrixBadRequestException("Unsuccessful response", (Throwable)e);
                    }
                    catch (ServerError e) {
                        throw new RuntimeException(e);
                    }
                    return t1;
                }
            });
        }
        return httpResponseObservable.flatMap(new Func1<HttpClientResponse<ByteBuf>, Observable<T>>(){

            public Observable<T> call(HttpClientResponse<ByteBuf> t1) {
                return t1.getContent().map(new Func1<ByteBuf, T>(){

                    public T call(ByteBuf t1) {
                        return HttpResourceObservableCommand.this.classType.cast(t1);
                    }
                });
            }
        });
    }
}

