/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.util;

import com.wechat.pay.java.core.util.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;

public class PemUtil {
    private PemUtil() {
    }

    public static PrivateKey loadPrivateKeyFromString(String keyString) {
        try {
            keyString = keyString.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replaceAll("\\s+", "");
            return KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(Base64.getDecoder().decode(keyString)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static PrivateKey loadPrivateKeyFromString(String keyString, String algorithm, String provider) {
        try {
            keyString = keyString.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replaceAll("\\s+", "");
            return KeyFactory.getInstance(algorithm, provider).generatePrivate(new PKCS8EncodedKeySpec(Base64.getDecoder().decode(keyString)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (NoSuchProviderException | InvalidKeySpecException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static PrivateKey loadPrivateKeyFromPath(String keyPath) {
        return PemUtil.loadPrivateKeyFromString(PemUtil.readPrivateKeyStringFromPath(keyPath));
    }

    public static PrivateKey loadPrivateKeyFromPath(String keyPath, String algorithm, String provider) {
        return PemUtil.loadPrivateKeyFromString(PemUtil.readPrivateKeyStringFromPath(keyPath), algorithm, provider);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readPrivateKeyStringFromPath(String keyPath) {
        try (FileInputStream inputStream = new FileInputStream(keyPath);){
            String string = IOUtil.toString(inputStream);
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static X509Certificate loadX509FromStream(InputStream inputStream) {
        try {
            return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(inputStream);
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static X509Certificate loadX509FromStream(InputStream inputStream, String provider) {
        try {
            return (X509Certificate)CertificateFactory.getInstance("X.509", provider).generateCertificate(inputStream);
        }
        catch (NoSuchProviderException | CertificateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate loadX509FromPath(String certificatePath) {
        try (FileInputStream inputStream = new FileInputStream(certificatePath);){
            X509Certificate x509Certificate = PemUtil.loadX509FromStream(inputStream);
            return x509Certificate;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate loadX509FromPath(String certificatePath, String provider) {
        try (FileInputStream inputStream = new FileInputStream(certificatePath);){
            X509Certificate x509Certificate = PemUtil.loadX509FromStream(inputStream, provider);
            return x509Certificate;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate loadX509FromString(String certificateString) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(certificateString.getBytes(StandardCharsets.UTF_8));){
            X509Certificate x509Certificate = PemUtil.loadX509FromStream(inputStream);
            return x509Certificate;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate loadX509FromString(String certificateString, String provider) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(certificateString.getBytes(StandardCharsets.UTF_8));){
            X509Certificate x509Certificate = PemUtil.loadX509FromStream(inputStream, provider);
            return x509Certificate;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String getSerialNumber(X509Certificate certificate) {
        return certificate.getSerialNumber().toString(16).toUpperCase();
    }
}

